/*
 * Decompiled with CFR 0.152.
 */
package com.objectplanet.gui;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class TableData {
    private Vector data;
    private Hashtable keyMap = new Hashtable();
    private int columnCount;
    private int rowCount;
    private long lastChange;

    public synchronized void removeAll() {
        this.keyMap.clear();
        this.data.removeAllElements();
        this.rowCount = 0;
        this.lastChange = System.currentTimeMillis();
    }

    public boolean hasChangedSince(long l) {
        return this.lastChange >= l;
    }

    public synchronized void removeRow(int n) {
        try {
            this.data.removeElementAt(n);
            this.rowCount = Math.max(0, this.rowCount - 1);
            Enumeration enumeration = this.keyMap.keys();
            while (enumeration.hasMoreElements()) {
                Object k = enumeration.nextElement();
                int n2 = (Integer)this.keyMap.get(k);
                if (n2 > n) {
                    this.keyMap.put(k, new Integer(n2 - 1));
                    continue;
                }
                if (n2 != n) continue;
                this.keyMap.remove(k);
            }
            this.lastChange = System.currentTimeMillis();
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {}
    }

    public synchronized int getRowCount() {
        return this.rowCount;
    }

    public TableData(int n) {
        this.data = new Vector();
        this.columnCount = n;
    }

    synchronized void setColumnCount(int n) {
        if (n != this.getColumnCount()) {
            n = Math.max(1, n);
            int n2 = this.data.size();
            int n3 = 0;
            while (n3 < n2) {
                Object[] objectArray = (Object[])this.data.elementAt(n3);
                if (objectArray != null) {
                    Object[] objectArray2 = new Object[n];
                    System.arraycopy(objectArray, 0, objectArray2, 0, Math.min(objectArray.length, objectArray2.length));
                    this.data.setElementAt(objectArray2, n3);
                }
                ++n3;
            }
            this.columnCount = n;
        }
    }

    public synchronized int getColumnCount() {
        return this.columnCount;
    }

    public synchronized int getLastIndex() {
        return this.data.size() - 1;
    }

    public synchronized int getRowIndex(Object object) {
        Integer n;
        if (object != null && (n = (Integer)this.keyMap.get(object)) != null) {
            return n;
        }
        return -1;
    }

    public synchronized void setCell(int n, int n2, Object object) {
        if (n2 < 0 || n2 >= this.getColumnCount()) {
            throw new IllegalArgumentException("invalid column: " + n2);
        }
        if (n < 0 || n >= this.data.size()) {
            throw new IllegalArgumentException("invalid row: " + n);
        }
        if (object instanceof String) {
            Object[] objectArray = (Object[])this.data.elementAt(n);
            if (objectArray != null) {
                objectArray[n2] = object;
                this.lastChange = System.currentTimeMillis();
            }
        } else {
            throw new ClassCastException("value is not a String");
        }
    }

    public synchronized boolean containsRow(int n) {
        if (n >= 0 && n < this.data.size()) {
            return this.data.elementAt(n) != null;
        }
        return false;
    }

    public synchronized Object getCell(int n, int n2) {
        Object[] objectArray;
        if (n2 < 0 || n2 >= this.getColumnCount()) {
            throw new IllegalArgumentException("invalid column: " + n2);
        }
        if (n >= 0 && n < this.data.size() && (objectArray = (Object[])this.data.elementAt(n)) != null && n2 < objectArray.length) {
            return objectArray[n2];
        }
        return null;
    }

    public synchronized int setRow(int n, Object[] objectArray) {
        return this.setRow(n, null, objectArray);
    }

    public synchronized int setRow(int n, Object object, Object[] objectArray) {
        try {
            if (n <= -1) {
                n = this.data.size();
            }
            if (n >= this.data.size()) {
                this.data.ensureCapacity(n + 50);
                this.data.setSize(n + 1);
            }
            if (!this.containsRow(n)) {
                ++this.rowCount;
            }
            this.data.setElementAt(objectArray, n);
            if (object != null) {
                this.keyMap.put(object, new Integer(n));
            }
            this.lastChange = System.currentTimeMillis();
        }
        catch (OutOfMemoryError outOfMemoryError) {
            System.out.println("Out of memory, could not add row at index: " + n);
        }
        return n;
    }

    public synchronized Object[] getRow(int n) {
        return (Object[])this.data.elementAt(n);
    }
}

