/*
 * Decompiled with CFR 0.152.
 */
package com.objectplanet.chart;

import com.objectplanet.chart.ChartSample;
import java.io.Serializable;
import java.util.Hashtable;

public class ChartData
implements Serializable {
    private ChartSample[][] data;
    private Hashtable sampleLookup;
    private String[] seriesLabels;
    private String[] sampleLabels;
    private int seriesCount;
    private int sampleCount;
    private long changedTime;

    public synchronized ChartSample getSample(Object object) {
        return (ChartSample)this.sampleLookup.get(object);
    }

    public synchronized int appendSample(int n, ChartSample chartSample, boolean bl) {
        if (n < 0 || n >= this.seriesCount) {
            throw new IllegalArgumentException("Illegal serie: " + n);
        }
        this.changedTime = System.currentTimeMillis();
        int n2 = -1;
        int n3 = 0;
        while (n3 < this.sampleCount) {
            ChartSample chartSample2 = this.data[n][n3];
            if (chartSample2 == null || chartSample2.value == null) {
                n2 = n3;
                break;
            }
            ++n3;
        }
        if (n2 >= 0) {
            this.setSample(n, n2, chartSample);
            return n2;
        }
        if (bl) {
            n3 = this.sampleCount;
            this.setSampleCount(n3 + 1);
            this.setSample(n, n3, chartSample);
            return n3;
        }
        if (this.sampleCount > 0) {
            n3 = 0;
            while (n3 < this.sampleLabels.length - 1) {
                this.sampleLabels[n3] = this.sampleLabels[n3 + 1];
                ++n3;
            }
            n3 = 0;
            while (n3 < this.data[n].length - 1) {
                this.data[n][n3] = this.data[n][n3 + 1];
                ++n3;
            }
            this.setSample(n, this.sampleCount - 1, chartSample);
            return this.sampleCount - 1;
        }
        return -1;
    }

    public synchronized void setSample(int n, int n2, ChartSample chartSample) {
        if (n < 0 || n >= this.data.length) {
            throw new IllegalArgumentException("Invalid series: " + n);
        }
        try {
            chartSample.setIndex(n2);
            chartSample.setSeries(n);
            this.data[n][n2] = chartSample;
            if (chartSample.key == null) {
                chartSample.key = n + "." + n2;
            }
            this.sampleLookup.put(chartSample.key, chartSample);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new IllegalArgumentException("Invalid index: " + n2);
        }
        catch (NullPointerException nullPointerException) {
            System.out.println("Internal error: setSample(serie, index, sample) method");
        }
        this.setIndividualSampleLabel(n, n2);
        this.changedTime = System.currentTimeMillis();
    }

    public synchronized void setSeriesLabel(int n, String string) {
        try {
            this.seriesLabels[n] = string;
            int n2 = 0;
            while (n2 < this.sampleCount) {
                this.setIndividualSampleLabel(n, n2);
                ++n2;
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new IllegalArgumentException("Invalid series: " + n);
        }
        this.changedTime = System.currentTimeMillis();
    }

    public synchronized String getSeriesLabel(int n) {
        try {
            return this.seriesLabels[n];
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new IllegalArgumentException("Invalid series: " + n);
        }
    }

    private void setIndividualSampleLabel(int n, int n2) {
        try {
            ChartSample chartSample = this.data[n][n2];
            if (chartSample != null) {
                String string = this.seriesLabels[n];
                String string2 = this.sampleLabels[n2];
                String string3 = "";
                if (string != null && string2 != null) {
                    string3 = string + " " + string2;
                } else if (string != null) {
                    string3 = string;
                } else if (string2 != null) {
                    string3 = string2;
                }
                chartSample.setLabel(string3);
            }
        }
        catch (Exception exception) {
            System.out.println("Internal error: ChartData.setIndividualSampleLabel(serie, sample)");
        }
    }

    public double getMaxValue(int n) {
        boolean bl = n >= 0 && n < this.seriesCount;
        boolean bl2 = false;
        double d = -1.7976931348623157E308;
        if (bl) {
            int n2 = 0;
            while (n2 < this.sampleCount) {
                ChartSample chartSample = this.data[n][n2];
                if (chartSample != null && chartSample.value != null && !chartSample.value.isNaN()) {
                    d = Math.max(d, chartSample.getFloatValue());
                    bl2 = true;
                }
                ++n2;
            }
        } else {
            int n3 = 0;
            while (n3 < this.seriesCount) {
                int n4 = 0;
                while (n4 < this.sampleCount) {
                    ChartSample chartSample = this.data[n3][n4];
                    if (chartSample != null && chartSample.value != null && !chartSample.value.isNaN()) {
                        d = Math.max(d, chartSample.getFloatValue());
                        bl2 = true;
                    }
                    ++n4;
                }
                ++n3;
            }
        }
        if (bl2) {
            return d;
        }
        return 0.0;
    }

    public synchronized void setSampleValue(int n, int n2, double d) {
        if (n < 0 || n >= this.data.length) {
            throw new IllegalArgumentException("Invalid series: " + n);
        }
        try {
            if (this.data[n][n2] == null) {
                this.data[n][n2] = new ChartSample(n2);
                this.data[n][n2].setSeries(n);
                this.data[n][n2].key = n + "." + n2;
                this.sampleLookup.put(this.data[n][n2].key, this.data[n][n2]);
            }
            this.data[n][n2].setValue(d);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new IllegalArgumentException("Invalid index: " + n2);
        }
        catch (NullPointerException nullPointerException) {
            System.out.println("Internal error: setSampleValue(serie, index, value) method");
        }
        this.setIndividualSampleLabel(n, n2);
        this.changedTime = System.currentTimeMillis();
    }

    public synchronized double getSampleValue(int n, int n2) {
        if (n < 0 || n >= this.data.length) {
            throw new IllegalArgumentException("Invalid series: " + n);
        }
        if (this.data[n] == null) {
            return 0.0;
        }
        if (n2 < 0 || n2 >= this.data[n].length) {
            throw new IllegalArgumentException("Invalid index: " + n2);
        }
        if (this.data[n][n2] != null) {
            return this.data[n][n2].getFloatValue();
        }
        return 0.0;
    }

    public synchronized int appendSampleValue(int n, double d, boolean bl) {
        if (n < 0 || n >= this.seriesCount) {
            throw new IllegalArgumentException("Illegal serie: " + n);
        }
        this.changedTime = System.currentTimeMillis();
        int n2 = -1;
        int n3 = 0;
        while (n3 < this.sampleCount) {
            ChartSample chartSample = this.data[n][n3];
            if (chartSample == null || chartSample.value == null) {
                n2 = n3;
                break;
            }
            ++n3;
        }
        if (n2 >= 0) {
            this.setSampleValue(n, n2, d);
            return n2;
        }
        if (bl) {
            n3 = this.sampleCount;
            this.setSampleCount(n3 + 1);
            this.setSampleValue(n, n3, d);
            return n3;
        }
        if (this.sampleCount > 0) {
            double[] dArray = this.getSampleValues(n);
            int n4 = 0;
            while (n4 < dArray.length - 1) {
                dArray[n4] = dArray[n4 + 1];
                ++n4;
            }
            dArray[dArray.length - 1] = d;
            this.setSampleValues(n, dArray);
            return dArray.length - 1;
        }
        return -1;
    }

    public synchronized void setSamples(int n, ChartSample[] chartSampleArray) {
        if (n < 0 || n >= this.data.length) {
            throw new IllegalArgumentException("Invalid series: " + n);
        }
        if (this.data[n] == null) {
            this.data[n] = new ChartSample[this.sampleCount];
        }
        int n2 = 0;
        while (n2 < this.sampleCount) {
            if (chartSampleArray != null && n2 < chartSampleArray.length && chartSampleArray[n2] != null) {
                chartSampleArray[n2].setIndex(n2);
                chartSampleArray[n2].setSeries(n);
                this.data[n][n2] = chartSampleArray[n2];
                if (chartSampleArray[n2].key == null) {
                    chartSampleArray[n2].key = n + "." + n2;
                }
                this.sampleLookup.put(chartSampleArray[n2].key, chartSampleArray[n2]);
            } else {
                this.data[n][n2] = null;
            }
            ++n2;
        }
        this.setIndividualSampleLabels();
        this.changedTime = System.currentTimeMillis();
    }

    public synchronized ChartSample[] getSamples(int n) {
        try {
            return this.data[n];
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new IllegalArgumentException("Invalid series: " + n);
        }
    }

    public synchronized void setSampleValues(int n, double[] dArray) {
        if (n < 0 || n >= this.data.length) {
            throw new IllegalArgumentException("Invalid series: " + n);
        }
        if (this.data[n] == null) {
            this.data[n] = new ChartSample[this.sampleCount];
        }
        int n2 = 0;
        while (n2 < this.sampleCount) {
            double d = Double.NaN;
            if (dArray != null && n2 < dArray.length) {
                d = dArray[n2];
            }
            if (this.data[n][n2] == null) {
                this.data[n][n2] = new ChartSample(n2);
                this.data[n][n2].setSeries(n);
                this.data[n][n2].key = n + "." + n2;
                this.sampleLookup.put(this.data[n][n2].key, this.data[n][n2]);
            }
            this.data[n][n2].setValue(d);
            ++n2;
        }
        this.setIndividualSampleLabels();
        this.changedTime = System.currentTimeMillis();
    }

    public synchronized double[] getSampleValues(int n) {
        try {
            ChartSample[] chartSampleArray = this.data[n];
            double[] dArray = new double[chartSampleArray.length];
            int n2 = 0;
            while (n2 < chartSampleArray.length) {
                if (chartSampleArray[n2] != null) {
                    dArray[n2] = chartSampleArray[n2].getFloatValue();
                }
                ++n2;
            }
            return dArray;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new IllegalArgumentException("Invalid series: " + n);
        }
        catch (Exception exception) {
            System.out.println("Internal error: ChartData.getSampleValues(serie)");
            return null;
        }
    }

    public synchronized void setSampleLabels(String[] stringArray) {
        if (stringArray != null && stringArray.length > this.sampleLabels.length) {
            this.sampleLabels = new String[stringArray.length];
        }
        int n = Math.max(stringArray != null ? stringArray.length : 0, this.sampleLabels.length);
        int n2 = 0;
        while (n2 < n) {
            if (n2 < this.sampleLabels.length) {
                this.sampleLabels[n2] = stringArray == null ? null : (n2 < stringArray.length ? stringArray[n2] : null);
            }
            ++n2;
        }
        this.setIndividualSampleLabels();
        this.changedTime = System.currentTimeMillis();
    }

    public synchronized String[] getSampleLabels() {
        if (this.sampleLabels != null) {
            return this.sampleLabels;
        }
        return new String[0];
    }

    public boolean hasChangedSince(long l) {
        return this.changedTime >= l;
    }

    public synchronized void setSeriesCount(int n) {
        this.setDataCount(n, this.sampleCount);
    }

    public synchronized int getSeriesCount() {
        return this.seriesCount;
    }

    public double getMinValue(int n) {
        boolean bl = n >= 0 && n < this.seriesCount;
        boolean bl2 = false;
        double d = Double.MAX_VALUE;
        if (bl) {
            int n2 = 0;
            while (n2 < this.sampleCount) {
                ChartSample chartSample = this.data[n][n2];
                if (chartSample != null && chartSample.value != null && !chartSample.value.isNaN()) {
                    d = Math.min(d, chartSample.getFloatValue());
                    bl2 = true;
                }
                ++n2;
            }
        } else {
            int n3 = 0;
            while (n3 < this.seriesCount) {
                int n4 = 0;
                while (n4 < this.sampleCount) {
                    ChartSample chartSample = this.data[n3][n4];
                    if (chartSample != null && chartSample.value != null && !chartSample.value.isNaN()) {
                        d = Math.min(d, chartSample.getFloatValue());
                        bl2 = true;
                    }
                    ++n4;
                }
                ++n3;
            }
        }
        if (bl2) {
            return d;
        }
        return 0.0;
    }

    private void setDataCount(int n, int n2) {
        int n3;
        if (this.seriesCount == n && this.sampleCount == n2) {
            return;
        }
        this.seriesCount = Math.max(0, n);
        this.sampleCount = Math.max(0, n2);
        ChartSample[][] chartSampleArray = new ChartSample[this.seriesCount][this.sampleCount];
        int n4 = 0;
        while (n4 < chartSampleArray.length) {
            if (n4 < this.data.length) {
                ChartSample[] chartSampleArray2 = chartSampleArray[n4];
                n3 = 0;
                while (n3 < chartSampleArray2.length) {
                    if (n3 < this.data[n4].length) {
                        chartSampleArray[n4][n3] = this.data[n4][n3];
                    }
                    ++n3;
                }
            }
            ++n4;
        }
        this.data = chartSampleArray;
        String[] stringArray = new String[this.seriesCount];
        int n5 = 0;
        while (n5 < stringArray.length) {
            if (n5 < this.seriesLabels.length) {
                stringArray[n5] = this.seriesLabels[n5];
            }
            ++n5;
        }
        this.seriesLabels = stringArray;
        String[] stringArray2 = new String[this.sampleCount];
        n3 = 0;
        while (n3 < stringArray2.length) {
            if (n3 < this.sampleLabels.length) {
                stringArray2[n3] = this.sampleLabels[n3];
            }
            ++n3;
        }
        this.sampleLabels = stringArray2;
        this.changedTime = System.currentTimeMillis();
    }

    public String toString() {
        return "ChartData " + this.seriesCount + " series, " + this.sampleCount + " samples";
    }

    public ChartData(int n, int n2) {
        this.seriesCount = Math.max(0, n);
        this.sampleCount = Math.max(0, n2);
        this.data = new ChartSample[this.seriesCount][];
        int n3 = 0;
        while (n3 < this.data.length) {
            this.data[n3] = new ChartSample[this.sampleCount];
            ++n3;
        }
        this.seriesLabels = new String[this.seriesCount];
        this.sampleLabels = new String[this.sampleCount];
        n3 = Math.max(1, n2) * Math.max(1, n);
        this.sampleLookup = new Hashtable(n3);
        this.changedTime = System.currentTimeMillis();
    }

    public boolean isSelected(int n, int n2) {
        if (n < -1 || n >= this.seriesCount) {
            throw new IllegalArgumentException("Invalid series index: " + n);
        }
        if (n2 < -1 || n2 >= this.sampleCount) {
            throw new IllegalArgumentException("Invalid sample index: " + n2);
        }
        boolean bl = true;
        if (n == -1 && n2 == -1) {
            int n3 = 0;
            while (n3 < this.seriesCount) {
                int n4 = 0;
                while (n4 < this.sampleCount) {
                    if (this.data[n3] == null || this.data[n3][n4] == null || !this.data[n3][n4].isSelected()) {
                        bl = false;
                    }
                    ++n4;
                }
                ++n3;
            }
        } else if (n2 == -1) {
            int n5 = 0;
            while (n5 < this.sampleCount) {
                if (this.data[n] != null && this.data[n][n5] != null && !this.data[n][n5].isSelected()) {
                    bl = false;
                }
                ++n5;
            }
        } else if (n == -1) {
            int n6 = 0;
            while (n6 < this.seriesCount) {
                if (this.data[n6] != null && this.data[n6][n2] != null && !this.data[n6][n2].isSelected()) {
                    bl = false;
                }
                ++n6;
            }
        } else if (this.data[n] == null || this.data[n][n2] == null || !this.data[n][n2].isSelected()) {
            bl = false;
        }
        return bl;
    }

    public synchronized void setSampleCount(int n) {
        this.setDataCount(this.seriesCount, n);
    }

    public synchronized int getSampleCount() {
        return this.sampleCount;
    }

    public synchronized void setSampleLabel(int n, String string) {
        try {
            this.sampleLabels[n] = string;
            int n2 = 0;
            while (n2 < this.seriesCount) {
                this.setIndividualSampleLabel(n2, n);
                ++n2;
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new IllegalArgumentException("Invalid index: " + n);
        }
        this.changedTime = System.currentTimeMillis();
    }

    public synchronized String getSampleLabel(int n) {
        try {
            return this.sampleLabels[n];
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new IllegalArgumentException("Invalid index: " + n);
        }
    }

    public synchronized void setSeriesLabels(String[] stringArray) {
        int n = 0;
        while (n < this.seriesCount) {
            this.seriesLabels[n] = stringArray == null ? null : (n < stringArray.length ? stringArray[n] : null);
            ++n;
        }
        this.setIndividualSampleLabels();
        this.changedTime = System.currentTimeMillis();
    }

    public synchronized String[] getSeriesLabels() {
        String[] stringArray = new String[this.seriesCount];
        System.arraycopy(this.seriesLabels, 0, stringArray, 0, stringArray.length);
        return stringArray;
    }

    private void setIndividualSampleLabels() {
        int n = 0;
        while (n < this.seriesCount) {
            ChartSample[] chartSampleArray = this.data[n];
            if (chartSampleArray != null) {
                int n2 = 0;
                while (n2 < chartSampleArray.length) {
                    if (chartSampleArray[n2] != null) {
                        String string = this.seriesLabels[n];
                        String string2 = this.sampleLabels[n2];
                        if (string != null && string2 != null) {
                            chartSampleArray[n2].setLabel(string + " " + string2);
                        } else if (string != null) {
                            chartSampleArray[n2].setLabel(string);
                        } else if (string2 != null) {
                            chartSampleArray[n2].setLabel(string2);
                        }
                    }
                    ++n2;
                }
            }
            ++n;
        }
    }

    public void setSelection(int n, int n2, boolean bl) {
        this.setSelection(n, n2, bl, false);
    }

    void setSelection(int n, int n2, boolean bl, boolean bl2) {
        if (bl2) {
            this.setSelection(false);
        }
        if (n == -1 && n2 == -1) {
            int n3 = 0;
            while (n3 < this.seriesCount) {
                int n4 = 0;
                while (n4 < this.sampleCount) {
                    if (this.data[n3] != null && this.data[n3][n4] != null) {
                        this.data[n3][n4].setSelection(bl);
                    }
                    ++n4;
                }
                ++n3;
            }
        } else if (n == -1) {
            int n5 = 0;
            while (n5 < this.sampleCount) {
                if (this.data[n5] != null && n2 >= 0 && n2 < this.data[n5].length && this.data[n5][n2] != null) {
                    this.data[n5][n2].setSelection(bl);
                }
                ++n5;
            }
        } else if (n2 == -1) {
            int n6 = 0;
            while (n6 < this.sampleCount) {
                if (n >= 0 && n < this.data.length && this.data[n] != null && this.data[n][n6] != null) {
                    this.data[n][n6].setSelection(bl);
                }
                ++n6;
            }
        } else if (this.data != null && n >= 0 && n < this.data.length && this.data[n] != null && n2 >= 0 && n2 < this.data[n].length && this.data[n][n2] != null) {
            this.data[n][n2].setSelection(bl);
        }
        this.changedTime = System.currentTimeMillis();
    }

    private void setSelection(boolean bl) {
        int n = 0;
        while (n < this.seriesCount) {
            int n2 = 0;
            while (n2 < this.sampleCount) {
                if (this.data[n] != null && this.data[n][n2] != null) {
                    this.data[n][n2].setSelection(bl);
                }
                ++n2;
            }
            ++n;
        }
        this.changedTime = System.currentTimeMillis();
    }

    public synchronized ChartSample getSample(int n, int n2) {
        if (n < 0 || n >= this.data.length) {
            throw new IllegalArgumentException("Invalid series: " + n);
        }
        try {
            return this.data[n][n2];
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new IllegalArgumentException("Invalid index: " + n2);
        }
        catch (NullPointerException nullPointerException) {
            System.out.println("Internal error: getSample(serie, index");
            return null;
        }
    }
}

