/*
 * Decompiled with CFR 0.152.
 */
package com.objectplanet.chart;

import com.objectplanet.chart.BarChart;
import com.objectplanet.chart.Chart;
import com.objectplanet.chart.ChartApplet;
import java.util.Hashtable;

public class BarChartApplet
extends ChartApplet {
    private String[] r = new String[]{"barLabelsOn", "barLabelStyle", "valueLabelStyle", "autoLabelSpacingOn", "multiColorOn", "multiSeriesOn", "barOutlineOff", "barOutlineColor", "barAlignment", "barType", "barWidth", "barLabelFont", "valueLabelFont", "barLabels"};
    public BarChart chart;

    protected Chart createChart(String string) {
        BarChart barChart = null;
        if (string != null) {
            try {
                Class<?> clazz = Class.forName(string);
                barChart = (BarChart)clazz.newInstance();
            }
            catch (ClassNotFoundException classNotFoundException) {
                System.out.println("Class not found: " + string);
            }
            catch (InstantiationException instantiationException) {
                System.out.println("Could not create an instance of teh class: " + string);
            }
            catch (IllegalAccessException illegalAccessException) {
                System.out.println("Illegal access, could not create an instance of class: " + string);
            }
            catch (ClassCastException classCastException) {
                System.out.println("The class " + string + ", does not extend from com.objectplanet.chart.LineChart");
            }
        }
        if (barChart == null) {
            barChart = new BarChart();
        }
        this.chart = barChart;
        return barChart;
    }

    public void loadParameters(Hashtable hashtable) {
        super.loadParameters(hashtable);
        if (hashtable != null) {
            int n = 0;
            while (n < this.r.length) {
                String string = this.getParameter(this.r[n]);
                if (string != null && string.trim().length() > 0) {
                    hashtable.put(this.r[n], string);
                }
                ++n;
            }
        }
    }

    public void setParameter(String string, String string2) {
        block43: {
            if (string == null || this.chart == null || this.theChart == null) {
                super.setParameter(string, string2);
            }
            if ((string = string.toLowerCase()).equals("barlabels")) {
                if (string2 != null && string2.length() > 0) {
                    String[] stringArray = this.getStringValues(ChartApplet.if(string2));
                    this.chart.setBarLabels(stringArray);
                } else {
                    this.chart.setBarLabels(null);
                }
            } else if (string.equals("barlabelson")) {
                this.chart.setBarLabelsOn(string2 != null && string2.toLowerCase().equals("true"));
            } else if (string.equals("barlabelstyle")) {
                if (string2 != null && string2.trim().toLowerCase().equals("floating")) {
                    this.chart.setBarLabelStyle(3);
                } else if (string2 != null && string2.trim().toLowerCase().equals("below_and_floating")) {
                    this.chart.setBarLabelStyle(4);
                } else {
                    this.chart.setBarLabelStyle(2);
                }
            } else if (string.equals("valuelabelstyle")) {
                if (string2 != null && string2.trim().toLowerCase().equals("inside")) {
                    this.chart.setValueLabelStyle(0);
                } else if (string2 != null && string2.trim().toLowerCase().equals("floating")) {
                    this.chart.setValueLabelStyle(3);
                } else {
                    this.chart.setValueLabelStyle(1);
                }
            } else if (string.equals("autolabelspacingon")) {
                this.chart.setAutoLabelSpacingOn(string2 != null && string2.trim().toLowerCase().equals("true"));
            } else if (string.equals("multicoloron")) {
                this.chart.setMultiColorOn(string2 != null && string2.trim().toLowerCase().equals("true"));
            } else if (string.equals("multiserieson")) {
                this.chart.setMultiSeriesOn(string2 != null && string2.trim().toLowerCase().equals("true"));
            } else if (string.equals("baroutlineoff")) {
                this.chart.setBarOutlineOn(string2 == null || !string2.trim().toLowerCase().equals("true"));
            } else if (string.startsWith("baroutlinecolor")) {
                this.chart.setBarOutlineColor(null);
                if (string2 != null) {
                    this.chart.setBarOutlineColor(ChartApplet.createColor(string2));
                }
            } else if (string.equals("baralignment")) {
                if (string2 != null && string2.trim().toLowerCase().equals("horizontal")) {
                    this.chart.setBarAlignment(0);
                } else {
                    this.chart.setBarAlignment(1);
                }
            } else if (string.equals("bartype")) {
                if (string2 != null && string2.trim().toLowerCase().equals("stacked")) {
                    this.chart.setBarType(1);
                } else {
                    this.chart.setBarType(0);
                }
            } else if (string.equals("barwidth")) {
                try {
                    if (string2 != null && string2.trim().length() > 0) {
                        this.chart.setBarWidth(new Double(string2.trim()));
                        break block43;
                    }
                    this.chart.setBarWidth(0.4);
                }
                catch (NumberFormatException numberFormatException) {
                    System.out.println("Invalid barWidth: " + string2);
                    this.chart.setBarWidth(0.4);
                }
            } else {
                super.setParameter(string, string2);
            }
        }
    }

    protected void refresh() {
        this.chart.repaint();
    }
}

