#include "CSound.h"


CSound::~CSound()
{
	Destroy();
}

CSound::CSound()
{
	channels=0;
	Loader=NULL;
	Perf=NULL;
}

CSound::CSound(int num_channels, CError *err)
{
	channels=0;
	Loader=NULL;
	Perf=NULL;
	this->Create(num_channels,err);
}

//Creates an MP3 and returns it
CMP3 *CSound::Create_MP3(WCHAR *file)
{
	CMP3 *temp=new CMP3();
	error->write("Loading MP3...");
	if(temp->Set_Up_Mp3(file)==D_ERROR)
	{
		error->write("ERROR\n");
		return NULL;
	}
	error->write("OK\n");
	return temp;
}

//safe way of destroying an MP3
int CSound::Destroy_MP3(CMP3 *MP3)
{
	error->write("Destroying MP3...");
	if(MP3!=NULL)
	{
		if(MP3->CleanUp()==D_ERROR)
		{
			error->write("ERROR\n");
			return D_ERROR;
		}
	}
	if(MP3==NULL)
	{
		error->write("ERROR\n");
		return D_ERROR;
	}
	error->write("OK\n");
	return D_FINE;
}

//creates a wav and returns it
CWav *CSound::Create_Wav(WCHAR *file)
{
	CWav *temp=new CWav();
	error->write("Creating Wav...");
	if(D_ERROR==temp->Create(file,Loader,Perf,channels))
	{
		temp=NULL;
		error->write("ERROR\n");
	}
	else
		error->write("OK\n");
	return temp;
}

//safe way of destroying a wav
int CSound::Destroy_Wav(CWav *wav)
{
	error->write("Destroying Wav...");
	if(wav!=NULL)
	{
		if(wav->Destroy()==D_ERROR)
		{
			error->write("ERROR\n");
			return D_ERROR;
		}
	}
	if(wav==NULL)
	{
		error->write("ERROR\n");
		return D_ERROR;
	}
	error->write("OK\n");
	return D_FINE;
}

//creates a wav and returns it
CMidi *CSound::Create_Midi(WCHAR *file)
{
	CMidi *temp=new CMidi();
	error->write("Creating Midi...");
	if(D_ERROR==temp->Create(file,Loader,Perf,channels))
	{
		temp=NULL;
		error->write("ERROR\n");
	}
	else
		error->write("OK\n");
	return temp;
}

//safe way of destroying a wav
int CSound::Destroy_Midi(CMidi *midi)
{
	error->write("Destroying Midi...");
	if(midi!=NULL)
	{
		if(midi->Destroy()==D_ERROR)
		{
			error->write("ERROR\n");
			return D_ERROR;
		}
	}
	if(midi==NULL)
	{
		error->write("ERROR\n");
		return D_ERROR;
	}
	error->write("OK\n");
	return D_FINE;
}

int CSound::Stop_All()
{
	if(FAILED(Perf->Stop(NULL,NULL,0,0)))
		return D_ERROR;
	return D_FINE;
}


int CSound::Create(int num_channels,CError *error2)
{
	this->Destroy();
	channels=num_channels;
	this->error=error2;
	error->write("Creating Sound...");
	HRESULT hr=CoCreateInstance(CLSID_DirectMusicPerformance,NULL,CLSCTX_INPROC,IID_IDirectMusicPerformance8,(void**)&Perf);
	if(FAILED(hr))
	{
		erro=1;
		error->write("ERROR\n");
		return D_ERROR;
	}
	hr=CoCreateInstance(CLSID_DirectMusicLoader,NULL,CLSCTX_INPROC,IID_IDirectMusicLoader8,(void**)&Loader);
	if(FAILED(hr))
	{
		erro=1;
		error->write("ERROR\n");
		return D_ERROR;
	}
	if(S_OK!=Perf->InitAudio(NULL,NULL,NULL,DMUS_APATH_DYNAMIC_STEREO,(DWORD)num_channels,DMUS_AUDIOF_ALL,NULL))
	{
		erro=1;
		error->write("ERROR\n");
		return D_ERROR;
	}
	error->write("OK\n");
	erro=0;
	return D_FINE;
}

int CSound::Destroy()
{
	if(Perf!=NULL)
	{
		error->write("Destroying Sound...");
		Perf->Stop(NULL,NULL,0,0);
		Perf->CloseDown();
		Perf->Release();
		Perf=NULL;
	}
	if(Loader!=NULL)
	{
		Loader->Release();
		Loader=NULL;
		error->write("OK\n");
	}
	return D_FINE;
}