#include <CNova.h>

int WINAPI WinMain(HINSTANCE hInstance,HINSTANCE hPrevInstance,LPSTR lpCmdLine,int nShowCmd)
{
	CNova *Engine=new CNova();
	Engine->Setup(hInstance,"Example1",NO_ICON);
	//creating a sprite
	CSurface *sprite=Engine->Graphic->Create_Surface("arrow.bmp",BITMAP_FILE);
	//these are used for blitting
	RECT source_rect,dest_rect;
	//setting up the source
	source_rect.left=0;
	source_rect.top=0;
	source_rect.right=sprite->Width;
	source_rect.bottom=sprite->Height;
	//setting up the destination
	dest_rect.left=320;
	dest_rect.top=120;
	dest_rect.right=sprite->Width+320;
	dest_rect.bottom=sprite->Height+120;

	//extra fun stuff to do with Fills
	RECT line;
	line.left=200;
	line.top=260;
	line.right=460;
	line.bottom=261;

	while(true)
	{
		if(Engine->Loop()==D_ERROR)
			if(!Engine->Graphic->Restored)
				break;

		//filling the background to the desired color
		Engine->Graphic->Fill(dest_rect,0,0,255);
		//blitting the sprite
		if(Engine->Graphic->Blit(sprite,dest_rect,source_rect)==D_ERROR)
		{ 
			//if theres an error we need to recreate it
			Engine->Graphic->Destroy_Surface(sprite);
			sprite=Engine->Graphic->Create_Surface("arrow.bmp",BITMAP_FILE);
		}
		//writing of text
		Engine->Graphic->Text("Hey I can write text on the screen, YAY!",200,240,255,255,255);

		//lets make a line with the Fill command
		Engine->Graphic->Fill(line,0,255,0);
		 
		if(Engine->Key_Down(DIK_ESCAPE))
			break;
		if(Engine->Key_Down(DIK_F1))
		{
			//we're going to change screen depth/mode, so we need to delete the sprite, change
			//the mode and then create the surface again
			Engine->Graphic->Destroy_Surface(sprite);
			Engine->Graphic->Set_Mode(1024,768,16);
			sprite=Engine->Graphic->Create_Surface("arrow.bmp",BITMAP_FILE);
		}
	}
	Engine->Graphic->Destroy_Surface(sprite);
	MSG temp=Engine->Get_Message();
	delete Engine;
	return temp.wParam;
}