<%
'This file name can be used in a URL the same way you would
'an image file name. Also this file must be served by a web server
'(IIS), i.e., you cannot open it directly (i.e. File|Open) from a web 
'browser bypassing the web server.

'Purpose of the script in this file:
'- set barcode object properties with constants or values passed in
'- write image data out - this file can be referred to as an image file 
'in a URL (e.g. <img src="barcode.asp?...">)

'Some precautions are taken in the script so that no exception is thrown
'If the barcode image does't display, you might want to type in directly
'barcode.asp in your browser's Address/URL field so that you can see
'any error messages

option explicit
response.expires = 0
response.buffer = true

dim bo
set bo = Server.CreateObject("Easybaro.Barcode")

'so that setting invalid data will not cause exception as we're returning an image
bo.ThrowDataError = false
bo.InvalidDataAction = 3	'image will say: "Invalid Data"

if not IsEmpty(request.queryString("type")) then bo.BarcodeType = CInt(request.queryString("type"))

'this is to avoid exception being thrown in the trial version
'when expired, the image will print "Trial Expired" regardless of the Data:
if not bo.TrialExpired then
	if not IsEmpty(request.queryString("data")) then bo.Data = request.queryString("data")
end if

if not IsEmpty(request.queryString("addondata")) then bo.AddOnData = request.queryString("addondata")
if not IsEmpty(request.queryString("caption")) then bo.Caption = request.queryString("caption")
if not IsEmpty(request.queryString("addoncaption")) then bo.AddOnCaption = request.queryString("addoncaption")
if not IsEmpty(request.queryString("rotate")) then bo.Orientation = CInt(request.queryString("rotate"))

dim height, barWidth
height = 40
barWidth = 1	'width of thinnest bar
if not IsEmpty(request.queryString("height")) then height = CInt(request.queryString("height"))
if not IsEmpty(request.queryString("barwidth")) then barWidth = CInt(request.queryString("barwidth"))

'change MIME type to image only now so that user had a chance to see any unexpected error
'when requesting directly barcode.asp by entering it in the browser's URL field
response.clear
dim imageType
imageType = 1	'png, default
if not IsEmpty(request.queryString("image")) then imageType = CInt(request.queryString("image"))
if imageType = 3 then
	response.contentType = "image/jpeg"
else
	imageType = 1
	response.contentType = "image/png"
end if
if bo.Orientation = 0 or bo.Orientation = 2 then
	response.binaryWrite bo.MakeImage(imageType, barWidth, height, true)
else
	response.binaryWrite bo.MakeImage(imageType, height, barWidth, true)
end if

set bo = nothing
%>
