/*
 * Decompiled with CFR 0.152.
 */
package com.daffodilwoods.daffodilinstaller.daffodildb2_0;

import com.daffodilwoods.daffodilinstaller.daffodildb2_0.AbstractInstall;
import com.daffodilwoods.daffodilinstaller.daffodildb2_0.ComponentsStep;
import com.daffodilwoods.daffodilinstaller.daffodildb2_0.DirectoryStep;
import com.daffodilwoods.daffodilinstaller.daffodildb2_0.EndStep;
import com.daffodilwoods.daffodilinstaller.daffodildb2_0.Globals;
import com.daffodilwoods.daffodilinstaller.daffodildb2_0.InstallStep;
import com.daffodilwoods.daffodilinstaller.daffodildb2_0.JvmStep;
import com.daffodilwoods.daffodilinstaller.daffodildb2_0.LanguageStep;
import com.daffodilwoods.daffodilinstaller.daffodildb2_0.LicenseKeyStep;
import com.daffodilwoods.daffodilinstaller.daffodildb2_0.LicenseKeySupport;
import com.daffodilwoods.daffodilinstaller.daffodildb2_0.LicenseStep;
import com.daffodilwoods.daffodilinstaller.daffodildb2_0.LogInfo;
import com.daffodilwoods.daffodilinstaller.daffodildb2_0.ReadmeStep;
import com.daffodilwoods.daffodilinstaller.daffodildb2_0.RegistryUtility;
import com.daffodilwoods.daffodilinstaller.daffodildb2_0.ScriptInfo;
import com.daffodilwoods.daffodilinstaller.daffodildb2_0.ShortcutStep;
import com.daffodilwoods.daffodilinstaller.daffodildb2_0.ShortcutsUtility;
import com.daffodilwoods.daffodilinstaller.daffodildb2_0.StepFactory;
import com.daffodilwoods.daffodilinstaller.daffodildb2_0.UpgradeInfo;
import com.daffodilwoods.daffodilinstaller.daffodildb2_0.UpgradeStep;
import com.daffodilwoods.daffodilinstaller.daffodildb2_0.Utility;
import com.daffodilwoods.daffodilinstaller.daffodildb2_0.gui.Wizard;
import com.ice.jni.registry.Registry;
import com.ice.jni.registry.RegistryKey;
import java.awt.Cursor;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.LineNumberReader;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class Setup
extends AbstractInstall {
    private File fileWithArchive_;
    private String installClassName_;
    private LicenseKeySupport licenseKeySupport;
    private boolean choosedLanguage;
    private String originalLanguage;
    private Object[] launchparms;

    public Setup(String destPath, String licenseKeySupportName, File fileWithArchive, String installClassName) {
        try {
            this.licenseKeySupport = (LicenseKeySupport)this.getClass().getClassLoader().loadClass(licenseKeySupportName).newInstance();
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("cannot load license key support: " + ex.toString());
        }
        this.uInfo_ = new UpgradeInfo();
        try {
            Globals.DEST_PATH = Utility.expandDirectory(destPath, false);
        }
        catch (IOException e) {
            // empty catch block
        }
        Globals.OPERATION = this.uInfo_.forceUpgrade ? 3 : 1;
        this.fileWithArchive_ = fileWithArchive;
        this.installClassName_ = installClassName;
        this.choosedLanguage = true;
        this.state_ = 0;
        this.originalLanguage = Globals.getCurrentLanguage();
        this.ui_ = StepFactory.createUI(this);
        Globals.printDebug("UI created");
        if (!fileWithArchive.exists()) {
            this.ui_.showError(new Exception(Globals.i18n("Setup_ArchiveNotFound") + fileWithArchive.getAbsolutePath()));
            this.quit();
        }
        this.nextStep();
        this.ui_.activateUI();
    }

    public void nextStep() {
        switch (this.state_) {
            case 0: {
                Globals.printDebug("LANGUAGE");
                this.state_ = 1;
                this.setActionEnabled(5);
                this.step_ = this.ui_.createSetupLanguageStep();
                break;
            }
            case 1: {
                Globals.printDebug("WELCOME");
                if (this.step_ instanceof LanguageStep) {
                    this.language = ((LanguageStep)this.step_).getLanguage();
                    Globals.setLanguage(this.language);
                }
                this.state_ = 2;
                if (!this.choosedLanguage) {
                    this.setActionEnabled(5);
                } else {
                    this.setActionEnabled(7);
                }
                this.step_ = this.ui_.createWelcomeStep();
                break;
            }
            case 2: {
                Globals.printDebug("LICENSE");
                this.state_ = 3;
                this.setActionEnabled(7);
                this.step_ = this.ui_.createLicenseStep();
                ((LicenseStep)this.step_).setSetUp(this);
                ((LicenseStep)this.step_).setText(this.getClass().getResourceAsStream("license.txt"));
                break;
            }
            case 3: {
                if (!((LicenseStep)this.step_).isLicenseAccepted()) {
                    this.ui_.showError(new Exception(Globals.i18n("Setup_AcceptLicense")));
                    break;
                }
                Globals.printDebug("README");
                this.state_ = 4;
                this.setActionEnabled(7);
                this.step_ = this.ui_.createReadmeStep();
                ((ReadmeStep)this.step_).setText(this.getClass().getResourceAsStream("readme.txt"));
                break;
            }
            case 4: {
                if (this.licenseKeySupport.needsLicenseKey()) {
                    Globals.printDebug("LICENSE_KEY");
                    this.state_ = 5;
                    this.setActionEnabled(0);
                    this.step_ = this.ui_.createLicenseKeyStep();
                    ((LicenseKeyStep)this.step_).setLicenseKeySupport(this.licenseKeySupport);
                    this.setActionEnabled(7);
                    break;
                }
                this.nextStepUpgrade();
                break;
            }
            case 5: {
                if (((LicenseKeyStep)this.step_).getGetFields(this.licenseKeySupport)) {
                    this.nextStepUpgrade();
                    break;
                }
                this.ui_.showError(new Exception("invalid license key"));
                break;
            }
            case 6: {
                boolean uConfirm = true;
                if (this.uInfo_.forceUpgrade || Globals.APP_VERSION.equals(this.uInfo_.lastVersion())) {
                    uConfirm = true;
                } else {
                    UpgradeStep ustep = (UpgradeStep)this.step_;
                    uConfirm = ustep.isConfirmUpgrade();
                }
                Globals.printDebug(" Upgrade ::: " + this.uInfo_.upgrade);
                boolean bl = this.uInfo_.upgrade = this.uInfo_.upgrade && uConfirm;
                if (this.uInfo_.forceUpgrade) {
                    this.exitOnError(new Exception(Globals.i18n("Setup_UpdateOnly") + "\n" + Globals.i18n("Setup_NoSuitableVersion") + "\n" + Globals.APP_NAME));
                }
                Globals.printDebug("COMPONENTS");
                this.state_ = 7;
                this.setActionEnabled(7);
                this.step_ = this.ui_.createComponentStep();
                ((ComponentsStep)this.step_).setSetUp(this);
                ((ComponentsStep)this.step_).setInstallationComponents();
                break;
            }
            case 7: {
                ((ComponentsStep)this.step_).getInstallationComponents();
                Globals.printDebug("DIRECTORY");
                this.state_ = 8;
                this.setActionEnabled(7);
                this.step_ = this.ui_.createDirectoryStep();
                ((DirectoryStep)this.step_).setDirectory(new File(Globals.DEST_PATH));
                break;
            }
            case 8: {
                DirectoryStep dstep = (DirectoryStep)this.step_;
                File file = dstep.getDirectory();
                if (file == null) {
                    return;
                }
                File errorDir = this.checkDirectory(file);
                if (errorDir != null) {
                    dstep.roDirectory(errorDir);
                    Globals.printDebug("  " + errorDir.getAbsolutePath() + " read-only");
                    return;
                }
                if (this.uInfo_.paths != null) {
                    int i = 0;
                    while (i < this.uInfo_.paths.length) {
                        if (this.uInfo_.paths[i] != null && this.uInfo_.paths[i].getAbsolutePath().equals(file.getAbsolutePath())) {
                            dstep.rejectDirectory();
                            Globals.printDebug("  " + file.getAbsolutePath() + " rejected");
                            return;
                        }
                        ++i;
                    }
                }
                if (!dstep.acceptDirectory(file)) {
                    Globals.printDebug("  " + file.getAbsolutePath() + " refused by user");
                    return;
                }
                dstep.setDirectory(file);
                if (!file.exists() && !dstep.IsCreateDirectory(file)) {
                    return;
                }
                Globals.DEST_PATH = file.getAbsolutePath();
                Globals.printDebug("  " + file.getAbsolutePath() + " accepted");
                Globals.printDebug("JVM");
                this.state_ = 9;
                this.setActionEnabled(7);
                this.step_ = this.ui_.createJVMStep();
                JvmStep jvmstep = (JvmStep)this.step_;
                jvmstep.setSetUp(this);
                break;
            }
            case 9: {
                JvmStep jvmstep = (JvmStep)this.step_;
                String jvm = jvmstep.getSelectedJVM();
                if (jvm == null || !new File(jvm).exists()) {
                    Globals.printDebug(jvm + " entered jvm does not exists");
                    return;
                }
                int index = jvm.lastIndexOf("java");
                if (index != -1) {
                    String prefix = jvm.substring(0, index + 4);
                    String suffix = jvm.substring(index + 4);
                    String jvmw = prefix + "w" + suffix;
                    if (jvmw == null || !new File(jvmw).exists()) {
                        jvmw = jvm;
                    }
                    Globals.JAVAW_EXE = jvmw;
                    Globals.printDebug(" generated javaw = " + jvmw + " and entered java = " + jvm);
                }
                Globals.JAVA_EXE = jvm;
                Globals.printDebug("INSTALL");
                this.state_ = 10;
                this.setActionEnabled(7);
                this.step_ = this.ui_.createInstallStep();
                Globals.printDebug(" Exiting from jvm");
                break;
            }
            case 10: {
                this.setActionEnabled(0);
                this.startInstall(this.sharedDir_, this.uInfo_);
                if (this.uInfo_.upgrade || this.uInfo_.forceUpgrade) {
                    Globals.printDebug("END");
                    this.state_ = 12;
                    this.setActionEnabled(8);
                    this.step_ = this.ui_.createEndStep();
                    ((EndStep)this.step_).setStats(this.stats_);
                    break;
                }
                Globals.printDebug("SHORTCUTS");
                this.state_ = 11;
                this.setActionEnabled(4);
                this.step_ = this.ui_.createShortcutStep();
                break;
            }
            case 11: {
                if (((ShortcutStep)this.step_).isShortcutAccepted()) {
                    ShortcutsUtility.createShortcuts(this.launchparms, this.ui_);
                }
                Globals.printDebug("END");
                this.state_ = 12;
                this.setActionEnabled(8);
                this.step_ = this.ui_.createEndStep();
                ((EndStep)this.step_).setStats(this.stats_);
                break;
            }
            case 12: {
                this.ui_.quitUI();
                this.quit();
            }
        }
    }

    private void nextStepUpgrade() {
        Globals.printDebug("UPGRADE");
        this.state_ = 6;
        this.setActionEnabled(0);
        Wizard wizard = Wizard.getWizard();
        Cursor cursor = wizard.getCursor();
        wizard.setCursor(Cursor.getPredefinedCursor(3));
        this.step_ = this.ui_.createUpgradeStep();
        Globals.printDebug(Globals.IS_ROOT ? "Root install" : "User install");
        this.sharedDir_ = this.findSharedDir();
        Globals.printDebug("install directory: " + this.sharedDir_);
        this.checkUpgrade(this.sharedDir_, this.uInfo_);
        wizard.setCursor(cursor);
        this.setActionEnabled(7);
    }

    public void previousStep() {
        switch (this.state_) {
            case 2: {
                Globals.printDebug("LANGUAGE");
                this.state_ = 1;
                this.setActionEnabled(5);
                Globals.setLanguage(this.originalLanguage);
                this.step_ = this.ui_.createSetupLanguageStep();
                break;
            }
            case 3: {
                Globals.printDebug("WELCOME");
                this.state_ = 2;
                if (!this.choosedLanguage) {
                    this.setActionEnabled(5);
                } else {
                    this.setActionEnabled(7);
                }
                this.step_ = this.ui_.createWelcomeStep();
                break;
            }
            case 4: {
                Globals.printDebug("LICENSE");
                this.state_ = 3;
                this.setActionEnabled(7);
                this.step_ = this.ui_.createLicenseStep();
                ((LicenseStep)this.step_).setSetUp(this);
                ((ReadmeStep)this.step_).setText(this.getClass().getResourceAsStream("license.txt"));
                break;
            }
            case 5: {
                Globals.printDebug("README");
                this.state_ = 4;
                this.setActionEnabled(7);
                this.step_ = this.ui_.createReadmeStep();
                ((ReadmeStep)this.step_).setText(this.getClass().getResourceAsStream("readme.txt"));
                break;
            }
            case 6: {
                if (this.licenseKeySupport.needsLicenseKey()) {
                    Globals.printDebug("LICENSE_KEY");
                    this.state_ = 5;
                    this.setActionEnabled(0);
                    Wizard wizard = Wizard.getWizard();
                    Cursor cursor = wizard.getCursor();
                    wizard.setCursor(Cursor.getPredefinedCursor(3));
                    this.step_ = this.ui_.createLicenseKeyStep();
                    ((LicenseKeyStep)this.step_).setLicenseKeySupport(this.licenseKeySupport);
                    wizard.setCursor(cursor);
                    this.setActionEnabled(7);
                    break;
                }
                Globals.printDebug("README");
                this.state_ = 4;
                this.setActionEnabled(7);
                this.step_ = this.ui_.createReadmeStep();
                ((ReadmeStep)this.step_).setText(this.getClass().getResourceAsStream("readme.txt"));
                break;
            }
            case 7: {
                ((ComponentsStep)this.step_).getInstallationComponents();
                Globals.printDebug("UPGRADE");
                this.state_ = 6;
                this.setActionEnabled(0);
                this.step_ = this.ui_.createUpgradeStep();
                this.checkUpgrade(this.sharedDir_, this.uInfo_);
                this.setActionEnabled(7);
                break;
            }
            case 8: {
                Globals.printDebug("COMPONENTS");
                this.state_ = 7;
                this.setActionEnabled(0);
                this.step_ = this.ui_.createComponentStep();
                ((ComponentsStep)this.step_).setSetUp(this);
                ((ComponentsStep)this.step_).setInstallationComponents();
                this.setActionEnabled(7);
                break;
            }
            case 9: {
                Globals.printDebug("DIRECTORY");
                this.state_ = 8;
                this.setActionEnabled(7);
                this.step_ = this.ui_.createDirectoryStep();
                ((DirectoryStep)this.step_).setDirectory(new File(Globals.DEST_PATH));
                break;
            }
            case 10: {
                Globals.printDebug(" back processing " + this.uInfo_.upgrade);
                if (this.uInfo_.upgrade) {
                    this.state_ = 6;
                    this.setActionEnabled(0);
                    this.step_ = this.ui_.createUpgradeStep();
                    this.checkUpgrade(this.sharedDir_, this.uInfo_);
                    this.setActionEnabled(7);
                    break;
                }
                Globals.printDebug("JVM");
                this.state_ = 9;
                this.setActionEnabled(7);
                this.step_ = this.ui_.createJVMStep();
                JvmStep jvmstep = (JvmStep)this.step_;
                jvmstep.setSetUp(this);
                ((JvmStep)this.step_).setSelectedJVM(Globals.JAVA_EXE);
                break;
            }
            default: {
                Globals.printDebug("can't go back...");
            }
        }
    }

    public void redoStep() {
    }

    private File checkDirectory(File dir) {
        File res = null;
        File parent = dir.getParentFile();
        while (parent != null) {
            if (parent.exists()) {
                if (!parent.canWrite()) {
                    res = parent;
                    break;
                }
                res = null;
                break;
            }
            parent = parent.getParentFile();
        }
        return res;
    }

    private void startInstall(File sharedDir, UpgradeInfo uInfo) {
        InstallStep step = (InstallStep)this.step_;
        try {
            if (uInfo.upgrade) {
                Globals.printDebug("Upgrade mode");
            } else {
                Globals.printDebug("Install mode");
            }
            step.status(Globals.i18n("Setup_ExtractingUninstaller"));
            Utility.extractUninstallFiles(sharedDir, uInfo.upgrade, uInfo.lastVersion(), new boolean[]{this.dirty_}, this.fileWithArchive_);
            int nbrFiles = 710;
            LogInfo logInfo = this.unzip(this.licenseKeySupport.decodeStream(this.getClass().getResourceAsStream("archive.zip")), nbrFiles, sharedDir, uInfo.upgrade);
            step.status(Globals.i18n("Setup_GeneratingLaunchScripts"));
            this.launchparms = Utility.generateLaunchScripts(logInfo, this.ui_, this.step_);
            this.ui_.uiSleep(2000L);
            step.status(Globals.i18n("Setup_LaunchScriptsGenerated"));
            this.ui_.uiSleep(1000L);
            step.status(Globals.i18n("Setup_GeneratingUninstallScript"));
            Utility.generateUninstallScripts(sharedDir, logInfo, this.installClassName_, this.ui_, this.step_);
            this.ui_.uiSleep(2000L);
            step.status(Globals.i18n("Setup_UninstallScriptGenerated"));
            this.ui_.uiSleep(1000L);
            if (Globals.IS_UNIX) {
                step.status(Globals.i18n("Setup_RestoringExeAttributes"));
                this.restoreUnixExecutables();
                this.ui_.uiSleep(2000L);
                step.status(Globals.i18n("Setup_ExeAttributesRestored"));
                this.ui_.uiSleep(1000L);
            }
            if (Globals.IS_WIN) {
                RegistryUtility.createDaffodilEntry();
                step.status(Globals.i18n("Setup_UpdatingWindowsRegistry"));
                Utility.updateWindowsRegistry(sharedDir, uInfo.upgrade, uInfo.lastVersion(), this.ui_, this.installClassName_);
                this.ui_.uiSleep(2000L);
                step.status(Globals.i18n("Setup_WindowsRegistryUpdated"));
                this.ui_.uiSleep(1000L);
            }
            logInfo.close();
            this.deleteUnNecessaryFiles();
            step.status(Globals.i18n("Setup_InstallationComplete"));
            this.ui_.uiSleep(1000L);
        }
        catch (IOException e) {
            this.exitOnError(e);
        }
    }

    private void deleteUnNecessaryFiles() {
        File f;
        if (!Globals.isServerSelected && (f = new File(Globals.DEST_PATH + File.separator + "lib" + File.separator + "DaffodilDB_Server.jar")).exists()) {
            f.delete();
        }
        if (!Globals.isEmbeddedSelected && (f = new File(Globals.DEST_PATH + File.separator + "lib" + File.separator + "DaffodilDB_Embedded.jar")).exists()) {
            f.delete();
        }
        if (!Globals.isClientSelected && (f = new File(Globals.DEST_PATH + File.separator + "lib" + File.separator + "DaffodilDB_Client.jar")).exists()) {
            f.delete();
        }
        if (Globals.isClientSelected && !Globals.isServerSelected && !Globals.isEmbeddedSelected && (f = new File(Globals.DEST_PATH + File.separator + "lib" + File.separator + "DaffodilDB_Common.jar")).exists()) {
            f.delete();
        }
        if (!Globals.isDocumentaionSelected) {
            this.delDirRec(new File(Globals.DEST_PATH + File.separator + "docs"));
        }
    }

    private void delDirRec(File dir) {
        if (dir == null || !dir.exists()) {
            return;
        }
        File[] filelist = dir.listFiles();
        int i = 0;
        while (i < filelist.length) {
            boolean isdir = filelist[i].isDirectory();
            if (isdir) {
                this.deleteDirRecursive(filelist[i]);
            } else if (!filelist[i].delete()) {
                // empty if block
            }
            ++i;
        }
        if (!dir.delete()) {
            // empty if block
        }
    }

    protected void exitOnError(Throwable e) {
        this.cleanInstall(this.sharedDir_, this.uInfo_);
        super.exitOnError(e);
    }

    private File findSharedDir() {
        File destPath;
        block15: {
            destPath = null;
            try {
                if (Globals.IS_ROOT) {
                    if (Globals.IS_WIN) {
                        try {
                            RegistryKey sharedDirKey = Registry.HKEY_LOCAL_MACHINE.openSubKey("SOFTWARE\\Microsoft\\Windows\\CurrentVersion");
                            destPath = new File(sharedDirKey.getStringValue("CommonFilesDir"));
                            sharedDirKey.closeKey();
                        }
                        catch (Exception rex) {
                            destPath = null;
                        }
                        if (destPath == null || !destPath.exists()) {
                            Globals.printDebug("Could not find common dir in registry:");
                            Globals.printDebug("using 'C:\\Program Files\\Common Files'");
                            destPath = new File("C:\\Program Files\\Common Files");
                            if (!destPath.exists()) {
                                destPath.mkdirs();
                            }
                        }
                    } else if (Globals.IS_UNIX && !(destPath = new File("/usr/share")).exists()) {
                        destPath = new File("/opt/share");
                    }
                    if (!destPath.exists()) {
                        throw new IOException(Globals.i18n("Setup_CouldNotFindInstall"));
                    }
                    if ((destPath = new File(destPath, "daffodil")).exists()) break block15;
                    destPath.mkdirs();
                    break block15;
                }
                if (Globals.IS_WIN) {
                    destPath = new File(System.getProperty("user.home") + File.separator + "daffodil");
                } else if (Globals.IS_UNIX) {
                    destPath = new File(System.getProperty("user.home") + File.separator + ".daffodil");
                }
                if (!destPath.exists()) {
                    destPath.mkdirs();
                }
            }
            catch (IOException e) {
                this.exitOnError(e);
            }
        }
        return destPath;
    }

    private Vector loadLogFile(File sharedDir) throws IOException {
        Vector<String> res = new Vector<String>();
        File logfile = new File(sharedDir.getAbsolutePath() + File.separator + Globals.APP_NAME + "_" + Globals.APP_VERSION + File.separator + "uninstall.daf");
        if (logfile.exists()) {
            LineNumberReader log = new LineNumberReader(new FileReader(logfile));
            String line = log.readLine();
            while (line != null) {
                res.add(line);
                line = log.readLine();
            }
            log.close();
        }
        return res;
    }

    private void restoreUnixExecutables() {
        InstallStep step = (InstallStep)this.step_;
        try {
            ScriptInfo[] scriptInfos = Globals.getScriptInfos();
            String[] chmodStr = new String[4 + scriptInfos.length];
            chmodStr[0] = "chmod";
            chmodStr[1] = "-R";
            chmodStr[2] = "a+x";
            chmodStr[3] = "";
            if (Globals.IS_WIN || Globals.IS_UNIX) {
                chmodStr[3] = chmodStr[3] + Utility.computeLocalPath("uninstall_" + Globals.APP_NAME + "_" + Globals.APP_VERSION);
                chmodStr[3] = Globals.IS_WIN ? chmodStr[3] + ".bat" : chmodStr[3] + ".sh";
            }
            int i = 0;
            while (i < scriptInfos.length) {
                ScriptInfo info = scriptInfos[i];
                String exe = "";
                if (info.isJava_) {
                    exe = info.scriptName_;
                    exe = Globals.IS_WIN ? exe + ".bat" : exe + ".sh";
                    chmodStr[4 + i] = Utility.computeLocalPath(exe);
                    step.details(exe);
                    this.stats_.addExecutable(new File(chmodStr[4 + i]));
                } else {
                    chmodStr[4 + i] = exe;
                }
                ++i;
            }
            String chmod = "";
            int i2 = 0;
            while (i2 < chmodStr.length) {
                chmod = chmod + chmodStr[i2] + " ";
                ++i2;
            }
            Globals.printDebug(chmod);
            PrintStream out = System.out;
            PrintStream err = System.err;
            PrintStream nullStream = new PrintStream(new ByteArrayOutputStream());
            System.setErr(nullStream);
            System.setOut(nullStream);
            Process p = Runtime.getRuntime().exec(chmodStr);
            boolean interr = true;
            while (interr) {
                try {
                    p.waitFor();
                    interr = false;
                }
                catch (InterruptedException e) {
                    interr = true;
                }
            }
            nullStream.close();
            System.setErr(err);
            System.setOut(out);
            if (p.exitValue() != 0) {
                throw new Exception();
            }
        }
        catch (Exception e) {
            Globals.printDebug(e.toString());
            this.ui_.showError(new Exception(Globals.i18n("Setup_ErrorRestoringExeAttributes")));
        }
    }

    private LogInfo unzip(InputStream archive, int nbrFiles, File sharedDir, boolean upgrade) throws IOException {
        InstallStep step = (InstallStep)this.step_;
        int count = 0;
        ZipInputStream zip = new ZipInputStream(archive);
        File destPath = new File(Utility.computeLocalPath(""));
        step.setProgression(0);
        step.details("D " + destPath);
        if (!destPath.exists() && !destPath.mkdirs()) {
            throw new IOException(Globals.i18n("Setup_NotCreateDirectory") + " " + destPath);
        }
        this.dirty_ = true;
        Vector oldlog = this.loadLogFile(sharedDir);
        PrintWriter log = new PrintWriter(new FileWriter(sharedDir.getAbsolutePath() + File.separator + Globals.APP_NAME + "_" + Globals.APP_VERSION + File.separator + "uninstall.daf"));
        LogInfo logInfo = new LogInfo();
        logInfo.log = log;
        logInfo.oldlog = oldlog;
        log.println(destPath.getAbsolutePath());
        int i = 1;
        while (i < oldlog.size()) {
            String sentry;
            String s = sentry = (String)oldlog.get(i);
            int ind = sentry.lastIndexOf(File.separator);
            if (ind > 0) {
                s = sentry.substring(ind + 1);
            }
            if (!s.startsWith("uninstall_" + Globals.APP_NAME + "_")) {
                log.println(sentry);
            }
            ++i;
        }
        ZipEntry entry = zip.getNextEntry();
        while (entry != null) {
            File dest = new File(Utility.computeLocalPath(entry.getName()));
            if (entry.isDirectory() && !dest.exists()) {
                this.makeDirs(dest, logInfo);
                zip.closeEntry();
            } else if (!entry.isDirectory()) {
                File destParent = dest.getParentFile();
                if (destParent != null && !destParent.exists()) {
                    this.makeDirs(destParent, logInfo);
                }
                step.details("F " + dest);
                FileOutputStream out = new FileOutputStream(dest);
                byte[] buf = new byte[4096];
                int read = zip.read(buf, 0, buf.length);
                while (read > 0) {
                    out.write(buf, 0, read);
                    read = zip.read(buf, 0, buf.length);
                }
                this.stats_.addFile(dest, true);
                if (!oldlog.contains(dest.getAbsolutePath())) {
                    log.println(dest.getAbsolutePath());
                }
                step.setProgression(++count * 100 / nbrFiles);
            }
            zip.closeEntry();
            entry = zip.getNextEntry();
        }
        zip.close();
        return logInfo;
    }

    private void makeDirs(File dir, LogInfo logInfo) throws IOException {
        InstallStep step = (InstallStep)this.step_;
        File parent = dir.getParentFile();
        if (parent != null && !parent.exists()) {
            this.makeDirs(parent, logInfo);
        }
        step.details("D " + dir);
        if (dir.mkdir()) {
            this.stats_.addFile(dir, true);
            if (!logInfo.oldlog.contains(dir.getAbsolutePath())) {
                logInfo.log.println(dir.getAbsolutePath());
            }
        } else {
            throw new IOException(Globals.i18n("Setup_NotCreateDirectory") + " " + dir);
        }
    }
}

