/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xpath.patterns;

import java.util.Vector;
import javax.xml.transform.TransformerException;
import org.apache.xpath.Expression;
import org.apache.xpath.XPathContext;
import org.apache.xpath.objects.XObject;
import org.apache.xpath.patterns.NodeTest;
import org.apache.xpath.patterns.StepPattern;

public class UnionPattern
extends Expression {
    private StepPattern[] m_patterns;

    public boolean canTraverseOutsideSubtree() {
        if (this.m_patterns != null) {
            int n = this.m_patterns.length;
            int i = 0;
            while (i < n) {
                if (this.m_patterns[i].canTraverseOutsideSubtree()) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public XObject execute(XPathContext xctxt) throws TransformerException {
        XObject bestScore = null;
        int n = this.m_patterns.length;
        int i = 0;
        while (i < n) {
            XObject score = this.m_patterns[i].execute(xctxt);
            if (score != NodeTest.SCORE_NONE) {
                if (bestScore == null) {
                    bestScore = score;
                } else if (score.num() > bestScore.num()) {
                    bestScore = score;
                }
            }
            ++i;
        }
        if (bestScore == null) {
            bestScore = NodeTest.SCORE_NONE;
        }
        return bestScore;
    }

    public void fixupVariables(Vector vars, int globalsSize) {
        int i = 0;
        while (i < this.m_patterns.length) {
            this.m_patterns[i].fixupVariables(vars, globalsSize);
            ++i;
        }
    }

    public StepPattern[] getPatterns() {
        return this.m_patterns;
    }

    public void setPatterns(StepPattern[] patterns) {
        this.m_patterns = patterns;
    }
}

