/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.transformer;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.URIResolver;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.stream.StreamResult;
import org.apache.xalan.processor.TransformerFactoryImpl;
import org.apache.xalan.res.XSLMessages;
import org.apache.xalan.serialize.Serializer;
import org.apache.xalan.serialize.SerializerFactory;
import org.apache.xalan.templates.AVT;
import org.apache.xalan.templates.ElemAttributeSet;
import org.apache.xalan.templates.ElemForEach;
import org.apache.xalan.templates.ElemSort;
import org.apache.xalan.templates.ElemTemplate;
import org.apache.xalan.templates.ElemTemplateElement;
import org.apache.xalan.templates.ElemTextLiteral;
import org.apache.xalan.templates.ElemVariable;
import org.apache.xalan.templates.OutputProperties;
import org.apache.xalan.templates.StylesheetRoot;
import org.apache.xalan.templates.WhiteSpaceInfo;
import org.apache.xalan.templates.XUnresolvedVariable;
import org.apache.xalan.trace.TraceManager;
import org.apache.xalan.transformer.ClonerToResultTree;
import org.apache.xalan.transformer.CountersTable;
import org.apache.xalan.transformer.KeyManager;
import org.apache.xalan.transformer.MsgMgr;
import org.apache.xalan.transformer.NodeSortKey;
import org.apache.xalan.transformer.ResultTreeHandler;
import org.apache.xalan.transformer.StackGuard;
import org.apache.xalan.transformer.TransformSnapshot;
import org.apache.xalan.transformer.TransformSnapshotImpl;
import org.apache.xalan.transformer.TransformerHandlerImpl;
import org.apache.xml.dtm.DTM;
import org.apache.xml.dtm.DTMIterator;
import org.apache.xml.dtm.DTMWSFilter;
import org.apache.xml.utils.BoolStack;
import org.apache.xml.utils.DOMBuilder;
import org.apache.xml.utils.DefaultErrorHandler;
import org.apache.xml.utils.NodeVector;
import org.apache.xml.utils.ObjectPool;
import org.apache.xml.utils.QName;
import org.apache.xml.utils.SAXSourceLocator;
import org.apache.xml.utils.WrappedRuntimeException;
import org.apache.xpath.Arg;
import org.apache.xpath.DOMHelper;
import org.apache.xpath.NodeSetDTM;
import org.apache.xpath.VariableStack;
import org.apache.xpath.XPathContext;
import org.apache.xpath.axes.SelfIteratorNoPredicate;
import org.apache.xpath.objects.XObject;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Node;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.SAXParseException;
import org.xml.sax.ext.DeclHandler;
import org.xml.sax.ext.LexicalHandler;

public class TransformerImpl
extends Transformer
implements Runnable,
DTMWSFilter {
    private Boolean m_reentryGuard = new Boolean(true);
    private FileOutputStream m_outputStream = null;
    private boolean m_parserEventsOnMain = true;
    private Thread m_transformThread;
    private String m_urlOfSource = null;
    private Result m_outputTarget = null;
    private OutputProperties m_outputFormat;
    private Serializer m_serializer;
    ContentHandler m_inputContentHandler;
    private ContentHandler m_outputContentHandler = null;
    DocumentBuilder m_docBuilder = null;
    private ObjectPool m_textResultHandlerObjectPool = new ObjectPool("org.apache.xalan.transformer.ResultTreeHandler");
    private ObjectPool m_stringWriterObjectPool = new ObjectPool("java.io.StringWriter");
    private OutputProperties m_textformat = new OutputProperties("text");
    ElemTemplateElement[] m_currentTemplateElements = new ElemTemplateElement[4096];
    int m_currentTemplateElementsTop = 0;
    Stack m_currentMatchTemplates = new Stack();
    NodeVector m_currentMatchedNodes = new NodeVector();
    private StylesheetRoot m_stylesheetRoot = null;
    private boolean m_quietConflictWarnings = true;
    private XPathContext m_xcontext;
    private StackGuard m_stackGuard = new StackGuard();
    private ResultTreeHandler m_resultTreeHandler;
    private KeyManager m_keyManager = new KeyManager();
    Stack m_attrSetStack = null;
    CountersTable m_countersTable = null;
    BoolStack m_currentTemplateRuleIsNull = new BoolStack();
    private MsgMgr m_msgMgr;
    public static boolean S_DEBUG = false;
    protected boolean m_useSourceLocationProperty = false;
    private ErrorListener m_errorHandler = new DefaultErrorHandler();
    private TraceManager m_traceManager = new TraceManager(this);
    private Exception m_exceptionThrown = null;
    private Source m_xmlSource;
    private int m_doc;
    private boolean m_isTransformDone = false;
    private boolean m_hasBeenReset = false;
    private boolean m_shouldReset = true;
    private Stack m_modes = new Stack();
    private boolean m_hasTransformThreadErrorCatcher = false;
    Vector m_userParams;
    static ThreadControler tpool = new ThreadControler();

    public TransformerImpl(StylesheetRoot stylesheet) {
        this.setStylesheet(stylesheet);
        this.setXPathContext(new XPathContext(this));
        this.getXPathContext().setNamespaceContext(stylesheet);
    }

    /*
     * Recovered potentially malformed switches.  Disable with '--allowmalformedswitch false'
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean applyTemplateToNode(ElemTemplateElement xslInstruction, ElemTemplate template, int child) throws TransformerException {
        DTM dtm = this.m_xcontext.getDTM(child);
        short nodeType = dtm.getNodeType(child);
        boolean isDefaultTextRule = false;
        if (template == null) {
            boolean isApplyImports = xslInstruction == null ? false : xslInstruction.getXSLToken() == 72;
            int maxImportLevel = isApplyImports ? xslInstruction.getStylesheetComposed().getImportCountComposed() - 1 : -1;
            if (isApplyImports && maxImportLevel == -1) {
                template = null;
            } else {
                XPathContext xctxt = this.m_xcontext;
                try {
                    xctxt.pushNamespaceContext(xslInstruction);
                    QName mode = this.getMode();
                    template = this.m_stylesheetRoot.getTemplateComposed(xctxt, child, mode, maxImportLevel, this.m_quietConflictWarnings, dtm);
                }
                finally {
                    Object var11_15 = null;
                    xctxt.popNamespaceContext();
                }
            }
            if (template == null) {
                switch (nodeType) {
                    case 1: 
                    case 11: {
                        template = this.m_stylesheetRoot.getDefaultRule();
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 4: {
                        template = this.m_stylesheetRoot.getDefaultTextRule();
                        isDefaultTextRule = true;
                        break;
                    }
                    case 9: {
                        template = this.m_stylesheetRoot.getDefaultRootRule();
                        break;
                    }
                    default: {
                        return false;
                    }
                }
            }
        }
        try {
            try {
                this.pushElemTemplateElement(template);
                this.m_xcontext.pushCurrentNode(child);
                this.pushPairCurrentMatched(template, child);
                NodeSetDTM cnl = new NodeSetDTM(child, this.m_xcontext.getDTMManager());
                this.m_xcontext.pushContextNodeList(cnl);
                if (isDefaultTextRule) {
                    switch (nodeType) {
                        case 3: 
                        case 4: {
                            ClonerToResultTree.cloneToResultTree(child, nodeType, dtm, this.getResultTreeHandler(), false);
                            return true;
                        }
                        case 2: {
                            dtm.dispatchCharactersEvents(child, this.getResultTreeHandler(), false);
                            return true;
                        }
                        default: {
                            return true;
                        }
                    }
                }
                if (S_DEBUG) {
                    this.getTraceManager().fireTraceEvent(template);
                }
                this.m_xcontext.setSAXLocator(template);
                this.m_xcontext.getVarStack().link(template.m_frameSize);
                this.executeChildTemplates((ElemTemplateElement)template, true);
                return true;
            }
            catch (SAXException se) {
                throw new TransformerException(se);
            }
        }
        finally {
            Object var8_8 = null;
            this.m_xcontext.getVarStack().unlink();
            this.m_xcontext.popCurrentNode();
            this.m_xcontext.popContextNodeList();
            this.popCurrentMatched();
            this.popElemTemplateElement();
        }
    }

    public void clearParameters() {
        Boolean bl = this.m_reentryGuard;
        synchronized (bl) {
            VariableStack varstack = new VariableStack();
            this.m_xcontext.setVarStack(varstack);
            this.m_userParams = null;
        }
    }

    public ContentHandler createResultContentHandler(Result outputTarget) throws TransformerException {
        return this.createResultContentHandler(outputTarget, this.getOutputFormat());
    }

    public ContentHandler createResultContentHandler(Result outputTarget, OutputProperties format) throws TransformerException {
        ContentHandler handler = null;
        Node outputNode = null;
        if (outputTarget instanceof DOMResult) {
            Document doc;
            short type;
            outputNode = ((DOMResult)outputTarget).getNode();
            if (outputNode != null) {
                type = outputNode.getNodeType();
                doc = type == 9 ? (Document)outputNode : outputNode.getOwnerDocument();
            } else {
                doc = DOMHelper.createDocument();
                outputNode = doc;
                type = outputNode.getNodeType();
                ((DOMResult)outputTarget).setNode(outputNode);
            }
            handler = type == 11 ? new DOMBuilder(doc, (DocumentFragment)outputNode) : new DOMBuilder(doc, outputNode);
        } else if (outputTarget instanceof SAXResult) {
            handler = ((SAXResult)outputTarget).getHandler();
            if (handler == null) {
                throw new IllegalArgumentException("handler can not be null for a SAXResult");
            }
        } else if (outputTarget instanceof StreamResult) {
            StreamResult sresult = (StreamResult)outputTarget;
            String method = format.getProperty("method");
            try {
                Serializer serializer = SerializerFactory.getSerializer(format.getProperties());
                if (sresult.getWriter() != null) {
                    serializer.setWriter(sresult.getWriter());
                } else if (sresult.getOutputStream() != null) {
                    serializer.setOutputStream(sresult.getOutputStream());
                } else if (sresult.getSystemId() != null) {
                    String fileURL = sresult.getSystemId();
                    if (fileURL.startsWith("file:///")) {
                        fileURL = fileURL.substring(8).indexOf(":") > 0 ? fileURL.substring(8) : fileURL.substring(7);
                    }
                    this.m_outputStream = new FileOutputStream(fileURL);
                    serializer.setOutputStream(this.m_outputStream);
                } else {
                    throw new TransformerException(XSLMessages.createMessage(147, null));
                }
                handler = serializer.asContentHandler();
                this.setSerializer(serializer);
            }
            catch (UnsupportedEncodingException uee) {
                throw new TransformerException(uee);
            }
            catch (IOException ioe) {
                throw new TransformerException(ioe);
            }
        } else {
            throw new TransformerException(XSLMessages.createMessage(148, new Object[]{outputTarget.getClass().getName()}));
        }
        return handler;
    }

    public boolean currentTemplateRuleIsNull() {
        return !this.m_currentTemplateRuleIsNull.isEmpty() && this.m_currentTemplateRuleIsNull.peek();
    }

    public void executeChildTemplates(ElemTemplateElement elem, Node context, QName mode, ContentHandler handler) throws TransformerException {
        XPathContext xctxt = this.m_xcontext;
        try {
            if (mode != null) {
                this.pushMode(mode);
            }
            xctxt.pushCurrentNode(xctxt.getDTMHandleFromNode(context));
            this.executeChildTemplates(elem, handler);
        }
        finally {
            Object var7_6 = null;
            xctxt.popCurrentNode();
            if (mode != null) {
                this.popMode();
            }
        }
    }

    public void executeChildTemplates(ElemTemplateElement elem, ContentHandler handler) throws TransformerException {
        ResultTreeHandler rth = this.getResultTreeHandler();
        ContentHandler savedRTHHandler = rth.getContentHandler();
        ContentHandler savedHandler = this.getContentHandler();
        try {
            try {
                this.getResultTreeHandler().flushPending();
                this.setContentHandler(handler);
                this.executeChildTemplates(elem, true);
            }
            catch (SAXException se) {
                throw new TransformerException(se);
            }
            Object var7_7 = null;
            this.setContentHandler(savedHandler);
            rth.setContentHandler(savedRTHHandler);
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            this.setContentHandler(savedHandler);
            rth.setContentHandler(savedRTHHandler);
            throw throwable;
        }
    }

    public void executeChildTemplates(ElemTemplateElement elem, boolean shouldAddAttrs) throws TransformerException {
        ElemTemplateElement t = elem.getFirstChildElem();
        if (t == null) {
            return;
        }
        if (elem.hasTextLitOnly() && TransformerFactoryImpl.m_optimize) {
            char[] chars = ((ElemTextLiteral)t).getChars();
            try {
                try {
                    this.pushElemTemplateElement(t);
                    this.m_resultTreeHandler.characters(chars, 0, chars.length);
                }
                catch (SAXException se) {
                    throw new TransformerException(se);
                }
                Object var6_9 = null;
                this.popElemTemplateElement();
            }
            catch (Throwable throwable) {
                Object var6_10 = null;
                this.popElemTemplateElement();
                throw throwable;
            }
            return;
        }
        XPathContext xctxt = this.m_xcontext;
        xctxt.pushSAXLocatorNull();
        int currentTemplateElementsTop = this.m_currentTemplateElementsTop++;
        try {
            while (t != null) {
                if (shouldAddAttrs || t.getXSLToken() != 48) {
                    xctxt.setSAXLocator(t);
                    this.m_currentTemplateElements[currentTemplateElementsTop] = t;
                    t.execute(this);
                }
                t = t.getNextSiblingElem();
            }
        }
        finally {
            Object var7_7 = null;
            --this.m_currentTemplateElementsTop;
            xctxt.popSAXLocator();
        }
    }

    public void executeFromSnapshot(TransformSnapshot ts) throws TransformerException {
        ElemTemplate template = this.getMatchedTemplate();
        int child = this.getMatchedNode();
        this.pushElemTemplateElement(template);
        this.m_xcontext.pushCurrentNode(child);
        this.executeChildTemplates((ElemTemplateElement)template, true);
    }

    public String getBaseURLOfSource() {
        return this.m_urlOfSource;
    }

    public ContentHandler getContentHandler() {
        return this.m_outputContentHandler;
    }

    public DTMIterator getContextNodeList() {
        try {
            DTMIterator cnl = this.m_xcontext.getContextNodeList();
            return cnl == null ? null : cnl.cloneWithReset();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public CountersTable getCountersTable() {
        if (this.m_countersTable == null) {
            this.m_countersTable = new CountersTable();
        }
        return this.m_countersTable;
    }

    public ElemTemplateElement getCurrentElement() {
        return this.m_currentTemplateElements[this.m_currentTemplateElementsTop - 1];
    }

    public int getCurrentNode() {
        return this.m_xcontext.getCurrentNode();
    }

    public ElemTemplate getCurrentTemplate() {
        ElemTemplateElement elem = this.getCurrentElement();
        while (elem != null && elem.getXSLToken() != 19) {
            elem = elem.getParentElem();
        }
        return (ElemTemplate)elem;
    }

    public ErrorListener getErrorListener() {
        return this.m_errorHandler;
    }

    public Exception getExceptionThrown() {
        return this.m_exceptionThrown;
    }

    public boolean getFeature(String name) throws SAXNotRecognizedException, SAXNotSupportedException {
        if ("http://xml.org/trax/features/sax/input".equals(name)) {
            return true;
        }
        if ("http://xml.org/trax/features/dom/input".equals(name)) {
            return true;
        }
        throw new SAXNotRecognizedException(name);
    }

    public ContentHandler getInputContentHandler() {
        return this.getInputContentHandler(false);
    }

    public ContentHandler getInputContentHandler(boolean doDocFrag) {
        if (this.m_inputContentHandler == null) {
            this.m_inputContentHandler = new TransformerHandlerImpl(this, doDocFrag, this.m_urlOfSource);
        }
        return this.m_inputContentHandler;
    }

    public DeclHandler getInputDeclHandler() {
        if (this.m_inputContentHandler instanceof DeclHandler) {
            return (DeclHandler)((Object)this.m_inputContentHandler);
        }
        return null;
    }

    public LexicalHandler getInputLexicalHandler() {
        if (this.m_inputContentHandler instanceof LexicalHandler) {
            return (LexicalHandler)((Object)this.m_inputContentHandler);
        }
        return null;
    }

    public KeyManager getKeyManager() {
        return this.m_keyManager;
    }

    public int getMatchedNode() {
        return this.m_currentMatchedNodes.peepTail();
    }

    public ElemTemplate getMatchedTemplate() {
        return (ElemTemplate)this.m_currentMatchTemplates.peek();
    }

    public QName getMode() {
        return this.m_modes.isEmpty() ? null : (QName)this.m_modes.peek();
    }

    public MsgMgr getMsgMgr() {
        if (this.m_msgMgr == null) {
            this.m_msgMgr = new MsgMgr(this);
        }
        return this.m_msgMgr;
    }

    public OutputProperties getOutputFormat() {
        OutputProperties format = this.m_outputFormat == null ? this.getStylesheet().getOutputComposed() : this.m_outputFormat;
        return format;
    }

    public Properties getOutputProperties() {
        return (Properties)((Hashtable)this.getOutputFormat().getProperties()).clone();
    }

    public String getOutputProperty(String qnameString) throws IllegalArgumentException {
        String value = null;
        OutputProperties props = this.getOutputFormat();
        value = props.getProperty(qnameString);
        if (value == null && !props.isLegalPropertyKey(qnameString)) {
            throw new IllegalArgumentException(XSLMessages.createMessage(197, new Object[]{qnameString}));
        }
        return value;
    }

    public String getOutputPropertyNoDefault(String qnameString) throws IllegalArgumentException {
        String value = null;
        OutputProperties props = this.getOutputFormat();
        value = (String)((Hashtable)props.getProperties()).get(qnameString);
        if (value == null && !props.isLegalPropertyKey(qnameString)) {
            throw new IllegalArgumentException(XSLMessages.createMessage(197, new Object[]{qnameString}));
        }
        return value;
    }

    public Result getOutputTarget() {
        return this.m_outputTarget;
    }

    public Object getParameter(String name) {
        try {
            QName qname = QName.getQNameFromString(name);
            if (this.m_userParams == null) {
                return null;
            }
            int n = this.m_userParams.size();
            int i = n - 1;
            while (i >= 0) {
                Arg arg = (Arg)this.m_userParams.elementAt(i);
                if (arg.getQName().equals(qname)) {
                    return arg.getVal().object();
                }
                --i;
            }
            return null;
        }
        catch (NoSuchElementException noSuchElementException) {
            return null;
        }
    }

    public boolean getProperty(String property) {
        if (property.equals("http://xml.apache.org/xalan/properties/source-location")) {
            return this.m_useSourceLocationProperty;
        }
        return false;
    }

    public boolean getQuietConflictWarnings() {
        return this.m_quietConflictWarnings;
    }

    public int getRecursionLimit() {
        return this.m_stackGuard.getRecursionLimit();
    }

    public ResultTreeHandler getResultTreeHandler() {
        return this.m_resultTreeHandler;
    }

    public Serializer getSerializer() {
        return this.m_serializer;
    }

    public short getShouldStripSpace(int elementHandle, DTM dtm) {
        try {
            WhiteSpaceInfo info = this.m_stylesheetRoot.getWhiteSpaceInfo(this.m_xcontext, elementHandle, dtm);
            if (info == null) {
                return 3;
            }
            return info.getShouldStripSpace() ? (short)2 : 1;
        }
        catch (TransformerException transformerException) {
            return 3;
        }
    }

    public TransformSnapshot getSnapshot() {
        return new TransformSnapshotImpl(this);
    }

    public StackGuard getStackGuard() {
        return this.m_stackGuard;
    }

    public ObjectPool getStringWriterPool() {
        return this.m_stringWriterObjectPool;
    }

    public final StylesheetRoot getStylesheet() {
        return this.m_stylesheetRoot;
    }

    public TraceManager getTraceManager() {
        return this.m_traceManager;
    }

    public Thread getTransformThread() {
        return this.m_transformThread;
    }

    public Transformer getTransformer() {
        return this;
    }

    public URIResolver getURIResolver() {
        return this.m_xcontext.getSourceTreeManager().getURIResolver();
    }

    public final XPathContext getXPathContext() {
        return this.m_xcontext;
    }

    public boolean hasTransformThreadErrorCatcher() {
        return this.m_hasTransformThreadErrorCatcher;
    }

    public boolean isParserEventsOnMain() {
        return this.m_parserEventsOnMain;
    }

    public boolean isRecursiveAttrSet(ElemAttributeSet attrSet) {
        int loc;
        if (this.m_attrSetStack == null) {
            this.m_attrSetStack = new Stack();
        }
        return !this.m_attrSetStack.empty() && (loc = this.m_attrSetStack.search(attrSet)) > -1;
    }

    public boolean isTransformDone() {
        TransformerImpl transformerImpl = this;
        synchronized (transformerImpl) {
            boolean bl = this.m_isTransformDone;
            Object var3_3 = null;
            return bl;
        }
    }

    public void popCurrentMatched() {
        this.m_currentMatchTemplates.pop();
        this.m_currentMatchedNodes.pop();
    }

    public void popCurrentTemplateRuleIsNull() {
        this.m_currentTemplateRuleIsNull.pop();
    }

    public void popElemAttributeSet() {
        this.m_attrSetStack.pop();
    }

    public void popElemTemplateElement() {
        --this.m_currentTemplateElementsTop;
    }

    public void popMode() {
        this.m_modes.pop();
    }

    void postExceptionFromThread(Exception e) {
        ContentHandler ch = this.getContentHandler();
        this.m_isTransformDone = true;
        this.m_exceptionThrown = e;
        TransformerImpl transformerImpl = this;
        synchronized (transformerImpl) {
            this.notifyAll();
        }
    }

    public Vector processSortKeys(ElemForEach foreach, int sourceNodeContext) throws TransformerException {
        Vector<NodeSortKey> keys = null;
        XPathContext xctxt = this.m_xcontext;
        int nElems = foreach.getSortElemCount();
        if (nElems > 0) {
            keys = new Vector<NodeSortKey>();
        }
        int i = 0;
        while (i < nElems) {
            boolean caseOrderUpper;
            ElemSort sort = foreach.getSortElem(i);
            String langString = sort.getLang() != null ? sort.getLang().evaluate(xctxt, sourceNodeContext, foreach) : null;
            String dataTypeString = sort.getDataType().evaluate(xctxt, sourceNodeContext, foreach);
            if (dataTypeString.indexOf(":") >= 0) {
                System.out.println("TODO: Need to write the hooks for QNAME sort data type");
            } else if (!dataTypeString.equalsIgnoreCase("text") && !dataTypeString.equalsIgnoreCase("number")) {
                foreach.error(93, new Object[]{"data-type", dataTypeString});
            }
            boolean treatAsNumbers = dataTypeString != null && dataTypeString.equals("number");
            String orderString = sort.getOrder().evaluate(xctxt, sourceNodeContext, foreach);
            if (!orderString.equalsIgnoreCase("ascending") && !orderString.equalsIgnoreCase("descending")) {
                foreach.error(93, new Object[]{"order", orderString});
            }
            boolean descending = orderString != null && orderString.equals("descending");
            AVT caseOrder = sort.getCaseOrder();
            if (caseOrder != null) {
                String caseOrderString = caseOrder.evaluate(xctxt, sourceNodeContext, foreach);
                if (!caseOrderString.equalsIgnoreCase("upper-first") && !caseOrderString.equalsIgnoreCase("lower-first")) {
                    foreach.error(93, new Object[]{"case-order", caseOrderString});
                }
                caseOrderUpper = caseOrderString != null && caseOrderString.equals("upper-first");
            } else {
                caseOrderUpper = false;
            }
            keys.addElement(new NodeSortKey(this, sort.getSelect(), treatAsNumbers, descending, langString, caseOrderUpper, foreach));
            ++i;
        }
        return keys;
    }

    public void pushCurrentTemplateRuleIsNull(boolean b) {
        this.m_currentTemplateRuleIsNull.push(b);
    }

    public void pushElemAttributeSet(ElemAttributeSet attrSet) {
        this.m_attrSetStack.push(attrSet);
    }

    public void pushElemTemplateElement(ElemTemplateElement elem) {
        this.m_currentTemplateElements[this.m_currentTemplateElementsTop++] = elem;
    }

    protected void pushGlobalVars(int contextNode) throws TransformerException {
        XPathContext xctxt = this.m_xcontext;
        VariableStack vs = xctxt.getVarStack();
        StylesheetRoot sr = this.getStylesheet();
        Vector vars = sr.getVariablesAndParamsComposed();
        int i = vars.size();
        vs.link(i);
        while (--i >= 0) {
            ElemVariable v = (ElemVariable)vars.elementAt(i);
            XUnresolvedVariable xobj = new XUnresolvedVariable(v, contextNode, this, vs.getStackFrame(), 0, true);
            if (vs.elementAt(i) != null) continue;
            vs.setGlobalVariable(i, xobj);
        }
    }

    public void pushMode(QName mode) {
        this.m_modes.push(mode);
    }

    public void pushPairCurrentMatched(ElemTemplateElement template, int child) {
        this.m_currentMatchTemplates.push(template);
        this.m_currentMatchedNodes.push(child);
    }

    private void replaceOrPushUserParam(QName qname, XObject xval) {
        int n = this.m_userParams.size();
        int i = n - 1;
        while (i >= 0) {
            Arg arg = (Arg)this.m_userParams.elementAt(i);
            if (arg.getQName().equals(qname)) {
                this.m_userParams.setElementAt(new Arg(qname, xval, true), i);
                return;
            }
            --i;
        }
        this.m_userParams.addElement(new Arg(qname, xval, true));
    }

    public void reset() {
        if (!this.m_hasBeenReset && this.m_shouldReset) {
            this.m_hasBeenReset = true;
            if (this.m_outputStream != null) {
                try {
                    this.m_outputStream.close();
                }
                catch (IOException iOException) {}
            }
            this.m_outputStream = null;
            this.m_countersTable = null;
            this.m_stackGuard = new StackGuard();
            this.m_xcontext.reset();
            this.m_xcontext.getVarStack().reset();
            int n = this.m_currentTemplateElements.length;
            int i = 0;
            while (i < n) {
                this.m_currentTemplateElements[i] = null;
                ++i;
            }
            this.m_currentTemplateElementsTop = 0;
            this.m_currentMatchTemplates.removeAllElements();
            this.m_currentMatchedNodes.removeAllElements();
            this.m_resultTreeHandler = null;
            this.m_outputTarget = null;
            this.m_keyManager = new KeyManager();
            this.m_attrSetStack = null;
            this.m_countersTable = null;
            this.m_currentTemplateRuleIsNull = new BoolStack();
            this.m_xmlSource = null;
            this.m_doc = -1;
            this.m_isTransformDone = false;
            this.m_transformThread = null;
            this.m_xcontext.getSourceTreeManager().reset();
        }
    }

    public void resetToStylesheet(TransformSnapshot ts) {
        ((TransformSnapshotImpl)ts).apply(this);
    }

    public void run() {
        this.m_hasBeenReset = false;
        try {
            try {
                try {
                    this.m_isTransformDone = false;
                    this.transformNode(this.m_doc);
                }
                catch (Exception e) {
                    if (this.m_transformThread != null) {
                        this.postExceptionFromThread(e);
                    }
                    throw new RuntimeException(e.getMessage());
                }
                Object var2_2 = null;
                this.m_isTransformDone = true;
            }
            catch (Throwable throwable) {
                Object var2_3 = null;
                this.m_isTransformDone = true;
                if (this.m_inputContentHandler instanceof TransformerHandlerImpl) {
                    ((TransformerHandlerImpl)this.m_inputContentHandler).clearCoRoutine();
                }
                throw throwable;
            }
            if (this.m_inputContentHandler instanceof TransformerHandlerImpl) {
                ((TransformerHandlerImpl)this.m_inputContentHandler).clearCoRoutine();
            }
        }
        catch (Exception e) {
            if (this.m_transformThread != null) {
                this.postExceptionFromThread(e);
            }
            throw new RuntimeException(e.getMessage());
        }
    }

    public void runTransformThread() {
        tpool.run(this, -1);
    }

    public void runTransformThread(int priority) {
        Thread t = tpool.run(this, priority);
        this.setTransformThread(t);
    }

    public static void runTransformThread(Runnable runnable) {
        tpool.run(runnable, -1);
    }

    public void setBaseURLOfSource(String base) {
        this.m_urlOfSource = base;
    }

    public void setContentHandler(ContentHandler handler) {
        if (handler == null) {
            throw new NullPointerException(XSLMessages.createMessage(150, null));
        }
        this.m_outputContentHandler = handler;
        if (this.m_resultTreeHandler == null) {
            this.m_resultTreeHandler = new ResultTreeHandler(this, handler);
        } else {
            this.m_resultTreeHandler.setContentHandler(handler);
        }
    }

    public void setCurrentElement(ElemTemplateElement e) {
        this.m_currentTemplateElements[this.m_currentTemplateElementsTop - 1] = e;
    }

    public void setErrorListener(ErrorListener listener) throws IllegalArgumentException {
        Boolean bl = this.m_reentryGuard;
        synchronized (bl) {
            if (listener == null) {
                throw new IllegalArgumentException(XSLMessages.createMessage(151, null));
            }
            this.m_errorHandler = listener;
        }
    }

    public void setExceptionThrown(Exception e) {
        this.m_exceptionThrown = e;
    }

    public void setIsTransformDone(boolean done) {
        TransformerImpl transformerImpl = this;
        synchronized (transformerImpl) {
            this.m_isTransformDone = done;
        }
    }

    public void setOutputFormat(OutputProperties oformat) {
        this.m_outputFormat = oformat;
    }

    public void setOutputProperties(Properties oformat) {
        Boolean bl = this.m_reentryGuard;
        synchronized (bl) {
            if (oformat != null) {
                String method = (String)((Hashtable)oformat).get("method");
                this.m_outputFormat = method != null ? new OutputProperties(method) : new OutputProperties();
            }
            if (oformat != null) {
                this.m_outputFormat.copyFrom(oformat);
            }
            this.m_outputFormat.copyFrom(this.m_stylesheetRoot.getOutputProperties());
        }
    }

    public void setOutputProperty(String name, String value) throws IllegalArgumentException {
        Boolean bl = this.m_reentryGuard;
        synchronized (bl) {
            if (this.m_outputFormat == null) {
                this.m_outputFormat = (OutputProperties)this.getStylesheet().getOutputComposed().clone();
            }
            if (!this.m_outputFormat.isLegalPropertyKey(name)) {
                throw new IllegalArgumentException(XSLMessages.createMessage(197, new Object[]{name}));
            }
            this.m_outputFormat.setProperty(name, value);
        }
    }

    public void setOutputTarget(Result outputTarget) {
        this.m_outputTarget = outputTarget;
    }

    public void setParameter(String name, Object value) {
        StringTokenizer tokenizer = new StringTokenizer(name, "{}", false);
        try {
            String s2;
            String s1 = tokenizer.nextToken();
            String string = s2 = tokenizer.hasMoreTokens() ? tokenizer.nextToken() : null;
            if (this.m_userParams == null) {
                this.m_userParams = new Vector();
            }
            if (s2 == null) {
                this.replaceOrPushUserParam(new QName(s1), XObject.create(value, this.getXPathContext()));
                this.setParameter(s1, null, value);
            } else {
                this.replaceOrPushUserParam(new QName(s1, s2), XObject.create(value, this.getXPathContext()));
                this.setParameter(s2, s1, value);
            }
        }
        catch (NoSuchElementException noSuchElementException) {}
    }

    public void setParameter(String name, String namespace, Object value) {
        VariableStack varstack = this.getXPathContext().getVarStack();
        QName qname = new QName(namespace, name);
        XObject xobject = XObject.create(value, this.getXPathContext());
        StylesheetRoot sroot = this.m_stylesheetRoot;
        Vector vars = sroot.getVariablesAndParamsComposed();
        int i = vars.size();
        while (--i >= 0) {
            ElemVariable variable = (ElemVariable)vars.elementAt(i);
            if (variable.getXSLToken() != 41 || !variable.getName().equals(qname)) continue;
            varstack.setGlobalVariable(i, xobject);
        }
    }

    public void setParameters(Properties params) {
        this.clearParameters();
        Enumeration<?> names = params.propertyNames();
        while (names.hasMoreElements()) {
            String name = params.getProperty((String)names.nextElement());
            StringTokenizer tokenizer = new StringTokenizer(name, "{}", false);
            try {
                String s2;
                String s1 = tokenizer.nextToken();
                String string = s2 = tokenizer.hasMoreTokens() ? tokenizer.nextToken() : null;
                if (s2 == null) {
                    this.setParameter(s1, null, params.getProperty(name));
                    continue;
                }
                this.setParameter(s2, s1, params.getProperty(name));
            }
            catch (NoSuchElementException noSuchElementException) {}
        }
    }

    public void setProperty(String property, Object value) {
        if (property.equals("http://xml.apache.org/xalan/properties/source-location")) {
            if (!(value instanceof Boolean)) {
                throw new RuntimeException(XSLMessages.createMessage(177, new Object[]{"http://xml.apache.org/xalan/properties/source-location"}));
            }
            this.m_useSourceLocationProperty = (Boolean)value;
        }
    }

    public void setQuietConflictWarnings(boolean b) {
        this.m_quietConflictWarnings = b;
    }

    public void setRecursionLimit(int limit) {
        this.m_stackGuard.setRecursionLimit(limit);
    }

    public void setSerializer(Serializer s) {
        this.m_serializer = s;
    }

    public void setShouldReset(boolean shouldReset) {
        this.m_shouldReset = shouldReset;
    }

    public void setSourceTreeDocForThread(int doc) {
        this.m_doc = doc;
    }

    public void setStylesheet(StylesheetRoot stylesheetRoot) {
        this.m_stylesheetRoot = stylesheetRoot;
    }

    public static void setThreadControler(ThreadControler tp) {
        tpool = tp;
    }

    public void setTransformThread(Thread t) {
        this.m_transformThread = t;
    }

    public void setURIResolver(URIResolver resolver) {
        Boolean bl = this.m_reentryGuard;
        synchronized (bl) {
            this.m_xcontext.getSourceTreeManager().setURIResolver(resolver);
        }
    }

    public void setXMLSource(Source source) {
        this.m_xmlSource = source;
    }

    public void setXPathContext(XPathContext xcontext) {
        this.m_xcontext = xcontext;
    }

    public void stopTransformation() {
    }

    public void transform(Source source) throws TransformerException {
        this.transform(source, true);
    }

    public void transform(Source xmlSource, Result outputTarget) throws TransformerException {
        this.transform(xmlSource, outputTarget, true);
    }

    public void transform(Source xmlSource, Result outputTarget, boolean shouldRelease) throws TransformerException {
        Boolean bl = this.m_reentryGuard;
        synchronized (bl) {
            ContentHandler handler = this.createResultContentHandler(outputTarget);
            this.m_outputTarget = outputTarget;
            this.setContentHandler(handler);
            this.transform(xmlSource, shouldRelease);
        }
    }

    /*
     * Unable to fully structure code
     */
    public void transform(Source source, boolean shouldRelease) throws TransformerException {
        try {
            block20: {
                try {
                    base = source.getSystemId();
                    if (base == null) {
                        base = this.m_stylesheetRoot.getBaseIdentifier();
                    }
                    if (base == null) {
                        currentDir = "";
                        try {
                            currentDir = System.getProperty("user.dir");
                        }
                        catch (SecurityException v0) {}
                        base = currentDir.startsWith(File.separator) != false ? "file://" + currentDir : "file:///" + currentDir;
                        base = String.valueOf(base) + File.separatorChar + source.getClass().getName();
                    }
                    this.setBaseURLOfSource(base);
                    mgr = this.m_xcontext.getDTMManager();
                    dtm = mgr.getDTM(source, false, this, true, true);
                    dtm.setProperty("http://xml.apache.org/xalan/properties/source-location", new Boolean(this.m_useSourceLocationProperty));
                    hardDelete = true;
                    try {
                        this.transformNode(dtm.getDocument());
                    }
                    finally {
                        var10_13 = null;
                        if (shouldRelease) {
                            mgr.release(dtm, hardDelete);
                        }
                    }
                    e = this.getExceptionThrown();
                    if (e == null) ** GOTO lbl38
                    if (e instanceof TransformerException) {
                        throw (TransformerException)e;
                    }
                    if (e instanceof WrappedRuntimeException) {
                        this.m_errorHandler.fatalError(new TransformerException(((WrappedRuntimeException)e).getException()));
                    } else {
                        throw new TransformerException(e);
lbl38:
                        // 1 sources

                        if (this.m_resultTreeHandler != null) {
                            this.m_resultTreeHandler.endDocument();
                        }
                    }
                }
                catch (WrappedRuntimeException wre) {
                    throwable = wre.getException();
                    ** while (throwable instanceof WrappedRuntimeException)
                }
lbl-1000:
                // 1 sources

                {
                    throwable = ((WrappedRuntimeException)throwable).getException();
                    continue;
                }
lbl46:
                // 1 sources

                this.m_errorHandler.fatalError(new TransformerException(wre.getException()));
                break block20;
                catch (SAXParseException spe) {
                    msg = spe.getMessage();
                    loc = new SAXSourceLocator(spe);
                    this.m_errorHandler.fatalError(new TransformerException(spe));
                }
                catch (SAXException se) {
                    this.m_errorHandler.fatalError(new TransformerException(se));
                }
            }
            var4_17 = null;
            this.m_hasTransformThreadErrorCatcher = false;
            this.reset();
        }
        catch (Throwable var3_19) {
            var4_18 = null;
            this.m_hasTransformThreadErrorCatcher = false;
            this.reset();
            throw var3_19;
        }
    }

    /*
     * Unable to fully structure code
     */
    public void transformNode(int node) throws TransformerException {
        var2_2 = this.m_outputContentHandler;
        synchronized (var2_2) {
            block23: {
                this.m_hasBeenReset = false;
                xctxt = this.getXPathContext();
                dtm = xctxt.getDTM(node);
                try {
                    try {
                        this.pushGlobalVars(node);
                        stylesheet = this.getStylesheet();
                        n = stylesheet.getGlobalImportCount();
                        i = 0;
                        while (i < n) {
                            imported = stylesheet.getGlobalImport(i);
                            includedCount = imported.getIncludeCountComposed();
                            j = -1;
                            while (j < includedCount) {
                                included = imported.getIncludeComposed(j);
                                included.runtimeInit(this);
                                child = included.getFirstChildElem();
                                while (child != null) {
                                    child.runtimeInit(this);
                                    child = child.getNextSiblingElem();
                                }
                                ++j;
                            }
                            ++i;
                        }
                        dtmIter = new SelfIteratorNoPredicate();
                        dtmIter.setRoot(node, xctxt);
                        xctxt.pushContextNodeList(dtmIter);
                        try {
                            this.applyTemplateToNode(null, null, node);
                        }
                        finally {
                            var13_15 = null;
                            xctxt.popContextNodeList();
                        }
                        if (this.m_resultTreeHandler != null) {
                            this.m_resultTreeHandler.endDocument();
                        }
                        break block23;
                    }
                    catch (Exception se) {
                        ** while (se instanceof WrappedRuntimeException)
                    }
lbl-1000:
                    // 1 sources

                    {
                        e = ((WrappedRuntimeException)se).getException();
                        if (e == null) continue;
                        se = e;
                        continue;
                    }
lbl51:
                    // 1 sources

                    if (this.m_resultTreeHandler != null) {
                        try {
                            if (se instanceof SAXParseException) {
                                this.m_resultTreeHandler.fatalError((SAXParseException)se);
                            } else {
                                this.m_resultTreeHandler.fatalError(new SAXParseException(se.getMessage(), new SAXSourceLocator(), se));
                            }
                        }
                        catch (Exception v0) {}
                    }
                    if (se instanceof TransformerException) {
                        this.m_errorHandler.fatalError((TransformerException)se);
                        break block23;
                    }
                    if (se instanceof SAXParseException) {
                        this.m_errorHandler.fatalError(new TransformerException(se.getMessage(), new SAXSourceLocator((SAXParseException)se), se));
                        break block23;
                    }
                    this.m_errorHandler.fatalError(new TransformerException(se));
                }
                catch (Throwable var6_21) {
                    var7_20 = null;
                    this.reset();
                    throw var6_21;
                }
            }
            var7_19 = null;
            this.reset();
        }
    }

    public void transformNode(int node, Result outputTarget) throws TransformerException {
        ContentHandler handler = this.createResultContentHandler(outputTarget);
        this.m_outputTarget = outputTarget;
        this.setContentHandler(handler);
        this.transformNode(node);
    }

    public int transformToRTF(ElemTemplateElement templateParent) throws TransformerException {
        XPathContext xctxt = this.m_xcontext;
        DTM dtmFrag = xctxt.getDTM(null, true, this, false, false);
        ContentHandler rtfHandler = dtmFrag.getContentHandler();
        int resultFragment = dtmFrag.getDocument();
        ResultTreeHandler savedRTreeHandler = this.m_resultTreeHandler;
        ResultTreeHandler rth = this.m_resultTreeHandler = new ResultTreeHandler(this, rtfHandler);
        try {
            try {
                rth.startDocument();
                try {
                    this.executeChildTemplates(templateParent, true);
                    rth.flushPending();
                }
                finally {
                    Object var11_8 = null;
                    rth.endDocument();
                }
            }
            catch (SAXException se) {
                throw new TransformerException(se);
            }
            Object var9_12 = null;
            this.m_resultTreeHandler = savedRTreeHandler;
        }
        catch (Throwable throwable) {
            Object var9_13 = null;
            this.m_resultTreeHandler = savedRTreeHandler;
            throw throwable;
        }
        return resultFragment;
    }

    public String transformToString(ElemTemplateElement elem) throws TransformerException {
        String result;
        ElemTemplateElement firstChild = elem.getFirstChildElem();
        if (firstChild == null) {
            return "";
        }
        if (elem.hasTextLitOnly() && TransformerFactoryImpl.m_optimize) {
            return ((ElemTextLiteral)firstChild).getNodeValue();
        }
        ResultTreeHandler savedRTreeHandler = this.m_resultTreeHandler;
        StringWriter sw = (StringWriter)this.m_stringWriterObjectPool.getInstance();
        this.m_resultTreeHandler = (ResultTreeHandler)this.m_textResultHandlerObjectPool.getInstance();
        Serializer serializer = this.m_resultTreeHandler.getSerializer();
        try {
            if (serializer == null) {
                serializer = SerializerFactory.getSerializer(this.m_textformat.getProperties());
                this.m_resultTreeHandler.setSerializer(serializer);
                serializer.setWriter(sw);
                ContentHandler shandler = serializer.asContentHandler();
                this.m_resultTreeHandler.init(this, shandler);
            }
        }
        catch (IOException ioe) {
            throw new TransformerException(ioe);
        }
        try {
            try {
                this.m_resultTreeHandler.startDocument();
                this.executeChildTemplates(elem, true);
                this.m_resultTreeHandler.endDocument();
                result = sw.toString();
            }
            catch (SAXException se) {
                throw new TransformerException(se);
            }
            Object var8_9 = null;
            sw.getBuffer().setLength(0);
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            sw.getBuffer().setLength(0);
            try {
                sw.close();
            }
            catch (Exception exception) {}
            this.m_stringWriterObjectPool.freeInstance(sw);
            this.m_textResultHandlerObjectPool.freeInstance(this.m_resultTreeHandler);
            this.m_resultTreeHandler.reset();
            this.m_resultTreeHandler = savedRTreeHandler;
            throw throwable;
        }
        try {
            sw.close();
        }
        catch (Exception exception) {}
        this.m_stringWriterObjectPool.freeInstance(sw);
        this.m_textResultHandlerObjectPool.freeInstance(this.m_resultTreeHandler);
        this.m_resultTreeHandler.reset();
        this.m_resultTreeHandler = savedRTreeHandler;
        return result;
    }

    public void waitTransformThread() throws SAXException {
        block3: {
            Thread transformThread = this.getTransformThread();
            if (transformThread == null) break block3;
            try {
                Exception e;
                tpool.waitThread(transformThread, this);
                if (!this.hasTransformThreadErrorCatcher() && (e = this.getExceptionThrown()) != null) {
                    e.printStackTrace();
                    throw new SAXException(e);
                }
                this.setTransformThread(null);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public static class ThreadControler {
        public Thread run(Runnable task, int priority) {
            Thread t = new Thread(task);
            t.start();
            return t;
        }

        public void waitThread(Thread worker, Runnable task) throws InterruptedException {
            worker.join();
        }
    }
}

