/*
 * Decompiled with CFR 0.152.
 */
package javak.bo.sqlBuilder;

import antlr.ANTLRException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.Enumeration;
import java.util.Vector;
import javak.bo.BOAssert;
import javak.bo.DBInfoSpecific;
import javak.bo.ModelAttribute;
import javak.bo.ModelTable;
import javak.bo.sqlBuilder.BOSqlBuilderConstants;
import javak.bo.sqlBuilder.ViewBottomArea;
import javak.bo.sqlBuilder.boAttrModificationManager;
import javak.bo.sqlBuilder.boMultiAttrBox;
import javak.bo.sqlBuilder.sqlBuilderModel;
import javak.bo.sqlBuilder.sqlBuilderStringManipulater;
import javak.bo.sqlBuilder.sqlreader.SqlLexer;
import javak.bo.sqlBuilder.sqlreader.SqlParser;
import javak.bo.sqlBuilder.sqlreader.TreeWalker;
import javak.exception.BOjavakException;
import javak.iface.bo.I_BOError;
import javak.iface.bo.I_BOSetText;
import javak.iface.bo.I_SQLRenderer;
import javak.iface.bo.I_StateChange;
import javak.iface.bo.I_VisualActionListener;

public class sqlBuilderController {
    private sqlBuilderModel m_model;
    private Vector m_statements = null;
    private boMultiAttrBox builderRegion = null;
    private boAttrModificationManager modManager = null;
    private Vector buildListeners = null;
    private Vector errorListeners = null;
    private Vector stateChangeListeners = null;
    private String statementType = null;
    private ViewBottomArea bottomTabbedPane = null;
    sqlBuilderStringManipulater manip = null;

    public sqlBuilderController(sqlBuilderModel sqlBuilderModel2, DBInfoSpecific[] dBInfoSpecificArray) throws BOjavakException {
        this.manip = new sqlBuilderStringManipulater(dBInfoSpecificArray);
        this.buildListeners = new Vector(2, 2);
        this.errorListeners = new Vector(2, 2);
        this.stateChangeListeners = new Vector(2, 2);
        this.setModel(sqlBuilderModel2);
        this.modManager = new boAttrModificationManager(this, this.getStatementType());
        this.builderRegion = new boMultiAttrBox(this.modManager, this);
        this.bottomTabbedPane = new ViewBottomArea(this.modManager, this);
        this.m_statements = new Vector(7, 1);
        this.m_statements.addElement("Select");
        this.m_statements.addElement("Select (grouped by...)");
        this.m_statements.addElement("Update");
        this.m_statements.addElement("Insert by values");
        this.m_statements.addElement("Insert by select");
        this.m_statements.addElement("Delete");
        this.m_statements.addElement("Count results");
        this.setStatementType("Select");
    }

    public sqlBuilderController(DBInfoSpecific[] dBInfoSpecificArray) throws BOjavakException {
        this(new sqlBuilderModel(), dBInfoSpecificArray);
    }

    public sqlBuilderStringManipulater getStringManipulater() {
        return this.manip;
    }

    protected boAttrModificationManager getAttributeModificationManager() {
        return this.modManager;
    }

    public boMultiAttrBox getBuilderManager() {
        return this.builderRegion;
    }

    public Vector getStatements() {
        return this.m_statements;
    }

    public String getStatementType() {
        return this.statementType;
    }

    public sqlBuilderModel getModel() {
        return this.m_model;
    }

    public ViewBottomArea getBottomArea() {
        return this.bottomTabbedPane;
    }

    public void revalidateTableView() {
        this.builderRegion.revalidateTableView();
    }

    public void activateCriteriaPane() {
        this.bottomTabbedPane.activateCriteriaPane();
    }

    public void setModel(sqlBuilderModel sqlBuilderModel2) {
        this.m_model = sqlBuilderModel2;
        this.m_model.setStringManipulater(this.manip);
    }

    public void addStatementListener(I_BOSetText i_BOSetText) {
        if (!this.buildListeners.contains(i_BOSetText)) {
            this.buildListeners.add(i_BOSetText);
        }
    }

    public void removeStatementListener(I_BOSetText i_BOSetText) {
        this.buildListeners.remove(i_BOSetText);
    }

    public void addErrorListener(I_BOError i_BOError) {
        if (!this.errorListeners.contains(i_BOError)) {
            this.errorListeners.add(i_BOError);
        }
    }

    public void removeErrorListener(I_BOError i_BOError) {
        this.errorListeners.remove(i_BOError);
    }

    public void addStateChangeListener(I_StateChange i_StateChange) {
        if (!this.stateChangeListeners.contains(i_StateChange)) {
            this.stateChangeListeners.add(i_StateChange);
        }
    }

    public void removeStateChangeListener(I_StateChange i_StateChange) {
        this.stateChangeListeners.remove(i_StateChange);
    }

    public void addVisualActionListener(I_VisualActionListener i_VisualActionListener) {
        this.getBuilderManager().addVisualActionListener(i_VisualActionListener);
    }

    public void removeVisualActionListener(I_VisualActionListener i_VisualActionListener) {
        this.getBuilderManager().removeVisualActionListener(i_VisualActionListener);
    }

    private void fireBuildEvent(I_SQLRenderer i_SQLRenderer) {
        Enumeration enumeration = this.buildListeners.elements();
        while (enumeration.hasMoreElements()) {
            I_BOSetText i_BOSetText = (I_BOSetText)enumeration.nextElement();
            try {
                i_BOSetText.boSetText(i_SQLRenderer);
            }
            catch (BOjavakException bOjavakException) {
                this.setErrorMsg("Unable to show statement.");
            }
        }
    }

    private void fireErrorEvent(String string) {
        Enumeration enumeration = this.errorListeners.elements();
        while (enumeration.hasMoreElements()) {
            I_BOError i_BOError = (I_BOError)enumeration.nextElement();
            i_BOError.setErrorMessage(string);
        }
    }

    private void fireStateChangeEvent() {
        Enumeration enumeration = this.stateChangeListeners.elements();
        while (enumeration.hasMoreElements()) {
            I_StateChange i_StateChange = (I_StateChange)enumeration.nextElement();
            i_StateChange.setCurrentStatementType(this.statementType);
        }
    }

    public void setStatementType(String string) {
        if (this.statementType != null && this.statementType.equals(string)) {
            return;
        }
        try {
            this.modManager.triggerQueryTypeChange(string);
            this.statementType = string;
            this.fireStateChangeEvent();
        }
        catch (BOjavakException bOjavakException) {
            this.setErrorMsg(bOjavakException.toString());
        }
    }

    public String getNameLastActiveFrame() {
        return this.builderRegion.getNameLastActiveFrame();
    }

    public void setInsertTable(String string) throws BOjavakException {
        this.builderRegion.setInsertTable(this.m_model.getTableNoCase(string));
    }

    public void setErrorMsg(String string) {
        this.fireErrorEvent(string);
    }

    public Object addTable(String string) throws BOjavakException {
        return this.builderRegion.createNewBox(this.m_model.getTableNoCase(string));
    }

    public void removeTable(String string) {
        this.builderRegion.removeTable(string);
    }

    public void resetView() {
        this.builderRegion.removeAllTables();
        this.getBottomArea().clearAreas();
    }

    public void createRelation(String string, String string2, String string3, String string4, int n) throws BOjavakException {
        BOAssert.assert(string != null, "Tablename 'from' is invalid (null)");
        BOAssert.assert(string3 != null, "Tablename 'to' is invalid (null)");
        BOAssert.assert(string2 != null, "Relationname 'from' is invalid (null)");
        BOAssert.assert(string4 != null, "Relationname 'to' is invalid (null)");
        ModelTable modelTable = this.m_model.getTableNoCase(string);
        BOAssert.assert(modelTable != null, string + " is an unknown Tablename!");
        string = modelTable.getName();
        ModelAttribute modelAttribute = modelTable.getAttributeNoCase(string2);
        BOAssert.assert(modelAttribute != null, string2 + " is an unknown Attributename in table " + string + "!");
        string2 = modelAttribute.getName();
        modelTable = this.m_model.getTableNoCase(string3);
        BOAssert.assert(modelTable != null, string3 + " is an unknown Tablename!");
        string3 = modelTable.getName();
        modelAttribute = modelTable.getAttributeNoCase(string4);
        BOAssert.assert(modelAttribute != null, string4 + " is an unknown Attributename in table " + string3 + "!");
        string4 = modelAttribute.getName();
        this.builderRegion.createRelation(string, string2, string3, string4, n);
    }

    public I_SQLRenderer getSQLStatement() {
        I_SQLRenderer i_SQLRenderer = null;
        try {
            i_SQLRenderer = this.getSQLStatementInternal();
            this.fireBuildEvent(i_SQLRenderer);
        }
        catch (BOjavakException bOjavakException) {
            this.setErrorMsg(bOjavakException.toString());
        }
        return i_SQLRenderer;
    }

    public void addTable(String string, String string2, String string3, String string4, String string5) throws BOjavakException {
        this.activateCriteriaPane();
        this.getAttributeModificationManager().addTable(string, string2, string3, string4, string5, true, "", "", "", "");
    }

    public I_SQLRenderer getSQLStatementInternal() throws BOjavakException {
        return this.builderRegion.buildQuery(this.getStatementType());
    }

    public void setSQLStatement(String string) throws BOjavakException {
        Object object;
        if (string == null || string.trim().equals("")) {
            return;
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        PrintStream printStream = new PrintStream(byteArrayOutputStream);
        PrintStream printStream2 = System.err;
        SqlLexer sqlLexer = new SqlLexer(new ByteArrayInputStream(string.getBytes()));
        SqlParser sqlParser = new SqlParser(sqlLexer);
        try {
            try {
                System.setErr(printStream);
                sqlParser.start();
                object = byteArrayOutputStream.toString().trim();
                if (((String)object).length() > 0) {
                    throw new BOjavakException(BOSqlBuilderConstants.CONST_LINEFEED + "Statement " + (String)object);
                }
                Object var10_9 = null;
            }
            catch (ANTLRException aNTLRException) {
                throw new BOjavakException(aNTLRException.getMessage());
            }
            catch (Exception exception) {
                throw new BOjavakException(exception.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            System.setErr(printStream2);
            throw throwable;
        }
        System.setErr(printStream2);
        this.setStatementType(sqlParser.getStatementType());
        object = new TreeWalker(sqlParser.getAST(), this);
        ((TreeWalker)object).treeToVisual();
    }

    public void addSelectedAttribute(String string, String string2, String string3, String string4, String string5, boolean bl, String string6, String string7, String string8, String string9) throws BOjavakException {
        ModelTable modelTable = this.m_model.getTableNoCase(string);
        BOAssert.assert(modelTable != null, string + " is unknown!");
        ModelAttribute modelAttribute = modelTable.getAttributeNoCase(string2);
        BOAssert.assert(modelAttribute != null, string2 + " is an unknown attribute in table " + string + "!");
        this.modManager.addTable(modelTable.getName(), modelAttribute.getName(), string3, string4, string5, bl, string6, string7, string8, string9);
    }
}

