/*
 * Decompiled with CFR 0.152.
 */
package javak.bo.resultViewer;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Hashtable;
import java.util.Vector;
import javak.bo.BOAssert;
import javak.bo.resultViewer.resultViewerTable;
import javak.exception.BOjavakException;
import javak.iface.bo.I_BOResultFetcher;
import javak.iface.bo.I_BOResultViewer;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.table.DefaultTableModel;

public class resultViewerMain
extends JPanel
implements I_BOResultViewer {
    private final String BUT_ALLRESULTS = "Get remaining results";
    private final String BUT_NEXTRESULTS = "Get next results";
    private JTextArea sqlShowField = null;
    private JTextArea statusField = null;
    private JButton butNextResults = null;
    private JButton butAllResults = null;
    private resultViewerTable resultTable = null;
    private JScrollPane tableScrollPane = null;
    private Object dbInfos = null;
    private I_BOResultFetcher resultFetcher = null;

    private resultViewerMain getSelfReference() {
        return this;
    }

    public resultViewerMain(I_BOResultFetcher i_BOResultFetcher, Object object) {
        super(new BorderLayout());
        this.dbInfos = object;
        this.resultFetcher = i_BOResultFetcher;
        this.sqlShowField = new JTextArea(8, 80);
        this.sqlShowField.setFont(new Font("monospaced", 0, 12));
        this.sqlShowField.setEditable(false);
        this.statusField = new JTextArea();
        this.statusField.setEnabled(false);
        this.resultTable = new resultViewerTable(new DefaultTableModel());
        this.tableScrollPane = new JScrollPane(this.resultTable);
        this.butNextResults = new JButton("Get next results");
        this.butAllResults = new JButton("Get remaining results");
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                String string = actionEvent.getActionCommand();
                try {
                    if (string.equals("Get next results")) {
                        resultViewerMain.this.appendResults(resultViewerMain.this.resultFetcher.getNextResults(resultViewerMain.this.dbInfos, resultViewerMain.this.getSelfReference()));
                    } else if (string.equals("Get remaining results")) {
                        resultViewerMain.this.appendResults(resultViewerMain.this.resultFetcher.getAllResults(resultViewerMain.this.dbInfos, resultViewerMain.this.getSelfReference()));
                    }
                }
                catch (BOjavakException bOjavakException) {
                    JOptionPane.showMessageDialog(resultViewerMain.this.resultTable, bOjavakException.toString(), "Error", 0);
                }
            }
        };
        this.butNextResults.addActionListener(actionListener);
        this.butAllResults.addActionListener(actionListener);
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)new JScrollPane(this.sqlShowField), "Center");
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        this.addComponent(jPanel2, this.butNextResults, 0, 0, 1, 1, 2, 18);
        this.addComponent(jPanel2, this.butAllResults, 1, 0, 1, 1, 2, 18);
        this.addComponent(jPanel2, this.statusField, 0, 1, 2, 1, 2, 18);
        this.add((Component)jPanel, "North");
        this.add((Component)this.tableScrollPane, "Center");
        this.add((Component)jPanel2, "South");
    }

    public void disableNextResultButtons() {
        this.butNextResults.setEnabled(false);
        this.butAllResults.setEnabled(false);
    }

    private void addComponent(Container container, Component component, int n, int n2, int n3, int n4, int n5, int n6) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = n3;
        gridBagConstraints.gridheight = n4;
        gridBagConstraints.fill = n5;
        gridBagConstraints.anchor = n6;
        container.add(component, gridBagConstraints);
    }

    public void setQuery(String string) throws BOjavakException {
        BOAssert.assert(string != null, "Query is invalid (null)");
        this.sqlShowField.setText(string);
    }

    public void setStatus(String string) throws BOjavakException {
        BOAssert.assert(string != null, "Status is invalid (null)");
        this.statusField.setText(string);
    }

    public void setResultColumnNames(String[] stringArray) throws BOjavakException {
        BOAssert.assert(stringArray != null, "Columnnames are invalid (null)");
        this.resultTable.setResultColumnNames(stringArray);
    }

    public void setResults(String[][] stringArray) throws BOjavakException {
        BOAssert.assert(stringArray != null, "Results are invalid (null)");
        this.resultTable.setResults(stringArray);
    }

    public void appendResults(String[][] stringArray) throws BOjavakException {
        this.resultTable.appendResults(stringArray);
    }

    public void setResultColumnNames(Vector vector) throws BOjavakException {
        BOAssert.assert(vector != null, "Columnnames are invalid (null)");
        this.resultTable.setResultColumnNames(vector);
    }

    public void setResultColumnNames(Hashtable hashtable) throws BOjavakException {
        BOAssert.assert(hashtable != null, "Columnnames are invalid (null)");
        this.resultTable.setResultColumnNames(hashtable);
    }

    public void setResults(Vector vector) throws BOjavakException {
        BOAssert.assert(vector != null, "Results are invalid (null)");
        this.resultTable.setResults(vector);
    }

    public void appendResults(Vector vector) throws BOjavakException {
        BOAssert.assert(vector != null, "Results are invalid (null)");
        this.resultTable.appendResults(vector);
    }

    public void setNoMoreResults() throws BOjavakException {
        this.butAllResults.setEnabled(false);
        this.butNextResults.setEnabled(false);
    }

    public JPanel getPanel() {
        return this;
    }
}

