/*
 * Decompiled with CFR 0.152.
 */
package kgd.card.player.io;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.InflaterInputStream;
import kgd.card.player.gui.Header;
import kgd.card.player.gui.Tools;

public final class HeaderCodec {
    private List ivHeaders = new ArrayList();

    public HeaderCodec() {
        this.decode();
    }

    private void decode() {
        File file = new File(Tools.DIR_GAMES);
        File[] fileArray = file.listFiles();
        int n = 0;
        while (n < fileArray.length) {
            if (fileArray[n].isFile() && fileArray[n].getAbsolutePath().endsWith(".dat")) {
                Header header = new Header(fileArray[n]);
                try {
                    String string;
                    FileInputStream fileInputStream = new FileInputStream(fileArray[n]);
                    BufferedInputStream bufferedInputStream = new BufferedInputStream(fileInputStream);
                    InflaterInputStream inflaterInputStream = new InflaterInputStream(bufferedInputStream);
                    InputStreamReader inputStreamReader = new InputStreamReader(inflaterInputStream);
                    BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
                    while ((string = bufferedReader.readLine()) != null) {
                        this.decodeHeader(header, string);
                    }
                    bufferedReader.close();
                    inputStreamReader.close();
                    inflaterInputStream.close();
                    bufferedInputStream.close();
                    fileInputStream.close();
                }
                catch (Exception exception) {}
                if (header.getName() != null) {
                    this.ivHeaders.add(header);
                }
            }
            ++n;
        }
    }

    private void decodeHeader(Header header, String string) {
        int n = string.indexOf(":");
        if (n == 0) {
            header.getLines().add(string);
            return;
        }
        String string2 = string.substring(0, n);
        String string3 = string.substring(n + 1);
        if (!string2.equals("GAME")) {
            header.getLines().add(string);
            return;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string3, ";");
        while (stringTokenizer.hasMoreTokens()) {
            String string4 = stringTokenizer.nextToken();
            int n2 = string4.indexOf("=");
            String string5 = string4.substring(0, n2);
            String string6 = string4.substring(n2 + 1);
            if (string5.equals("Name")) {
                header.setName(string6);
                continue;
            }
            if (string5.equals("Type")) {
                header.setType(string6);
                continue;
            }
            if (string5.equals("Decks")) {
                header.setDecks(new Integer(string6));
                continue;
            }
            if (string5.equals("Open")) {
                header.setOpen(new Boolean(string6));
                continue;
            }
            if (string5.equals("Level")) {
                header.setLevel(new Integer(string6));
                continue;
            }
            if (string5.equals("Favorite")) {
                header.setFavorite(new Boolean(string6));
                continue;
            }
            if (string5.equals("LockCards")) {
                header.setLockCards(string6);
                continue;
            }
            if (string5.equals("Freecell")) {
                header.setFreecell(new Boolean(string6));
                continue;
            }
            if (string5.equals("SynchronizedFoundations")) {
                header.setSynchronizedFoundations(new Boolean(string6));
                continue;
            }
            if (string5.equals("Grid")) {
                header.setGrid(new Integer(string6));
                continue;
            }
            if (string5.equals("Columns")) {
                header.setColumns(new Integer(string6));
                continue;
            }
            if (!string5.equals("Rows")) continue;
            header.setRows(new Integer(string6));
        }
    }

    public List getHeaders() {
        return this.ivHeaders;
    }

    public void updateHeader(Header header) {
        File file = header.getFile();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("GAME:");
        stringBuffer.append("Name=" + header.getName() + ";");
        stringBuffer.append("Type=" + header.getType() + ";");
        stringBuffer.append("Decks=" + String.valueOf(header.getDecks()) + ";");
        stringBuffer.append("Open=" + String.valueOf(header.isOpen()) + ";");
        stringBuffer.append("Level=" + String.valueOf(header.getLevel()) + ";");
        stringBuffer.append("Favorite=" + String.valueOf(header.isFavorite()) + ";");
        stringBuffer.append("LockCards=" + header.getLockCards() + ";");
        stringBuffer.append("Freecell=" + String.valueOf(header.isFreecell()) + ";");
        stringBuffer.append("SynchronizedFoundations=" + String.valueOf(header.isSynchronizedFoundations()) + ";");
        stringBuffer.append("Grid=" + String.valueOf(header.getGrid()) + ";");
        stringBuffer.append("Columns=" + String.valueOf(header.getColumns()) + ";");
        stringBuffer.append("Rows=" + String.valueOf(header.getRows()));
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileOutputStream);
            DeflaterOutputStream deflaterOutputStream = new DeflaterOutputStream(bufferedOutputStream);
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter(deflaterOutputStream);
            BufferedWriter bufferedWriter = new BufferedWriter(outputStreamWriter);
            bufferedWriter.write(stringBuffer.toString());
            bufferedWriter.newLine();
            int n = 0;
            while (n < header.getLines().size()) {
                bufferedWriter.write((String)header.getLines().get(n));
                bufferedWriter.newLine();
                ++n;
            }
            bufferedWriter.close();
            outputStreamWriter.close();
            deflaterOutputStream.close();
            bufferedOutputStream.close();
            fileOutputStream.close();
        }
        catch (Exception exception) {}
    }
}

