/*
 * Decompiled with CFR 0.152.
 */
package kgd.card.player.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.TexturePaint;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.List;
import java.util.Random;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.Timer;
import kgd.card.player.data.Card;
import kgd.card.player.data.Drag;
import kgd.card.player.data.Foundation;
import kgd.card.player.data.Game;
import kgd.card.player.data.Pile;
import kgd.card.player.data.Stock;
import kgd.card.player.gui.CardUI;
import kgd.card.player.gui.DragUI;
import kgd.card.player.gui.PileUI;
import kgd.card.player.gui.Tools;
import kgd.card.player.gui.WidgetUI;

public final class GameUI
extends JPanel {
    public static final int GRID_RECTANGLE = 0;
    public static final int GRID_WALL = 1;
    public static final int GRID_PYRAMID = 2;
    public static final Cursor CURSOR_DEFAULT = new Cursor(0);
    public static final Cursor CURSOR_DRAG = new Cursor(12);
    public static final int GRADIENT_NONE = 0;
    public static final int GRADIENT_HORIZONTAL = 1;
    public static final int GRADIENT_VERTICAL = 2;
    public static final int IMAGE_CENTERED = 0;
    public static final int IMAGE_MOZAIC = 1;
    public static final int IMAGE_CENTERED_SCALED = 2;
    public static final int SCALE_640 = 1;
    public static final int SCALE_800 = 2;
    public static final int SCALE_1024 = 3;
    private int ivGrid;
    private int ivColumns;
    private int ivRows;
    private Game ivGame = null;
    private Color ivBackColor1 = Color.orange;
    private Color ivBackColor2 = Color.orange;
    private int ivBackColorOption = 0;
    private String ivBackImage = null;
    private BufferedImage ivBufImage = null;
    private int ivBackImageOption = 0;
    private int ivScale = 0;
    private DragUI ivDragUI = null;
    int ivDragX;
    int ivDragY;
    private String ivCardSet = null;
    private String ivCardBack = null;
    private int ivAnims = 6;
    private boolean ivPlayingVictory = false;
    private Timer ivVictoryTimer;
    private String ivVictoryTitle;
    private JLabel ivVictoryLabel;
    private JLabel ivVictoryLabelShadow;

    public GameUI(Game game) {
        super(null, false);
        this.ivGame = game;
        this.ivGrid = 0;
        this.ivColumns = 1;
        this.ivRows = 1;
        this.setOpaque(true);
        this.setBackground(Color.orange);
        this.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                GameUI.this.eventMousePressed(mouseEvent);
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                GameUI.this.eventMouseReleased(mouseEvent);
            }
        });
        this.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseDragged(MouseEvent mouseEvent) {
                GameUI.this.eventMouseDragged(mouseEvent);
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent componentEvent) {
                GameUI.this.eventResized();
            }
        });
        this.ivVictoryTimer = new Timer(500, new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (GameUI.this.ivPlayingVictory) {
                    GameUI.this.playVictory();
                } else {
                    GameUI.this.ivVictoryTimer.stop();
                }
            }
        });
    }

    public void addWidgetUI(WidgetUI widgetUI) {
        this.add((Component)widgetUI, 0);
        this.updateWidgetUI(widgetUI);
        this.paintImmediately(widgetUI.getBounds());
    }

    private void eventMouseDragged(MouseEvent mouseEvent) {
        if (this.ivDragUI == null) {
            return;
        }
        int n = mouseEvent.getX() - this.ivDragX;
        int n2 = mouseEvent.getY() - this.ivDragY;
        int n3 = 0;
        while (n3 < this.ivDragUI.getSourceCardUIs().length) {
            CardUI cardUI = this.ivDragUI.getSourceCardUIs()[n3];
            int n4 = cardUI.getX() + n;
            int n5 = cardUI.getY() + n2;
            cardUI.setLocation(n4, n5);
            ++n3;
        }
        this.ivDragUI.searchTarget();
        this.ivDragX = mouseEvent.getX();
        this.ivDragY = mouseEvent.getY();
    }

    private void eventMousePressed(MouseEvent mouseEvent) {
        Pile pile;
        PileUI pileUI;
        Card card;
        CardUI cardUI;
        boolean bl;
        this.ivDragX = mouseEvent.getX();
        this.ivDragY = mouseEvent.getY();
        this.ivDragUI = null;
        if (this.ivGame == null) {
            return;
        }
        Component component = this.getComponentAt(mouseEvent.getPoint());
        if (!(component instanceof WidgetUI)) {
            return;
        }
        WidgetUI widgetUI = (WidgetUI)component;
        int n = 0;
        boolean bl2 = (mouseEvent.getModifiers() & 0x10) != 0;
        boolean bl3 = (mouseEvent.getModifiers() & 4) != 0;
        boolean bl4 = (mouseEvent.getModifiers() & 8) != 0;
        boolean bl5 = (mouseEvent.getModifiers() & 2) != 0;
        boolean bl6 = (mouseEvent.getModifiers() & 1) != 0;
        boolean bl7 = bl = (mouseEvent.getModifiers() & 0x20) != 0;
        if (!(!bl2 || bl4 || bl5 || bl6 || bl)) {
            n = 1;
        } else if (bl2 && !bl4 && bl5 && !bl6 && !bl) {
            n = 2;
        } else if (!(!bl3 || bl4 || bl5 || bl6 || bl)) {
            n = 2;
        }
        if (n == 0) {
            return;
        }
        this.setCursor(CURSOR_DRAG);
        if (widgetUI instanceof PileUI) {
            cardUI = null;
            card = null;
            pileUI = (PileUI)widgetUI;
            pile = (Pile)pileUI.getWidget();
        } else {
            cardUI = (CardUI)widgetUI;
            card = (Card)cardUI.getWidget();
            pileUI = (PileUI)card.getPile().getListener();
            pile = card.getPile();
        }
        switch (n) {
            case 1: {
                Drag drag;
                if (pile instanceof Stock) {
                    this.ivGame.eventDealStock();
                    break;
                }
                if (card == null || (drag = this.ivGame.eventStartMove(card)) == null) break;
                this.ivDragUI = new DragUI(drag);
                int n2 = 0;
                while (n2 < this.ivDragUI.getSourceCardUIs().length) {
                    this.add((Component)this.ivDragUI.getSourceCardUIs()[n2], 0);
                    ++n2;
                }
                break;
            }
            case 2: {
                if (pile instanceof Stock) {
                    this.ivGame.eventDealStock();
                    break;
                }
                if (card == null || this.ivGame.eventAutoMove(card)) break;
                Tools.playSound("Wrong");
                break;
            }
        }
    }

    private void eventMouseReleased(MouseEvent mouseEvent) {
        this.setCursor(CURSOR_DEFAULT);
        if (this.ivGame == null) {
            return;
        }
        if (this.ivDragUI != null) {
            this.ivDragUI.end();
            this.ivGame.eventStopMove(this.ivDragUI.getDrag());
        }
    }

    private void eventResized() {
        WidgetUI widgetUI;
        int n = 0;
        while (n < this.getComponentCount()) {
            if (this.getComponent(n) instanceof PileUI) {
                widgetUI = (WidgetUI)this.getComponent(n);
                widgetUI.setLocation(this.findLocationForWidgetUI(widgetUI));
            }
            ++n;
        }
        int n2 = 0;
        while (n2 < this.getComponentCount()) {
            if (this.getComponent(n2) instanceof CardUI) {
                widgetUI = (WidgetUI)this.getComponent(n2);
                widgetUI.setLocation(this.findLocationForWidgetUI(widgetUI));
            }
            ++n2;
        }
    }

    private Point findLocationForCardUI(CardUI cardUI, PileUI pileUI, int n) {
        if (pileUI == null) {
            return new Point(-cardUI.getWidth(), -cardUI.getHeight());
        }
        int n2 = 0;
        int n3 = 0;
        switch (this.ivScale) {
            case 1: {
                n2 = 15;
                n3 = 12;
                break;
            }
            case 2: {
                n2 = 17;
                n3 = 14;
                break;
            }
            case 3: {
                n2 = 19;
                n3 = 15;
                break;
            }
        }
        int n4 = pileUI.getX();
        int n5 = pileUI.getY();
        switch (pileUI.getPiling()) {
            case 0: {
                n4 += (n /= this.ivGame.getDecks()) / 3;
                break;
            }
            case 1: {
                int n6 = (n /= this.ivGame.getDecks()) / 3 * 2;
                int n7 = n % 3 * 4;
                n4 += n6;
                n5 -= n7;
                break;
            }
            case 3: {
                n5 += n * n2;
                break;
            }
            case 4: {
                n4 += n * n3;
                break;
            }
            case 5: {
                n5 += n * n2 / 2;
                break;
            }
            case 6: {
                n4 += n * n3 / 2;
                break;
            }
        }
        return new Point(n4, n5);
    }

    private Point findLocationForPileUI(PileUI pileUI) {
        int n;
        int n2;
        int n3 = pileUI.getGridLocation().x;
        int n4 = pileUI.getGridLocation().y;
        int n5 = 0;
        int n6 = 0;
        if (this.ivGrid == 0) {
            n2 = this.getWidth() / this.ivColumns;
            n = this.getHeight() / this.ivRows;
            n5 = n2 * n3 + n2 / 2 - pileUI.getWidth() / 2;
            n6 = n * n4 + n / 2 - pileUI.getHeight() / 2;
        }
        if (this.ivGrid == 1) {
            n2 = this.getWidth() / this.ivColumns;
            n = this.getHeight() / this.ivRows;
            n5 = n2 * n3 + n2 / 2 - pileUI.getWidth() / 2;
            n6 = n * n4 + n / 2 - pileUI.getHeight() / 2;
            if (n4 % 2 == 0) {
                n5 += n2 / 2;
            }
        }
        return new Point(n5, n6);
    }

    private Point findLocationForWidgetUI(WidgetUI widgetUI) {
        Point point;
        if (widgetUI instanceof PileUI) {
            point = this.findLocationForPileUI((PileUI)widgetUI);
        } else {
            Card card = ((CardUI)widgetUI).getCard();
            Pile pile = card.getPile();
            if (pile == null) {
                point = this.findLocationForCardUI((CardUI)widgetUI, null, 0);
            } else {
                int n = pile.getCards().indexOf(card);
                point = this.findLocationForCardUI((CardUI)widgetUI, (PileUI)pile.getListener(), n);
            }
        }
        return point;
    }

    public int getAnims() {
        return this.ivAnims;
    }

    public Color getBackColor1() {
        return this.ivBackColor1;
    }

    public Color getBackColor2() {
        return this.ivBackColor2;
    }

    public int getBackColorOption() {
        return this.ivBackColorOption;
    }

    public String getBackImage() {
        return this.ivBackImage;
    }

    public int getBackImageOption() {
        return this.ivBackImageOption;
    }

    public String getCardBack() {
        return this.ivCardBack;
    }

    public String getCardSet() {
        return this.ivCardSet;
    }

    public int getColumns() {
        return this.ivColumns;
    }

    public Game getGame() {
        return this.ivGame;
    }

    public int getGrid() {
        return this.ivGrid;
    }

    public int getRows() {
        return this.ivRows;
    }

    public int getScale() {
        return this.ivScale;
    }

    public void initialize(int n, int n2, int n3) {
        this.ivGrid = n;
        this.ivColumns = n2;
        this.ivRows = n3;
        int n4 = 0;
        while (n4 < this.getComponentCount()) {
            if (this.getComponent(n4) instanceof WidgetUI) {
                ((WidgetUI)this.getComponent(n4)).setWidget(null);
            }
            ++n4;
        }
        this.removeAll();
        this.paintImmediately(0, 0, this.getWidth(), this.getHeight());
    }

    public boolean isPlayingVictory() {
        return this.ivPlayingVictory;
    }

    public void moveBegin(int n, int n2) {
        if (n2 == -1) {
            return;
        }
        switch (n) {
            case 0: {
                if (this.ivGame.getDecks() == 1) {
                    Tools.playSound("Setup52");
                    break;
                }
                Tools.playSound("Setup104");
                break;
            }
            case 1: {
                if (n2 == 1) {
                    Tools.playSound("Deal1");
                    break;
                }
                if (n2 < 4) {
                    Tools.playSound("Deal3");
                    break;
                }
                Tools.playSound("Deal9");
                break;
            }
            case 2: {
                if (n2 == 1) {
                    Tools.playSound("Deal1");
                    break;
                }
                if (n2 < 4) {
                    Tools.playSound("Deal3");
                    break;
                }
                Tools.playSound("Deal9");
                break;
            }
            case 7: {
                Tools.playSound("Fast");
                break;
            }
            case 3: {
                Tools.playSound("Fill");
                break;
            }
            case 4: {
                Tools.playSound("Drag");
                break;
            }
            case 5: {
                Tools.playSound("Undo");
                break;
            }
            case 6: {
                Tools.playSound("Abort");
                break;
            }
        }
    }

    protected void moveCards(List list, Pile pile, Pile pile2) {
        int n;
        PileUI pileUI = (PileUI)pile2.getListener();
        int n2 = pile2.getCards().size() - list.size();
        int n3 = list.size();
        int n4 = this.ivAnims;
        if (pile == null) {
            n4 = pile2 instanceof Stock ? 1 : 1;
        }
        CardUI cardUI = (CardUI)((Card)list.get(0)).getListener();
        Point point = this.findLocationForCardUI(cardUI, pileUI, n2);
        int n5 = Math.abs(point.x - cardUI.getX());
        int n6 = Math.abs(point.y - cardUI.getY());
        int n7 = Math.max(n5 / (cardUI.getWidth() / 2), 1);
        int n8 = Math.max(n6 / (cardUI.getHeight() / 2), 1);
        int n9 = Math.min(Math.max(n7, n8), n4);
        CardUI[] cardUIArray = new CardUI[n3];
        Point[][] pointArray = new Point[n3][n9 + 1];
        int n10 = 0;
        while (n10 < n3) {
            Point point2;
            CardUI cardUI2 = (CardUI)((Card)list.get(n10)).getListener();
            this.add((Component)cardUI2, 0);
            cardUIArray[n10] = cardUI2;
            pointArray[n10][0] = cardUI2.getLocation();
            pointArray[n10][n9] = point2 = this.findLocationForCardUI(cardUI2, pileUI, n2);
            int n11 = 1;
            while (n11 < n9) {
                int n12 = (point2.x - pointArray[n10][n11 - 1].x) / (n9 - n11 + 1);
                int n13 = (point2.y - pointArray[n10][n11 - 1].y) / (n9 - n11 + 1);
                pointArray[n10][n11] = new Point(pointArray[n10][n11 - 1].x + n12, pointArray[n10][n11 - 1].y + n13);
                ++n11;
            }
            ++n2;
            ++n10;
        }
        int n14 = 1;
        while (n14 < n9 + 1) {
            Rectangle rectangle = cardUIArray[0].getBounds().union(cardUIArray[n3 - 1].getBounds());
            n = 0;
            while (n < n3) {
                cardUIArray[n].setLocation(pointArray[n][n14]);
                ++n;
            }
            Rectangle rectangle2 = cardUIArray[0].getBounds().union(cardUIArray[n3 - 1].getBounds());
            if (rectangle.intersects(rectangle2)) {
                this.paintImmediately(rectangle.union(rectangle2));
            } else {
                this.paintImmediately(rectangle);
                this.paintImmediately(rectangle2);
            }
            if (pile == null && !(pile2 instanceof Stock)) {
                try {
                    Thread.currentThread();
                    Thread.sleep(20L);
                }
                catch (Exception exception) {}
            }
            ++n14;
        }
        if (pile != null && pile.getDragType() == 3) {
            n = 0;
            while (n < pile.getCards().size()) {
                CardUI cardUI3 = (CardUI)((Card)pile.getCards().get(n)).getListener();
                this.add((Component)cardUI3, 0);
                cardUI3.setLocation(this.findLocationForCardUI(cardUI3, (PileUI)pile.getListener(), n));
                ++n;
            }
        }
    }

    public void moveEnd(int n, int n2) {
        if (n2 == -1) {
            return;
        }
    }

    protected void paintComponent(Graphics graphics) {
        Paint paint;
        Graphics2D graphics2D = (Graphics2D)graphics;
        if (this.ivBackColorOption == 0) {
            graphics2D.setColor(this.ivBackColor1);
            graphics2D.fillRect(0, 0, this.getWidth(), this.getHeight());
        } else {
            paint = this.ivBackColorOption == 1 ? new GradientPaint(0.0f, this.getHeight() / 2, this.ivBackColor1, this.getWidth() - 1, this.getHeight() / 2, this.ivBackColor2, false) : new GradientPaint(this.getWidth() / 2, 0.0f, this.ivBackColor1, this.getWidth() / 2, this.getHeight() - 1, this.ivBackColor2, false);
            graphics2D.setPaint(paint);
            graphics2D.fillRect(0, 0, this.getWidth(), this.getHeight());
        }
        if (this.ivBufImage != null) {
            if (this.ivBackImageOption == 0) {
                graphics2D.drawImage((Image)this.ivBufImage, (this.getWidth() - this.ivBufImage.getWidth()) / 2, (this.getHeight() - this.ivBufImage.getHeight()) / 2, this);
            } else {
                paint = new TexturePaint(this.ivBufImage, new Rectangle2D.Double(0.0, 0.0, this.ivBufImage.getWidth(), this.ivBufImage.getHeight()));
                graphics2D.setPaint(paint);
                graphics2D.fillRect(0, 0, this.getWidth(), this.getHeight());
            }
        }
    }

    private void playVictory() {
        if (this.ivVictoryLabel.getText().equals(this.ivVictoryTitle)) {
            this.ivVictoryLabel.setVisible(this.ivVictoryLabel.isVisible() ^ true);
            this.ivVictoryLabelShadow.setVisible(this.ivVictoryLabel.isVisible());
        } else {
            this.ivVictoryLabel.setText(this.ivVictoryTitle.substring(0, this.ivVictoryLabel.getText().length() + 1));
            this.ivVictoryLabel.setSize(this.ivVictoryLabel.getPreferredSize());
            this.ivVictoryLabel.setLocation((this.getWidth() - this.ivVictoryLabel.getWidth()) / 2, (this.getHeight() - this.ivVictoryLabel.getHeight()) / 2);
            this.ivVictoryLabelShadow.setText(this.ivVictoryLabel.getText());
            this.ivVictoryLabelShadow.setSize(this.ivVictoryLabel.getSize());
            this.ivVictoryLabelShadow.setLocation(this.ivVictoryLabel.getLocation().x + 5, this.ivVictoryLabel.getLocation().y + 5);
        }
    }

    public void setAnims(int n) {
        if (n < 1) {
            n = 1;
        }
        this.ivAnims = n;
    }

    public void setBackColor1(Color color) {
        if (color == this.ivBackColor1) {
            return;
        }
        this.ivBackColor1 = color;
        this.repaint();
    }

    public void setBackColor2(Color color) {
        if (color == this.ivBackColor2) {
            return;
        }
        this.ivBackColor2 = color;
        this.repaint();
    }

    public void setBackColorOption(int n) {
        if (n == this.ivBackColorOption) {
            return;
        }
        this.ivBackColorOption = n;
        this.repaint();
    }

    public void setBackImage(String string) {
        if (string == this.ivBackImage) {
            return;
        }
        this.ivBackImage = string;
        if (string.equals("NULL")) {
            this.ivBufImage = null;
        } else {
            ImageIcon imageIcon = new ImageIcon(string);
            if (imageIcon.getImage() == null) {
                this.ivBufImage = null;
            } else {
                this.ivBufImage = new BufferedImage(imageIcon.getIconWidth(), imageIcon.getIconHeight(), 2);
                Graphics graphics = this.ivBufImage.getGraphics();
                graphics.drawImage(imageIcon.getImage(), 0, 0, null);
            }
        }
        this.repaint();
    }

    public void setBackImageOption(int n) {
        if (n == this.ivBackImageOption) {
            return;
        }
        this.ivBackImageOption = n;
        this.repaint();
    }

    public void setCardBack(String string) {
        if (string == this.ivCardBack) {
            return;
        }
        this.ivCardBack = string;
        if (this.ivScale == 0) {
            return;
        }
        Tools.loadImagesBack(string, this.ivScale);
        CardUI.setBackImage(Tools.getBackImage());
        this.repaint();
    }

    public void setCardSet(String string) {
        if (string == this.ivCardSet) {
            return;
        }
        this.ivCardSet = string;
        if (this.ivScale == 0) {
            return;
        }
        Tools.loadImagesSet(string, this.ivScale);
        int n = 0;
        while (n < this.getComponentCount()) {
            if (this.getComponent(n) instanceof CardUI) {
                this.updateWidgetUI((CardUI)this.getComponent(n));
            }
            ++n;
        }
        this.repaint();
    }

    public void setGrid(int n) {
        if (n == this.ivGrid) {
            return;
        }
        if (n < 0) {
            n = 0;
        }
        if (n > 2) {
            n = 2;
        }
        this.ivGrid = n;
    }

    public void setPlayingVictory(boolean bl) {
        if (this.ivPlayingVictory == bl) {
            return;
        }
        this.ivPlayingVictory = bl;
        if (this.ivPlayingVictory) {
            Tools.startSoundLoop("Victory");
            this.ivVictoryTitle = new String(Tools.translate("Various-Victory" + new Random().nextInt(3)));
            this.ivVictoryLabelShadow = new JLabel("");
            this.ivVictoryLabelShadow.setFont(new Font("dialog.bold", 1, 56 + this.ivScale * 16));
            this.ivVictoryLabelShadow.setForeground(Color.black);
            this.add((Component)this.ivVictoryLabelShadow, 0);
            this.ivVictoryLabel = new JLabel("");
            this.ivVictoryLabel.setFont(new Font("dialog.bold", 1, 56 + this.ivScale * 16));
            this.ivVictoryLabel.setForeground(Color.orange);
            this.add((Component)this.ivVictoryLabel, 0);
            this.ivVictoryTimer.start();
        } else {
            Tools.stopSoundLoop("Victory");
            this.remove(this.ivVictoryLabel);
            this.remove(this.ivVictoryLabelShadow);
            this.repaint();
        }
    }

    public void setScale(int n) {
        if (n == this.ivScale) {
            return;
        }
        if (n < 1) {
            n = 1;
        }
        if (n > 3) {
            n = 3;
        }
        this.ivScale = n;
        Tools.loadImages(this.ivCardSet, this.ivCardBack, this.ivScale);
        CardUI.setBackImage(Tools.getBackImage());
        WidgetUI.setDragOverImage(Tools.getDragOverImage());
        int n2 = 0;
        while (n2 < this.getComponentCount()) {
            if (this.getComponent(n2) instanceof PileUI) {
                this.updateWidgetUI((WidgetUI)this.getComponent(n2));
            }
            ++n2;
        }
        int n3 = 0;
        while (n3 < this.getComponentCount()) {
            if (this.getComponent(n3) instanceof CardUI) {
                this.updateWidgetUI((WidgetUI)this.getComponent(n3));
            }
            ++n3;
        }
    }

    private void updateCardUI(CardUI cardUI) {
        Card card = cardUI.getCard();
        if (card == null) {
            return;
        }
        cardUI.setImage(Tools.getCardImage(card.getFamily(), card.getRank()));
    }

    private void updatePileUI(PileUI pileUI) {
        Pile pile = pileUI.getPile();
        if (pile == null) {
            return;
        }
        if (pileUI.getPile() instanceof Stock) {
            pileUI.setImage(Tools.getStockImage());
            pileUI.setInactiveImage(Tools.getStockInactiveImage());
        } else if (pileUI.getPile() instanceof Foundation) {
            pileUI.setImage(Tools.getFoundationImage());
            pileUI.setInactiveImage(Tools.getFoundationInactiveImage());
        } else {
            pileUI.setImage(Tools.getPileImage());
            pileUI.setInactiveImage(Tools.getPileInactiveImage());
            if (pileUI.getPile().getStackType() == 0 && pileUI.getPile().getFill() == 0) {
                pileUI.setVisible(false);
            }
        }
    }

    private void updateWidgetUI(WidgetUI widgetUI) {
        switch (this.ivScale) {
            case 1: {
                widgetUI.setSize(57, 81);
                break;
            }
            case 2: {
                widgetUI.setSize(71, 101);
                break;
            }
            case 3: {
                widgetUI.setSize(89, 125);
                break;
            }
        }
        if (widgetUI instanceof PileUI) {
            this.updatePileUI((PileUI)widgetUI);
        } else {
            this.updateCardUI((CardUI)widgetUI);
        }
        widgetUI.setLocation(this.findLocationForWidgetUI(widgetUI));
    }
}

