/*
 * Decompiled with CFR 0.152.
 */
package kgd.card.player.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.Document;
import kgd.card.player.gui.DlgMessage;
import kgd.card.player.gui.Tools;

public class FrmHelp
extends JFrame {
    private JEditorPane ivPanHelp = null;
    private JButton ivBttBack;
    private JButton ivBttNext;
    private JButton ivBttHome;
    private List ivBackURLs = new ArrayList();
    private URL ivCurrURL = null;
    private List ivNextURLs = new ArrayList();

    public FrmHelp() {
        this.initialize();
    }

    private void backPage() {
        URL uRL = (URL)this.ivBackURLs.remove(this.ivBackURLs.size() - 1);
        this.loadPage(uRL, -1);
    }

    private void eventButtonClicked(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.ivBttBack) {
            this.backPage();
        }
        if (actionEvent.getSource() == this.ivBttNext) {
            this.nextPage();
        }
        if (actionEvent.getSource() == this.ivBttHome) {
            this.showPage("Index.htm");
        }
    }

    private void handleException(Throwable throwable) {
        System.out.println("--------- UNCAUGHT EXCEPTION ---------");
        throwable.printStackTrace(System.out);
    }

    private void initialize() {
        this.setTitle(Tools.translate("Help-Title"));
        this.setName("FrmHelp");
        ((Frame)this).setIconImage(Tools.getProgramIconImage());
        ((Component)this).setBounds(0, 0, 640, 480);
        this.getContentPane().setLayout(new BorderLayout());
        this.initializePane();
        this.initializeToolbar();
        this.setDefaultCloseOperation(1);
    }

    private void initializePane() {
        this.ivPanHelp = new JEditorPane();
        this.ivPanHelp.setName("PanHelp");
        this.ivPanHelp.setEditable(false);
        this.ivPanHelp.addHyperlinkListener(new HyperlinkListener(){

            public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
                FrmHelp.this.updateLink(hyperlinkEvent);
            }
        });
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.setName("ScrollHelp");
        jScrollPane.setViewportView(this.ivPanHelp);
        this.getContentPane().add((Component)jScrollPane, "Center");
    }

    private void initializeToolbar() {
        JPanel jPanel = new JPanel(new FlowLayout(0, 4, 2), false);
        jPanel.setPreferredSize(new Dimension(0, 27));
        this.getContentPane().add((Component)jPanel, "North");
        this.ivBttBack = new JButton();
        this.ivBttBack.setPreferredSize(new Dimension(46, 23));
        this.ivBttBack.setIcon(Tools.getIcon("HelpBack.gif"));
        this.ivBttBack.setToolTipText(Tools.translate("Help-Previous"));
        this.ivBttBack.setFocusPainted(false);
        this.ivBttBack.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FrmHelp.this.eventButtonClicked(actionEvent);
            }
        });
        jPanel.add(this.ivBttBack);
        this.ivBttNext = new JButton();
        this.ivBttNext.setPreferredSize(new Dimension(46, 23));
        this.ivBttNext.setIcon(Tools.getIcon("HelpNext.gif"));
        this.ivBttNext.setToolTipText(Tools.translate("Help-Next"));
        this.ivBttNext.setFocusPainted(false);
        this.ivBttNext.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FrmHelp.this.eventButtonClicked(actionEvent);
            }
        });
        jPanel.add(this.ivBttNext);
        JLabel jLabel = new JLabel();
        jLabel.setPreferredSize(new Dimension(46, 23));
        jPanel.add(jLabel);
        this.ivBttHome = new JButton();
        this.ivBttHome.setPreferredSize(new Dimension(46, 23));
        this.ivBttHome.setIcon(Tools.getIcon("HelpHome.gif"));
        this.ivBttHome.setToolTipText(Tools.translate("Help-Home"));
        this.ivBttHome.setFocusPainted(false);
        this.ivBttHome.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FrmHelp.this.eventButtonClicked(actionEvent);
            }
        });
        jPanel.add(this.ivBttHome);
    }

    private void loadPage(URL uRL, int n) {
        if (uRL == null) {
            return;
        }
        if (this.ivCurrURL != null && uRL.equals(this.ivCurrURL)) {
            return;
        }
        this.ivPanHelp.setCursor(Cursor.getPredefinedCursor(3));
        String string = uRL.getProtocol();
        Document document = this.ivPanHelp.getDocument();
        if (string.equals("file")) {
            try {
                try {
                    this.ivPanHelp.setPage(uRL);
                    if (n == -1) {
                        this.ivNextURLs.add(this.ivCurrURL);
                    } else if (n == 1) {
                        this.ivBackURLs.add(this.ivCurrURL);
                    } else if (n == -9) {
                        this.ivBackURLs.clear();
                        this.ivNextURLs.clear();
                    } else {
                        if (this.ivCurrURL != null) {
                            this.ivBackURLs.add(this.ivCurrURL);
                        }
                        this.ivNextURLs.clear();
                    }
                    this.ivCurrURL = uRL;
                    this.ivBttBack.setEnabled(this.ivBackURLs.isEmpty() ^ true);
                    this.ivBttNext.setEnabled(this.ivNextURLs.isEmpty() ^ true);
                }
                catch (Exception exception) {
                    this.ivPanHelp.setDocument(document);
                    this.handleException(exception);
                }
                Object var6_7 = null;
                this.ivPanHelp.setCursor(Cursor.getPredefinedCursor(0));
            }
            catch (Throwable throwable) {
                Object var6_8 = null;
                this.ivPanHelp.setCursor(Cursor.getPredefinedCursor(0));
                throw throwable;
            }
        }
        if (string.equals("http")) {
            if (Tools.getBrowser() != null) {
                try {
                    try {
                        Runtime.getRuntime().exec(String.valueOf(Tools.getBrowser()) + " " + uRL.toString());
                    }
                    catch (Exception exception) {
                        this.handleException(exception);
                    }
                    Object var6_9 = null;
                    this.ivPanHelp.setCursor(Cursor.getPredefinedCursor(0));
                }
                catch (Throwable throwable) {
                    Object var6_10 = null;
                    this.ivPanHelp.setCursor(Cursor.getPredefinedCursor(0));
                    throw throwable;
                }
            }
            this.ivPanHelp.setCursor(Cursor.getPredefinedCursor(0));
            DlgMessage.display(this, 1, Tools.translate("Various-ErrorBrowser"));
        } else {
            string.equals("mailto");
        }
    }

    public static void main(String[] stringArray) {
        try {
            FrmHelp frmHelp = new FrmHelp();
            frmHelp.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent windowEvent) {
                    System.exit(0);
                }
            });
            frmHelp.showPage("Index.htm");
            ((Component)frmHelp).setVisible(true);
        }
        catch (Throwable throwable) {
            System.err.println("Exception occurred in main() of javax.swing.JFrame");
            throwable.printStackTrace(System.out);
        }
    }

    private void nextPage() {
        URL uRL = (URL)this.ivNextURLs.remove(this.ivNextURLs.size() - 1);
        this.loadPage(uRL, 1);
    }

    public void showPage(String string) {
        URL uRL = null;
        try {
            uRL = new URL("file:" + Tools.DIR_DOC + string);
        }
        catch (Exception exception) {
            this.handleException(exception);
        }
        this.loadPage(uRL, -9);
        this.toFront();
        if (!this.isVisible()) {
            ((Component)this).setVisible(true);
        }
    }

    private void updateLink(HyperlinkEvent hyperlinkEvent) {
        HyperlinkEvent.EventType eventType = hyperlinkEvent.getEventType();
        hyperlinkEvent.getEventType();
        if (eventType != HyperlinkEvent.EventType.ACTIVATED) {
            return;
        }
        this.loadPage(hyperlinkEvent.getURL(), 0);
    }
}

