/*
 * Decompiled with CFR 0.152.
 */
package kgd.card.player.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.border.EtchedBorder;
import kgd.card.player.data.Score;
import kgd.card.player.gui.FrmMain;
import kgd.card.player.gui.GameScore;
import kgd.card.player.gui.Stat;
import kgd.card.player.gui.Tools;

public final class DlgScore
extends JDialog {
    private JLabel ivLblTitle;
    private JLabel ivLblRank;
    private JLabel ivLblPlayer;
    private JLabel ivLblScore;
    private JLabel ivLblTime;
    private JLabel[] ivLblRanks = new JLabel[10];
    private JLabel[] ivLblPlayers = new JLabel[10];
    private JLabel[] ivLblScores = new JLabel[10];
    private JLabel[] ivLblTimes = new JLabel[10];
    private JLabel ivLblWon;
    private JLabel ivLblLost;
    private JLabel ivLblLevel;
    private JButton ivBttContinue;
    private GameScore ivGameScore;
    private int ivHighlightedScore;
    private Stat ivStat;

    public DlgScore() {
        this.initialize();
    }

    public DlgScore(Dialog dialog, GameScore gameScore, int n, Stat stat) {
        super(dialog, true);
        this.ivGameScore = gameScore;
        this.ivHighlightedScore = n;
        this.ivStat = stat;
        this.initialize();
    }

    public DlgScore(Frame frame, GameScore gameScore, int n, Stat stat) {
        super(frame, true);
        this.ivGameScore = gameScore;
        this.ivHighlightedScore = n;
        this.ivStat = stat;
        this.initialize();
    }

    private void eventButtonClicked(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.ivBttContinue) {
            this.dispose();
        }
    }

    private void initialize() {
        this.setTitle(Tools.translate("Score-Title"));
        this.setName("DlgScore");
        this.getContentPane().setLayout(new FlowLayout(1, 4, 4));
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                DlgScore.this.dispose();
            }
        });
        this.initializeComponents();
        this.initializeValues();
        int n = 348 + FrmMain.getFrameInsetsDimension().width;
        int n2 = 412 + FrmMain.getFrameInsetsDimension().height;
        int n3 = (Toolkit.getDefaultToolkit().getScreenSize().width - n) / 2;
        int n4 = (Toolkit.getDefaultToolkit().getScreenSize().height - n2) / 2;
        if (this.getParent() != null) {
            n3 = this.getParent().getX() + (this.getParent().getWidth() - n) / 2;
            n4 = this.getParent().getY() + (this.getParent().getHeight() - n2) / 2;
        }
        ((Component)this).setBounds(n3, n4, n, n2);
        ((Component)this).setVisible(true);
    }

    private void initializeComponents() {
        this.ivLblTitle = new JLabel();
        this.ivLblTitle.setPreferredSize(new Dimension(340, 70));
        this.ivLblTitle.setFont(new Font("dialog.bold", 1, 20));
        this.ivLblTitle.setForeground(Color.black);
        this.ivLblTitle.setHorizontalAlignment(0);
        this.ivLblTitle.setHorizontalTextPosition(0);
        this.ivLblTitle.setVerticalAlignment(0);
        this.ivLblTitle.setVerticalTextPosition(0);
        this.ivLblTitle.setIcon(Tools.getIcon("DlgScoreIcon.gif"));
        this.getContentPane().add(this.ivLblTitle);
        JPanel jPanel = new JPanel(new FlowLayout(1, 0, 0), false);
        jPanel.setPreferredSize(new Dimension(340, 226));
        jPanel.setBorder(new EtchedBorder());
        this.getContentPane().add(jPanel);
        this.ivLblRank = new JLabel();
        this.ivLblRank.setPreferredSize(new Dimension(60, 20));
        this.ivLblRank.setFont(new Font("dialog.bold", 1, 14));
        this.ivLblRank.setHorizontalAlignment(2);
        this.ivLblRank.setText(Tools.translate("Score-Rank"));
        jPanel.add(this.ivLblRank);
        this.ivLblPlayer = new JLabel();
        this.ivLblPlayer.setPreferredSize(new Dimension(144, 20));
        this.ivLblPlayer.setFont(new Font("dialog.bold", 1, 14));
        this.ivLblPlayer.setHorizontalAlignment(2);
        this.ivLblPlayer.setText(Tools.translate("Score-Player"));
        jPanel.add(this.ivLblPlayer);
        this.ivLblScore = new JLabel();
        this.ivLblScore.setPreferredSize(new Dimension(60, 20));
        this.ivLblScore.setFont(new Font("dialog.bold", 1, 14));
        this.ivLblScore.setHorizontalAlignment(4);
        this.ivLblScore.setText(Tools.translate("Score-Score"));
        jPanel.add(this.ivLblScore);
        this.ivLblTime = new JLabel();
        this.ivLblTime.setPreferredSize(new Dimension(60, 20));
        this.ivLblTime.setFont(new Font("dialog.bold", 1, 14));
        this.ivLblTime.setHorizontalAlignment(4);
        this.ivLblTime.setText(Tools.translate("Score-Time"));
        jPanel.add(this.ivLblTime);
        JSeparator jSeparator = new JSeparator();
        jSeparator.setOrientation(0);
        jSeparator.setPreferredSize(new Dimension(324, 2));
        jPanel.add(jSeparator);
        this.ivLblRanks[0] = new JLabel();
        this.ivLblRanks[0].setPreferredSize(new Dimension(60, 20));
        this.ivLblRanks[0].setFont(new Font("dialog.bold", 1, 12));
        this.ivLblRanks[0].setHorizontalAlignment(0);
        this.ivLblRanks[0].setForeground(Color.red);
        jPanel.add(this.ivLblRanks[0]);
        this.ivLblPlayers[0] = new JLabel();
        this.ivLblPlayers[0].setPreferredSize(new Dimension(144, 20));
        this.ivLblPlayers[0].setFont(new Font("dialog.bold", 1, 12));
        this.ivLblPlayers[0].setHorizontalAlignment(2);
        this.ivLblPlayers[0].setForeground(Color.red);
        jPanel.add(this.ivLblPlayers[0]);
        this.ivLblScores[0] = new JLabel();
        this.ivLblScores[0].setPreferredSize(new Dimension(60, 20));
        this.ivLblScores[0].setFont(new Font("dialog.bold", 1, 12));
        this.ivLblScores[0].setHorizontalAlignment(4);
        this.ivLblScores[0].setForeground(Color.red);
        jPanel.add(this.ivLblScores[0]);
        this.ivLblTimes[0] = new JLabel();
        this.ivLblTimes[0].setPreferredSize(new Dimension(60, 20));
        this.ivLblTimes[0].setFont(new Font("dialog.bold", 1, 12));
        this.ivLblTimes[0].setHorizontalAlignment(4);
        this.ivLblTimes[0].setForeground(Color.red);
        jPanel.add(this.ivLblTimes[0]);
        int n = 1;
        while (n < 10) {
            this.ivLblRanks[n] = new JLabel();
            this.ivLblRanks[n].setPreferredSize(new Dimension(60, 20));
            this.ivLblRanks[n].setFont(new Font("dialog.bold", 1, 12));
            this.ivLblRanks[n].setHorizontalAlignment(0);
            jPanel.add(this.ivLblRanks[n]);
            this.ivLblPlayers[n] = new JLabel();
            this.ivLblPlayers[n].setPreferredSize(new Dimension(144, 20));
            this.ivLblPlayers[n].setFont(new Font("dialog.bold", 1, 12));
            this.ivLblPlayers[n].setHorizontalAlignment(2);
            jPanel.add(this.ivLblPlayers[n]);
            this.ivLblScores[n] = new JLabel();
            this.ivLblScores[n].setPreferredSize(new Dimension(60, 20));
            this.ivLblScores[n].setFont(new Font("dialog.bold", 1, 12));
            this.ivLblScores[n].setHorizontalAlignment(4);
            jPanel.add(this.ivLblScores[n]);
            this.ivLblTimes[n] = new JLabel();
            this.ivLblTimes[n].setPreferredSize(new Dimension(60, 20));
            this.ivLblTimes[n].setFont(new Font("dialog.bold", 1, 12));
            this.ivLblTimes[n].setHorizontalAlignment(4);
            jPanel.add(this.ivLblTimes[n]);
            ++n;
        }
        JPanel jPanel2 = new JPanel(new FlowLayout(1, 0, 0), false);
        jPanel2.setPreferredSize(new Dimension(340, 64));
        jPanel2.setBorder(new EtchedBorder());
        this.getContentPane().add(jPanel2);
        this.ivLblWon = new JLabel();
        this.ivLblWon.setPreferredSize(new Dimension(324, 20));
        this.ivLblWon.setFont(new Font("dialog.bold", 1, 12));
        this.ivLblWon.setHorizontalAlignment(0);
        jPanel2.add(this.ivLblWon);
        this.ivLblLost = new JLabel();
        this.ivLblLost.setPreferredSize(new Dimension(324, 20));
        this.ivLblLost.setFont(new Font("dialog.bold", 1, 12));
        this.ivLblLost.setHorizontalAlignment(0);
        jPanel2.add(this.ivLblLost);
        this.ivLblLevel = new JLabel();
        this.ivLblLevel.setPreferredSize(new Dimension(324, 20));
        this.ivLblLevel.setFont(new Font("dialog.bold", 1, 12));
        this.ivLblLevel.setHorizontalAlignment(0);
        jPanel2.add(this.ivLblLevel);
        this.ivBttContinue = new JButton();
        this.ivBttContinue.setPreferredSize(new Dimension(340, 32));
        this.ivBttContinue.setIcon(Tools.getIcon("OK.gif"));
        this.ivBttContinue.setRolloverIcon(Tools.getIcon("OKSelected.gif"));
        this.ivBttContinue.setPressedIcon(Tools.getIcon("OKSelected.gif"));
        this.ivBttContinue.setToolTipText(Tools.translate("Score-OK"));
        this.ivBttContinue.setFocusPainted(false);
        this.ivBttContinue.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DlgScore.this.eventButtonClicked(actionEvent);
            }
        });
        this.getContentPane().add(this.ivBttContinue);
    }

    private void initializeValues() {
        this.ivLblTitle.setText(this.ivGameScore.getGame());
        int n = 0;
        while (n < this.ivGameScore.getScores().size()) {
            Score score = (Score)this.ivGameScore.getScores().get(n);
            this.ivLblRanks[n].setText(String.valueOf(n + 1));
            this.ivLblPlayers[n].setText(score.getPlayer());
            this.ivLblScores[n].setText(String.valueOf(score.getTotal()));
            this.ivLblTimes[n].setText(String.valueOf(score.getTime()));
            ++n;
        }
        if (this.ivHighlightedScore > -1) {
            this.ivLblRanks[this.ivHighlightedScore].setBackground(Color.white);
            this.ivLblPlayers[this.ivHighlightedScore].setBackground(Color.white);
            this.ivLblScores[this.ivHighlightedScore].setBackground(Color.white);
            this.ivLblTimes[this.ivHighlightedScore].setBackground(Color.white);
            this.ivLblRanks[this.ivHighlightedScore].setOpaque(true);
            this.ivLblPlayers[this.ivHighlightedScore].setOpaque(true);
            this.ivLblScores[this.ivHighlightedScore].setOpaque(true);
            this.ivLblTimes[this.ivHighlightedScore].setOpaque(true);
        }
        this.ivLblWon.setText(String.valueOf(Tools.translate("Score-Stat1")) + " " + this.ivStat.getWon() + "      ...      " + Tools.translate("Score-Stat2") + " " + this.ivStat.getAverageWonScore());
        this.ivLblLost.setText(String.valueOf(Tools.translate("Score-Stat3")) + " " + this.ivStat.getLost() + "      ...      " + Tools.translate("Score-Stat4") + " " + this.ivStat.getAverageLostScore());
        this.ivLblLevel.setText(String.valueOf(Tools.translate("Score-Stat5")) + " " + this.ivStat.getSuccessRate() + " %");
    }

    private void initializeValuesBis() {
        this.ivLblTitle.setText("Klondike");
        int n = 0;
        while (n < 10) {
            this.ivLblRanks[n].setText(String.valueOf(n + 1));
            this.ivLblPlayers[n].setText("Jean-Christophe" + n);
            this.ivLblScores[n].setText(String.valueOf(n * 1000));
            this.ivLblTimes[n].setText(String.valueOf(n * 100));
            ++n;
        }
        this.ivLblRanks[3].setBackground(Color.white);
        this.ivLblPlayers[3].setBackground(Color.white);
        this.ivLblScores[3].setBackground(Color.white);
        this.ivLblTimes[3].setBackground(Color.white);
        this.ivLblRanks[3].setOpaque(true);
        this.ivLblPlayers[3].setOpaque(true);
        this.ivLblScores[3].setOpaque(true);
        this.ivLblTimes[3].setOpaque(true);
        System.out.println(this);
    }

    public static void main(String[] stringArray) {
        try {
            DlgScore dlgScore = new DlgScore();
            dlgScore.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent windowEvent) {
                    System.exit(0);
                }
            });
            ((Component)dlgScore).setVisible(true);
        }
        catch (Throwable throwable) {
            System.err.println("Exception occurred in main() of javax.swing.JFrame");
            throwable.printStackTrace(System.out);
        }
    }
}

