/*
 * Decompiled with CFR 0.152.
 */
package kgd.card.player.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.Serializable;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.border.EtchedBorder;
import javax.swing.border.LineBorder;
import javax.swing.border.TitledBorder;
import kgd.card.player.bean.KImageFilter;
import kgd.card.player.gui.Config;
import kgd.card.player.gui.DlgHelp;
import kgd.card.player.gui.FrmMain;
import kgd.card.player.gui.Tools;

public final class DlgConfig
extends JDialog {
    private JTabbedPane ivTabPane;
    private JCheckBox ivChkAutoEnd;
    private JCheckBox ivChkSounds;
    private JSlider ivSldAnims;
    private JSlider ivSldAITime;
    private JTextField ivTxtBrowser;
    private JButton ivBttBrowserBrowse;
    private JRadioButton ivRadBackColorOption0;
    private JRadioButton ivRadBackColorOption1;
    private JRadioButton ivRadBackColorOption2;
    private JButton ivBttBackColor1;
    private JButton ivBttBackColor2;
    private JRadioButton ivRadBackImageOption0;
    private JRadioButton ivRadBackImageOption1;
    private JTextField ivTxtBackImage;
    private JButton ivBttBackImageBrowse;
    private JButton ivBttBackImageCancel;
    private JRadioButton ivRadScale1;
    private JRadioButton ivRadScale2;
    private JRadioButton ivRadScale3;
    private JLabel ivLblCardback;
    private JLabel[] ivLblCardbacks;
    private JLabel ivLblCardset;
    private JLabel[] ivLblCardsets;
    private JButton ivBttCancel;
    private JButton ivBttHelp;
    private JButton ivBttOK;
    private Config ivConfig;

    public DlgConfig() {
        this.initialize();
    }

    public DlgConfig(Frame frame, Config config) {
        super(frame, true);
        this.ivConfig = config;
        this.initialize();
    }

    private void eventButtonClicked(ActionEvent actionEvent) {
        Serializable serializable;
        if (actionEvent.getSource() == this.ivBttOK) {
            this.exit(0);
        }
        if (actionEvent.getSource() == this.ivBttHelp) {
            serializable = new DlgHelp(this);
            ((DlgHelp)serializable).showPage("Config.htm");
        }
        if (actionEvent.getSource() == this.ivBttCancel) {
            this.exit(-1);
        }
        if (actionEvent.getSource() == this.ivBttBackColor1 && (serializable = JColorChooser.showDialog(this, Tools.translate("Config-Color1"), this.ivBttBackColor1.getBackground())) != null) {
            this.ivBttBackColor1.setBackground((Color)serializable);
        }
        if (actionEvent.getSource() == this.ivBttBackColor2 && (serializable = JColorChooser.showDialog(this, Tools.translate("Config-Color2"), this.ivBttBackColor2.getBackground())) != null) {
            this.ivBttBackColor2.setBackground((Color)serializable);
        }
        if (actionEvent.getSource() == this.ivBttBackImageBrowse) {
            serializable = new JFileChooser();
            ((JFileChooser)serializable).setDialogTitle(Tools.translate("Config-BackImage"));
            ((JFileChooser)serializable).setCurrentDirectory(new File(Tools.DIR_USER));
            KImageFilter kImageFilter = new KImageFilter();
            ((JFileChooser)serializable).setFileFilter(kImageFilter);
            int n = ((JFileChooser)serializable).showOpenDialog(this);
            if (n == 0) {
                this.ivTxtBackImage.setText(((JFileChooser)serializable).getSelectedFile().getAbsolutePath());
            }
        }
        if (actionEvent.getSource() == this.ivBttBackImageCancel) {
            this.ivTxtBackImage.setText("NULL");
        }
        if (actionEvent.getSource() == this.ivBttBrowserBrowse) {
            serializable = new JFileChooser();
            ((JFileChooser)serializable).setDialogTitle(Tools.translate("Config-BrowserBrowse"));
            ((JFileChooser)serializable).setCurrentDirectory(new File(Tools.DIR_HOME));
            int n = ((JFileChooser)serializable).showOpenDialog(this);
            if (n == 0) {
                this.ivTxtBrowser.setText(((JFileChooser)serializable).getSelectedFile().getAbsolutePath());
            }
        }
    }

    private void eventLabelMouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getClickCount() == 2) {
            JLabel jLabel = (JLabel)mouseEvent.getSource();
            if (jLabel.getName().equals("Cardbacks")) {
                this.ivLblCardback.setIcon(jLabel.getIcon());
            }
            if (jLabel.getName().equals("Cardsets")) {
                this.ivLblCardset.setIcon(jLabel.getIcon());
            }
        }
    }

    private void exit(int n) {
        if (n != -1) {
            if (this.ivTxtBrowser.getText().equals("")) {
                this.ivTxtBrowser.setText("NULL");
            }
            if (this.ivTxtBackImage.getText().equals("")) {
                this.ivTxtBackImage.setText("NULL");
            }
            this.ivConfig.setAutoEndGame(this.ivChkAutoEnd.isSelected());
            this.ivConfig.setSounds(this.ivChkSounds.isSelected());
            this.ivConfig.setAnims(this.ivSldAnims.getValue());
            this.ivConfig.setAITime(this.ivSldAITime.getValue());
            this.ivConfig.setBrowser(this.ivTxtBrowser.getText());
            if (this.ivRadBackColorOption0.isSelected()) {
                this.ivConfig.setBackColorOption(0);
            }
            if (this.ivRadBackColorOption1.isSelected()) {
                this.ivConfig.setBackColorOption(1);
            }
            if (this.ivRadBackColorOption2.isSelected()) {
                this.ivConfig.setBackColorOption(2);
            }
            this.ivConfig.setBackColor1(this.ivBttBackColor1.getBackground());
            this.ivConfig.setBackColor2(this.ivBttBackColor2.getBackground());
            if (this.ivRadBackImageOption0.isSelected()) {
                this.ivConfig.setBackImageOption(0);
            }
            if (this.ivRadBackImageOption1.isSelected()) {
                this.ivConfig.setBackImageOption(1);
            }
            this.ivConfig.setBackImage(this.ivTxtBackImage.getText());
            this.ivConfig.setCardBack(((ImageIcon)this.ivLblCardback.getIcon()).getDescription());
            this.ivConfig.setCardSet(((ImageIcon)this.ivLblCardset.getIcon()).getDescription());
            if (this.ivRadScale1.isSelected()) {
                this.ivConfig.setScale(1);
            }
            if (this.ivRadScale2.isSelected()) {
                this.ivConfig.setScale(2);
            }
            if (this.ivRadScale3.isSelected()) {
                this.ivConfig.setScale(3);
            }
        }
        this.dispose();
    }

    public Config getConfig() {
        return this.ivConfig;
    }

    private void initialize() {
        this.setTitle(Tools.translate("Config-Title"));
        this.setName("DlgConfig");
        this.getContentPane().setLayout(new FlowLayout(1, 4, 4));
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                DlgConfig.this.exit(-1);
            }
        });
        this.ivTabPane = new JTabbedPane();
        this.getContentPane().add(this.ivTabPane);
        this.initializeGeneral();
        this.initializeBoard();
        this.initializeCard();
        this.initializeToolbar();
        this.initializeValues();
        int n = 565 + FrmMain.getFrameInsetsDimension().width;
        int n2 = 286 + FrmMain.getFrameInsetsDimension().height;
        int n3 = (Toolkit.getDefaultToolkit().getScreenSize().width - n) / 2;
        int n4 = (Toolkit.getDefaultToolkit().getScreenSize().height - n2) / 2;
        if (this.getParent() != null) {
            n3 = this.getParent().getX() + (this.getParent().getWidth() - n) / 2;
            n4 = this.getParent().getY() + (this.getParent().getHeight() - n2) / 2;
        }
        ((Component)this).setBounds(n3, n4, n, n2);
        ((Component)this).setVisible(true);
    }

    private void initializeBoard() {
        JPanel jPanel = new JPanel(new FlowLayout(0, 4, 4), false);
        jPanel.setPreferredSize(new Dimension(552, 187));
        JPanel jPanel2 = new JPanel(new FlowLayout(0, 0, 0), false);
        jPanel2.setPreferredSize(new Dimension(544, 99));
        jPanel2.setBorder(new TitledBorder(Tools.translate("Config-Colors")));
        jPanel.add(jPanel2);
        JPanel jPanel3 = new JPanel(new FlowLayout(0, 4, 4), false);
        jPanel3.setPreferredSize(new Dimension(200, 73));
        jPanel2.add(jPanel3);
        ButtonGroup buttonGroup = new ButtonGroup();
        this.ivRadBackColorOption0 = new JRadioButton(Tools.translate("Config-Gradient0"));
        this.ivRadBackColorOption0.setPreferredSize(new Dimension(192, 19));
        this.ivRadBackColorOption0.setFocusPainted(false);
        buttonGroup.add(this.ivRadBackColorOption0);
        jPanel3.add(this.ivRadBackColorOption0);
        this.ivRadBackColorOption1 = new JRadioButton(Tools.translate("Config-Gradient1"));
        this.ivRadBackColorOption1.setPreferredSize(new Dimension(192, 19));
        this.ivRadBackColorOption1.setFocusPainted(false);
        buttonGroup.add(this.ivRadBackColorOption1);
        jPanel3.add(this.ivRadBackColorOption1);
        this.ivRadBackColorOption2 = new JRadioButton(Tools.translate("Config-Gradient2"));
        this.ivRadBackColorOption2.setPreferredSize(new Dimension(192, 19));
        this.ivRadBackColorOption2.setFocusPainted(false);
        buttonGroup.add(this.ivRadBackColorOption2);
        jPanel3.add(this.ivRadBackColorOption2);
        JPanel jPanel4 = new JPanel(new FlowLayout(0, 4, 4), false);
        jPanel4.setPreferredSize(new Dimension(334, 73));
        jPanel2.add(jPanel4);
        this.ivBttBackColor1 = new JButton(Tools.translate("Config-Color1"));
        this.ivBttBackColor1.setPreferredSize(new Dimension(326, 30));
        this.ivBttBackColor1.setFocusPainted(false);
        this.ivBttBackColor1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DlgConfig.this.eventButtonClicked(actionEvent);
            }
        });
        jPanel4.add(this.ivBttBackColor1);
        this.ivBttBackColor2 = new JButton(Tools.translate("Config-Color2"));
        this.ivBttBackColor2.setPreferredSize(new Dimension(326, 30));
        this.ivBttBackColor2.setFocusPainted(false);
        this.ivBttBackColor2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DlgConfig.this.eventButtonClicked(actionEvent);
            }
        });
        jPanel4.add(this.ivBttBackColor2);
        JPanel jPanel5 = new JPanel(new FlowLayout(0, 0, 0), false);
        jPanel5.setPreferredSize(new Dimension(544, 76));
        jPanel5.setBorder(new TitledBorder(Tools.translate("Config-Images")));
        jPanel.add(jPanel5);
        JPanel jPanel6 = new JPanel(new FlowLayout(0, 4, 4), false);
        jPanel6.setPreferredSize(new Dimension(200, 50));
        jPanel5.add(jPanel6);
        ButtonGroup buttonGroup2 = new ButtonGroup();
        this.ivRadBackImageOption0 = new JRadioButton(Tools.translate("Config-Image0"));
        this.ivRadBackImageOption0.setPreferredSize(new Dimension(192, 19));
        this.ivRadBackImageOption0.setFocusPainted(false);
        buttonGroup2.add(this.ivRadBackImageOption0);
        jPanel6.add(this.ivRadBackImageOption0);
        this.ivRadBackImageOption1 = new JRadioButton(Tools.translate("Config-Image1"));
        this.ivRadBackImageOption1.setPreferredSize(new Dimension(192, 19));
        this.ivRadBackImageOption1.setFocusPainted(false);
        buttonGroup2.add(this.ivRadBackImageOption1);
        jPanel6.add(this.ivRadBackImageOption1);
        JPanel jPanel7 = new JPanel(new FlowLayout(0, 4, 4), false);
        jPanel7.setPreferredSize(new Dimension(334, 50));
        jPanel5.add(jPanel7);
        this.ivTxtBackImage = new JTextField();
        this.ivTxtBackImage.setPreferredSize(new Dimension(326, 19));
        jPanel7.add(this.ivTxtBackImage);
        this.ivBttBackImageBrowse = new JButton(Tools.translate("Config-Browse"));
        this.ivBttBackImageBrowse.setPreferredSize(new Dimension(161, 19));
        this.ivBttBackImageBrowse.setFocusPainted(false);
        this.ivBttBackImageBrowse.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DlgConfig.this.eventButtonClicked(actionEvent);
            }
        });
        jPanel7.add(this.ivBttBackImageBrowse);
        this.ivBttBackImageCancel = new JButton(Tools.translate("Config-Reset"));
        this.ivBttBackImageCancel.setPreferredSize(new Dimension(161, 19));
        this.ivBttBackImageCancel.setFocusPainted(false);
        this.ivBttBackImageCancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DlgConfig.this.eventButtonClicked(actionEvent);
            }
        });
        jPanel7.add(this.ivBttBackImageCancel);
        this.ivTabPane.insertTab(Tools.translate("Config-Background"), null, jPanel, null, 1);
    }

    private void initializeCard() {
        JPanel jPanel = new JPanel(new FlowLayout(0, 4, 4), false);
        jPanel.setPreferredSize(new Dimension(552, 202));
        JPanel jPanel2 = new JPanel(new FlowLayout(0, 4, 4), false);
        jPanel2.setPreferredSize(new Dimension(270, 137));
        jPanel2.setBorder(new TitledBorder(Tools.translate("Config-BackImage")));
        jPanel.add(jPanel2);
        List list = Tools.getCardbackPreviews(1);
        this.ivLblCardback = new JLabel();
        this.ivLblCardback.setPreferredSize(new Dimension(65, 103));
        this.ivLblCardback.setBorder(new LineBorder(Color.white, 4));
        this.ivLblCardback.setVerticalAlignment(1);
        jPanel2.add(this.ivLblCardback);
        JPanel jPanel3 = new JPanel(new FlowLayout(0, 2, 2), false);
        int n = 57 * list.size() + 2 * (list.size() + 1);
        jPanel3.setPreferredSize(new Dimension(n, 85));
        jPanel3.setSize(jPanel3.getPreferredSize());
        jPanel3.setOpaque(true);
        jPanel3.setBackground(Color.darkGray);
        this.ivLblCardbacks = new JLabel[list.size()];
        int n2 = 0;
        while (n2 < list.size()) {
            ImageIcon imageIcon = (ImageIcon)list.get(n2);
            this.ivLblCardbacks[n2] = new JLabel();
            this.ivLblCardbacks[n2].setName("Cardbacks");
            this.ivLblCardbacks[n2].setPreferredSize(new Dimension(57, 81));
            this.ivLblCardbacks[n2].setIcon(imageIcon);
            this.ivLblCardbacks[n2].addMouseListener(new MouseAdapter(){

                public void mouseClicked(MouseEvent mouseEvent) {
                    DlgConfig.this.eventLabelMouseClicked(mouseEvent);
                }
            });
            jPanel3.add(this.ivLblCardbacks[n2]);
            if (this.ivConfig != null && imageIcon.getDescription().equals(this.ivConfig.getCardBack())) {
                this.ivLblCardback.setIcon(imageIcon);
            }
            ++n2;
        }
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.setPreferredSize(new Dimension(182, 103));
        jScrollPane.setHorizontalScrollBarPolicy(32);
        jScrollPane.setVerticalScrollBarPolicy(21);
        jScrollPane.getHorizontalScrollBar().setUnitIncrement(n / list.size());
        jScrollPane.setViewportView(jPanel3);
        jPanel2.add(jScrollPane);
        JPanel jPanel4 = new JPanel(new FlowLayout(0, 4, 4), false);
        jPanel4.setPreferredSize(new Dimension(270, 137));
        jPanel4.setBorder(new TitledBorder(Tools.translate("Config-FrontImage")));
        jPanel.add(jPanel4);
        List list2 = Tools.getCardPreviews(1);
        this.ivLblCardset = new JLabel();
        this.ivLblCardset.setPreferredSize(new Dimension(65, 103));
        this.ivLblCardset.setBorder(new LineBorder(Color.white, 4));
        this.ivLblCardset.setVerticalAlignment(1);
        jPanel4.add(this.ivLblCardset);
        JPanel jPanel5 = new JPanel(new FlowLayout(0, 2, 2), false);
        int n3 = 57 * list2.size() + 2 * (list2.size() + 1);
        jPanel5.setPreferredSize(new Dimension(n3, 85));
        jPanel5.setSize(jPanel5.getPreferredSize());
        jPanel5.setOpaque(true);
        jPanel5.setBackground(Color.darkGray);
        this.ivLblCardsets = new JLabel[list2.size()];
        int n4 = 0;
        while (n4 < list2.size()) {
            ImageIcon imageIcon = (ImageIcon)list2.get(n4);
            this.ivLblCardsets[n4] = new JLabel();
            this.ivLblCardsets[n4].setName("Cardsets");
            this.ivLblCardsets[n4].setPreferredSize(new Dimension(57, 81));
            this.ivLblCardsets[n4].setIcon(imageIcon);
            this.ivLblCardsets[n4].addMouseListener(new MouseAdapter(){

                public void mouseClicked(MouseEvent mouseEvent) {
                    DlgConfig.this.eventLabelMouseClicked(mouseEvent);
                }
            });
            jPanel5.add(this.ivLblCardsets[n4]);
            if (this.ivConfig != null && imageIcon.getDescription().equals(this.ivConfig.getCardSet())) {
                this.ivLblCardset.setIcon(imageIcon);
            }
            ++n4;
        }
        JScrollPane jScrollPane2 = new JScrollPane();
        jScrollPane2.setPreferredSize(new Dimension(182, 103));
        jScrollPane2.setHorizontalScrollBarPolicy(32);
        jScrollPane2.setVerticalScrollBarPolicy(21);
        jScrollPane2.getHorizontalScrollBar().setUnitIncrement(n3 / list2.size());
        jScrollPane2.setViewportView(jPanel5);
        jPanel4.add(jScrollPane2);
        JPanel jPanel6 = new JPanel(new FlowLayout(0, 4, 4), false);
        jPanel6.setPreferredSize(new Dimension(544, 53));
        jPanel6.setBorder(new TitledBorder(Tools.translate("Config-Scaling")));
        jPanel.add(jPanel6);
        ButtonGroup buttonGroup = new ButtonGroup();
        this.ivRadScale1 = new JRadioButton("640x480");
        this.ivRadScale1.setPreferredSize(new Dimension(120, 19));
        this.ivRadScale1.setFocusPainted(false);
        buttonGroup.add(this.ivRadScale1);
        jPanel6.add(this.ivRadScale1);
        this.ivRadScale2 = new JRadioButton("800x600");
        this.ivRadScale2.setPreferredSize(new Dimension(120, 19));
        this.ivRadScale2.setFocusPainted(false);
        buttonGroup.add(this.ivRadScale2);
        jPanel6.add(this.ivRadScale2);
        this.ivRadScale3 = new JRadioButton("1024x768");
        this.ivRadScale3.setPreferredSize(new Dimension(120, 19));
        this.ivRadScale3.setFocusPainted(false);
        buttonGroup.add(this.ivRadScale3);
        jPanel6.add(this.ivRadScale3);
        this.ivTabPane.insertTab(Tools.translate("Config-Card"), null, jPanel, null, 2);
    }

    private void initializeGeneral() {
        JPanel jPanel = new JPanel(new FlowLayout(0, 4, 4), false);
        jPanel.setPreferredSize(new Dimension(552, 196));
        JPanel jPanel2 = new JPanel(new FlowLayout(0, 4, 4), false);
        jPanel2.setPreferredSize(new Dimension(544, 53));
        jPanel2.setBorder(new TitledBorder(Tools.translate("Config-Behavior")));
        jPanel.add(jPanel2);
        this.ivChkAutoEnd = new JCheckBox(Tools.translate("Config-AutoEnd"));
        this.ivChkAutoEnd.setPreferredSize(new Dimension(300, 19));
        this.ivChkAutoEnd.setFocusPainted(false);
        jPanel2.add(this.ivChkAutoEnd);
        this.ivChkSounds = new JCheckBox(Tools.translate("Config-Sounds"));
        this.ivChkSounds.setPreferredSize(new Dimension(160, 19));
        this.ivChkSounds.setFocusPainted(false);
        jPanel2.add(this.ivChkSounds);
        JPanel jPanel3 = new JPanel(new FlowLayout(0, 4, 4), false);
        jPanel3.setPreferredSize(new Dimension(270, 74));
        jPanel3.setBorder(new TitledBorder(Tools.translate("Config-Frames")));
        jPanel.add(jPanel3);
        this.ivSldAnims = new JSlider(1, 21, 6);
        this.ivSldAnims.setPreferredSize(new Dimension(252, 40));
        this.ivSldAnims.setMajorTickSpacing(4);
        this.ivSldAnims.setMinorTickSpacing(1);
        this.ivSldAnims.setPaintLabels(true);
        this.ivSldAnims.setPaintTicks(true);
        this.ivSldAnims.setPaintTrack(true);
        this.ivSldAnims.setSnapToTicks(true);
        jPanel3.add(this.ivSldAnims);
        JPanel jPanel4 = new JPanel(new FlowLayout(0, 4, 4), false);
        jPanel4.setPreferredSize(new Dimension(270, 74));
        jPanel4.setBorder(new TitledBorder(Tools.translate("Config-WiseMan")));
        jPanel.add(jPanel4);
        this.ivSldAITime = new JSlider(1, 9, 3);
        this.ivSldAITime.setPreferredSize(new Dimension(252, 40));
        this.ivSldAITime.setMajorTickSpacing(4);
        this.ivSldAITime.setMinorTickSpacing(1);
        this.ivSldAITime.setPaintLabels(true);
        this.ivSldAITime.setPaintTicks(true);
        this.ivSldAITime.setPaintTrack(true);
        this.ivSldAITime.setSnapToTicks(true);
        jPanel4.add(this.ivSldAITime);
        JPanel jPanel5 = new JPanel(new FlowLayout(0, 4, 4), false);
        jPanel5.setPreferredSize(new Dimension(544, 53));
        jPanel5.setBorder(new TitledBorder(Tools.translate("Config-Browser")));
        jPanel.add(jPanel5);
        this.ivTxtBrowser = new JTextField();
        this.ivTxtBrowser.setPreferredSize(new Dimension(434, 19));
        jPanel5.add(this.ivTxtBrowser);
        this.ivBttBrowserBrowse = new JButton(Tools.translate("Config-Browse"));
        this.ivBttBrowserBrowse.setPreferredSize(new Dimension(88, 19));
        this.ivBttBrowserBrowse.setFocusPainted(false);
        this.ivBttBrowserBrowse.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DlgConfig.this.eventButtonClicked(actionEvent);
            }
        });
        jPanel5.add(this.ivBttBrowserBrowse);
        this.ivTabPane.insertTab(Tools.translate("Config-General"), null, jPanel, null, 0);
    }

    private void initializeToolbar() {
        JPanel jPanel = new JPanel(new FlowLayout(1, 8, 2), false);
        jPanel.setPreferredSize(new Dimension(557, 40));
        jPanel.setBorder(new EtchedBorder());
        this.getContentPane().add(jPanel);
        this.ivBttOK = new JButton();
        this.ivBttOK.setPreferredSize(new Dimension(128, 32));
        this.ivBttOK.setIcon(Tools.getIcon("OK.gif"));
        this.ivBttOK.setRolloverIcon(Tools.getIcon("OKSelected.gif"));
        this.ivBttOK.setPressedIcon(Tools.getIcon("OKSelected.gif"));
        this.ivBttOK.setToolTipText(Tools.translate("Config-OK"));
        this.ivBttOK.setFocusPainted(false);
        this.ivBttOK.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DlgConfig.this.eventButtonClicked(actionEvent);
            }
        });
        jPanel.add(this.ivBttOK);
        this.ivBttHelp = new JButton();
        this.ivBttHelp.setPreferredSize(new Dimension(128, 32));
        this.ivBttHelp.setIcon(Tools.getIcon("Help.gif"));
        this.ivBttHelp.setRolloverIcon(Tools.getIcon("HelpSelected.gif"));
        this.ivBttHelp.setPressedIcon(Tools.getIcon("HelpSelected.gif"));
        this.ivBttHelp.setToolTipText(Tools.translate("Config-Help"));
        this.ivBttHelp.setFocusPainted(false);
        this.ivBttHelp.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DlgConfig.this.eventButtonClicked(actionEvent);
            }
        });
        jPanel.add(this.ivBttHelp);
        this.ivBttCancel = new JButton();
        this.ivBttCancel.setPreferredSize(new Dimension(128, 32));
        this.ivBttCancel.setIcon(Tools.getIcon("Cancel.gif"));
        this.ivBttCancel.setRolloverIcon(Tools.getIcon("CancelSelected.gif"));
        this.ivBttCancel.setPressedIcon(Tools.getIcon("CancelSelected.gif"));
        this.ivBttCancel.setToolTipText(Tools.translate("Config-Cancel"));
        this.ivBttCancel.setFocusPainted(false);
        this.ivBttCancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DlgConfig.this.eventButtonClicked(actionEvent);
            }
        });
        jPanel.add(this.ivBttCancel);
    }

    private void initializeValues() {
        if (this.ivConfig == null) {
            return;
        }
        this.ivChkAutoEnd.setSelected(this.ivConfig.isAutoEndGame());
        this.ivChkSounds.setSelected(this.ivConfig.isSounds());
        this.ivSldAnims.setValue(this.ivConfig.getAnims());
        this.ivSldAITime.setValue(this.ivConfig.getAITime());
        this.ivTxtBrowser.setText(this.ivConfig.getBrowser());
        if (this.ivConfig.getBackColorOption() == 0) {
            this.ivRadBackColorOption0.setSelected(true);
        }
        if (this.ivConfig.getBackColorOption() == 1) {
            this.ivRadBackColorOption1.setSelected(true);
        }
        if (this.ivConfig.getBackColorOption() == 2) {
            this.ivRadBackColorOption2.setSelected(true);
        }
        this.ivBttBackColor1.setBackground(this.ivConfig.getBackColor1());
        this.ivBttBackColor2.setBackground(this.ivConfig.getBackColor2());
        int n = (this.ivBttBackColor1.getBackground().getRed() + 128) % 256;
        int n2 = (this.ivBttBackColor1.getBackground().getGreen() + 128) % 256;
        int n3 = (this.ivBttBackColor1.getBackground().getBlue() + 128) % 256;
        this.ivBttBackColor1.setForeground(new Color(n, n2, n3));
        n = (this.ivBttBackColor2.getBackground().getRed() + 128) % 256;
        n2 = (this.ivBttBackColor2.getBackground().getGreen() + 128) % 256;
        n3 = (this.ivBttBackColor2.getBackground().getBlue() + 128) % 256;
        this.ivBttBackColor2.setForeground(new Color(n, n2, n3));
        if (this.ivConfig.getBackImageOption() == 0) {
            this.ivRadBackImageOption0.setSelected(true);
        }
        if (this.ivConfig.getBackImageOption() == 1) {
            this.ivRadBackImageOption1.setSelected(true);
        }
        this.ivTxtBackImage.setText(this.ivConfig.getBackImage());
        if (this.ivConfig.getScale() == 1) {
            this.ivRadScale1.setSelected(true);
        }
        if (this.ivConfig.getScale() == 2) {
            this.ivRadScale2.setSelected(true);
        }
        if (this.ivConfig.getScale() == 3) {
            this.ivRadScale3.setSelected(true);
        }
    }

    public static void main(String[] stringArray) {
        try {
            DlgConfig dlgConfig = new DlgConfig();
            dlgConfig.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent windowEvent) {
                    System.exit(0);
                }
            });
        }
        catch (Throwable throwable) {
            System.err.println("Exception occurred in main() of javax.swing.JFrame");
            throwable.printStackTrace(System.out);
        }
    }
}

