/*
 * Decompiled with CFR 0.152.
 */
package kgd.card.player.data;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.StringTokenizer;
import kgd.card.player.data.Card;
import kgd.card.player.data.Suit;
import kgd.card.player.data.Widget;

public class Pile
extends Widget {
    public static final int DRAG_NONE = 0;
    public static final int DRAG_SUIT = 1;
    public static final int DRAG_LAST = 2;
    public static final int DRAG_ANY_SINGLE = 3;
    public static final int DRAG_ANY_STACK = 4;
    private String ivDrag;
    private int ivDragType;
    private Suit ivDragSuit;
    private boolean ivDragFullStack;
    public static final int STACK_NONE = 0;
    public static final int STACK_SUIT_FULL = 1;
    public static final int STACK_SUIT_FIRST = 2;
    public static final int STACK_ANY = 3;
    private String ivStack;
    private int ivStackType;
    private int ivStackMax;
    private String ivStackPiles;
    private Suit ivStackSuit;
    private boolean ivStackRank;
    private String ivStackCards;
    public static final int FILL_NONE = 0;
    public static final int FILL_SUIT_BASE = 1;
    public static final int FILL_SUIT_ANY = 2;
    public static final int FILL_ANY = 3;
    private int ivFill;
    private String ivFillPile;
    public static final int VISIBILITY_NONE = 0;
    public static final int VISIBILITY_ALL = 1;
    public static final int VISIBILITY_LAST = 2;
    private int ivVisibility;
    private String ivSetup;
    private List ivCards = new ArrayList(26);
    private boolean ivActive = true;

    public Pile(String string, String string2, int n, String string3, String string4, int n2, String string5, int n3, String string6) {
        this.ivDrag = string;
        this.ivDragType = Integer.parseInt(string.substring(0, 1));
        this.ivDragSuit = new Suit(string.substring(1, 9));
        this.ivDragFullStack = string.substring(9, 10).equals("T");
        this.ivStack = string2;
        this.ivStackType = Integer.parseInt(string2.substring(0, 1));
        this.ivStackSuit = new Suit(string2.substring(1, 9));
        this.ivStackRank = string2.substring(9, 10).equals("T");
        this.ivStackMax = n;
        this.ivStackPiles = string3;
        this.ivStackCards = string4;
        this.ivFill = n2;
        this.ivFillPile = string5;
        this.ivVisibility = n3;
        this.ivSetup = string6;
    }

    public Pile(Pile pile, boolean bl) {
        this.ivDrag = pile.getDrag();
        this.ivDragType = pile.getDragType();
        this.ivDragSuit = pile.getDragSuit();
        this.ivDragFullStack = pile.isDragFullStack();
        this.ivStack = pile.getStack();
        this.ivStackType = pile.getStackType();
        this.ivStackMax = pile.getStackMax();
        this.ivStackPiles = pile.getStackPiles();
        this.ivStackSuit = pile.getStackSuit();
        this.ivStackRank = pile.isStackRank();
        this.ivStackCards = pile.getStackCards();
        this.ivFill = pile.getFill();
        this.ivFillPile = pile.getFillPile();
        this.ivVisibility = pile.getVisibility();
        this.ivSetup = pile.getSetup();
        this.ivActive = pile.isActive();
        if (bl) {
            int n = 0;
            while (n < pile.getCards().size()) {
                Card card = new Card((Card)pile.getCards().get(n), this);
                this.ivCards.add(card);
                ++n;
            }
        }
    }

    private boolean checkStackCards(Suit suit) {
        String string;
        int n;
        if (this.ivStackCards.equals("X")) {
            return true;
        }
        HashMap<String, String> hashMap = new HashMap<String, String>(13);
        StringTokenizer stringTokenizer = new StringTokenizer(this.ivStackCards, "|");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            StringTokenizer stringTokenizer2 = new StringTokenizer(string2, "-");
            String string3 = stringTokenizer2.nextToken();
            String string4 = stringTokenizer2.nextToken();
            if (string3.equals("*")) {
                n = 0;
                while (n < 4) {
                    string = String.valueOf(n) + "-" + string4;
                    hashMap.put(string, string);
                    ++n;
                }
                continue;
            }
            if (string4.equals("*")) {
                n = 0;
                while (n < 13) {
                    string = String.valueOf(string3) + "-" + n;
                    hashMap.put(string, string);
                    ++n;
                }
                continue;
            }
            string = String.valueOf(string3) + "-" + string4;
            hashMap.put(string, string);
        }
        n = 0;
        while (n < suit.getCards().size()) {
            string = ((Card)suit.getCards().get(n)).getId();
            if (!hashMap.containsKey(string)) {
                return false;
            }
            ++n;
        }
        return true;
    }

    private boolean checkStackPiles(Suit suit) {
        if (this.ivStackPiles.equals("X")) {
            return true;
        }
        boolean bl = false;
        Pile pile = ((Card)suit.getCards().get(0)).getPile();
        String string = pile.getClass().getName();
        StringTokenizer stringTokenizer = new StringTokenizer(this.ivStackPiles, "|");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (!string.endsWith(string2)) continue;
            bl = true;
            break;
        }
        return bl;
    }

    private boolean checkStackSuit(Suit suit) {
        Object object;
        Object object2;
        if (this.ivCards.isEmpty() && this.ivFill == 1) {
            object2 = (Card)suit.getCards().get(0);
            if (this.ivStackSuit.isAscending() && this.ivStackSuit.isDescending()) {
                if (((Card)object2).getRank() > 0 && ((Card)object2).getRank() < 12) {
                    return false;
                }
            } else {
                if (this.ivStackSuit.isAscending() && ((Card)object2).getRank() > 0) {
                    return false;
                }
                if (this.ivStackSuit.isDescending() && ((Card)object2).getRank() < 12) {
                    return false;
                }
            }
        }
        if (!this.ivCards.isEmpty() && this.ivStackRank) {
            object2 = (Card)this.ivCards.get(this.ivCards.size() - 1);
            object = (Card)suit.getCards().get(0);
            if (((Card)object2).getRank() == ((Card)object).getRank()) {
                return true;
            }
        }
        object2 = new ArrayList(26);
        if (!this.ivCards.isEmpty()) {
            object2.add(this.ivCards.get(this.ivCards.size() - 1));
        }
        if (this.ivStackType == 1) {
            object2.addAll(suit.getCards());
        } else {
            object2.add(suit.getCards().get(0));
        }
        object = new Suit((List)object2);
        return this.checkSuitForStacking((Suit)object);
    }

    private boolean checkSuitForDragging(Suit suit) {
        if (suit.isInvalid()) {
            return false;
        }
        if (suit.isSingleton()) {
            return true;
        }
        if (suit.isWrapped() && !this.ivDragSuit.isWrapped()) {
            return false;
        }
        if (suit.isPartial() && !this.ivDragSuit.isPartial()) {
            return false;
        }
        if (!this.ivDragSuit.isAscending() || !this.ivDragSuit.isDescending()) {
            if (this.ivDragSuit.isAscending() && suit.isDescending()) {
                return false;
            }
            if (this.ivDragSuit.isDescending() && suit.isAscending()) {
                return false;
            }
        }
        if (!(this.ivDragSuit.isFamily() && this.ivDragSuit.isColor() && this.ivDragSuit.isOtherColor() && this.ivDragSuit.isOtherFamily())) {
            if (this.ivDragSuit.isFamily() && !suit.isFamily()) {
                return false;
            }
            if (this.ivDragSuit.isColor() && !suit.isColor()) {
                return false;
            }
            if (this.ivDragSuit.isOtherColor() && !suit.isOtherColor()) {
                return false;
            }
            if (this.ivDragSuit.isOtherFamily() && !suit.isOtherFamily()) {
                return false;
            }
        }
        return true;
    }

    private boolean checkSuitForStacking(Suit suit) {
        if (suit.isInvalid()) {
            return false;
        }
        if (suit.isSingleton() && this.ivStackSuit.isPartial()) {
            return true;
        }
        if (suit.isWrapped() && !this.ivStackSuit.isWrapped()) {
            return false;
        }
        if (suit.isPartial() && !this.ivStackSuit.isPartial()) {
            return false;
        }
        if (!this.ivStackSuit.isAscending() || !this.ivStackSuit.isDescending()) {
            if (this.ivStackSuit.isAscending() && suit.isDescending()) {
                return false;
            }
            if (this.ivStackSuit.isDescending() && suit.isAscending()) {
                return false;
            }
        }
        if (!(this.ivStackSuit.isFamily() && this.ivStackSuit.isColor() && this.ivStackSuit.isOtherColor() && this.ivStackSuit.isOtherFamily())) {
            if (this.ivStackSuit.isFamily() && !suit.isFamily()) {
                return false;
            }
            if (this.ivStackSuit.isColor() && !suit.isColor()) {
                return false;
            }
            if (this.ivStackSuit.isOtherColor() && !suit.isOtherColor()) {
                return false;
            }
            if (this.ivStackSuit.isOtherFamily() && !suit.isOtherFamily()) {
                return false;
            }
        }
        return true;
    }

    protected Pile duplicateOld() {
        return new Pile(this.ivDrag, this.ivStack, this.ivStackMax, this.ivStackPiles, this.ivStackCards, this.ivFill, this.ivFillPile, this.ivVisibility, this.ivSetup);
    }

    public List getCards() {
        return this.ivCards;
    }

    public String getDrag() {
        return this.ivDrag;
    }

    public Suit getDragSuit() {
        return this.ivDragSuit;
    }

    public int getDragType() {
        return this.ivDragType;
    }

    public int getFill() {
        return this.ivFill;
    }

    public String getFillPile() {
        return this.ivFillPile;
    }

    protected String getId() {
        if (this.ivCards.isEmpty()) {
            return "NULL";
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < this.ivCards.size()) {
            Card card = (Card)this.ivCards.get(n);
            if (card.isFlipped()) {
                stringBuffer.append(String.valueOf(card.getId()) + "T");
            } else {
                stringBuffer.append(String.valueOf(card.getId()) + "F");
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    public Card getLastCard() {
        if (this.ivCards.isEmpty()) {
            return null;
        }
        return (Card)this.ivCards.get(this.ivCards.size() - 1);
    }

    public String getSetup() {
        return this.ivSetup;
    }

    public String getStack() {
        return this.ivStack;
    }

    public String getStackCards() {
        return this.ivStackCards;
    }

    public int getStackMax() {
        return this.ivStackMax;
    }

    public String getStackPiles() {
        return this.ivStackPiles;
    }

    public Suit getStackSuit() {
        return this.ivStackSuit;
    }

    public int getStackType() {
        return this.ivStackType;
    }

    public Suit getSuitForDragging(Card card) {
        int n;
        if (this.ivDragType == 0) {
            return null;
        }
        ArrayList<Card> arrayList = new ArrayList<Card>(26);
        switch (this.ivDragType) {
            case 2: {
                if (this.ivCards.indexOf(card) != this.ivCards.size() - 1) break;
                arrayList.add(card);
                break;
            }
            case 3: {
                arrayList.add(card);
                break;
            }
            case 1: 
            case 4: {
                boolean bl = true;
                n = this.ivCards.indexOf(card);
                while (n < this.ivCards.size()) {
                    if (((Card)this.ivCards.get(n)).isFlipped()) {
                        arrayList.add((Card)this.ivCards.get(n));
                    } else {
                        bl = false;
                    }
                    ++n;
                }
                if (bl) break;
                arrayList = new ArrayList(26);
                break;
            }
        }
        if (arrayList.isEmpty()) {
            return null;
        }
        Suit suit = new Suit(arrayList);
        if (this.ivDragType != 1) {
            return suit;
        }
        if (!this.checkSuitForDragging(suit)) {
            return null;
        }
        if (this.ivDragFullStack && !suit.isSingleton() && (n = this.ivCards.indexOf(arrayList.get(0))) > 0 && ((Card)this.ivCards.get(n - 1)).isFlipped()) {
            return null;
        }
        return suit;
    }

    public int getVisibility() {
        return this.ivVisibility;
    }

    public Widget getWidgetForStacking(Suit suit) {
        if (!this.ivActive) {
            return null;
        }
        if (this.ivCards.size() + suit.getCards().size() > this.ivStackMax) {
            return null;
        }
        if (this.ivCards.isEmpty() && this.ivFill == 0) {
            return null;
        }
        if (!this.ivCards.isEmpty() && this.ivStackType == 0) {
            return null;
        }
        if (!this.checkStackPiles(suit)) {
            return null;
        }
        if (!this.checkStackCards(suit)) {
            return null;
        }
        Widget widget = this.ivCards.isEmpty() ? this : (Widget)this.ivCards.get(this.ivCards.size() - 1);
        if (this.ivCards.isEmpty() && this.ivFill == 3) {
            return widget;
        }
        if (!this.ivCards.isEmpty() && this.ivStackType == 3) {
            return widget;
        }
        if (this.checkStackSuit(suit)) {
            return widget;
        }
        return null;
    }

    public boolean isActive() {
        return this.ivActive;
    }

    public boolean isDragFullStack() {
        return this.ivDragFullStack;
    }

    public boolean isStackRank() {
        return this.ivStackRank;
    }

    protected void setActive(boolean bl) {
        if (bl == this.ivActive) {
            return;
        }
        boolean bl2 = this.ivActive;
        this.ivActive = bl;
        this.fireStateChanged("Active");
    }
}

