/*
 * Decompiled with CFR 0.152.
 */
package kgd.card.player.ai;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kgd.card.player.ai.State;
import kgd.card.player.data.Card;
import kgd.card.player.data.Drag;
import kgd.card.player.data.Game;
import kgd.card.player.data.Pile;
import kgd.card.player.data.Stock;
import kgd.card.player.data.Tableau;

public final class AI {
    private Map ivStates;
    private long ivStartTime;
    private long ivMaxTime;
    private boolean ivBreak;
    private Game ivGame;
    private List ivGamePiles;
    private State ivWonState;
    private boolean ivWon;
    private boolean ivBlocked;
    private int ivDuplicates;
    private int ivDepth;
    private int ivBestDuplicates;

    private void analyse(State state) {
        if (System.currentTimeMillis() - this.ivStartTime > this.ivMaxTime) {
            System.out.println("AI break time...");
            this.ivBreak = true;
            return;
        }
        ++this.ivDepth;
        int n = 0;
        while (n < this.ivGame.getOrderedSourcePiles().size()) {
            State state2;
            Pile pile = (Pile)this.ivGame.getOrderedSourcePiles().get(n);
            if (pile instanceof Stock) {
                if (this.ivGame.eventDealStock()) {
                    state2 = new State(this.ivGame.getId(), null, -1, state);
                    if (this.ivGame.isWon()) {
                        this.ivWonState = state2;
                        this.ivBreak = true;
                    }
                    if (this.updateStates(state2) && !this.ivGame.isWon()) {
                        this.analyse(state2);
                    }
                    this.ivGame.eventUndo();
                    if (this.ivBreak) {
                        break;
                    }
                }
            } else if (!(this.ivGame.isFan() && pile instanceof Tableau && ((Tableau)pile).isComplete())) {
                int n2 = pile.getCards().size() - 1;
                while (n2 > -1) {
                    Card card = (Card)pile.getCards().get(n2);
                    Drag drag = this.ivGame.eventStartMove(card);
                    if (drag != null) {
                        int n3 = 0;
                        while (n3 < drag.getTargetWidgets().size()) {
                            drag.setTargetIndex(n3);
                            this.ivGame.eventStopMove(drag);
                            state2 = new State(this.ivGame.getId(), drag, n3, state);
                            if (this.ivGame.isWon()) {
                                this.ivWonState = state2;
                                this.ivBreak = true;
                            }
                            if (this.updateStates(state2) && !this.ivGame.isWon()) {
                                this.analyse(state2);
                            }
                            this.ivGame.eventUndo();
                            if (this.ivBreak) break;
                            ++n3;
                        }
                        if (this.ivBreak) break;
                    }
                    --n2;
                }
                if (this.ivBreak) break;
            }
            ++n;
        }
        --this.ivDepth;
    }

    private List findBestMoves(State state) {
        if (this.ivStates.isEmpty()) {
            return null;
        }
        ArrayList<State> arrayList = new ArrayList<State>(101);
        if (this.ivWonState == null) {
            Iterator iterator = this.ivStates.values().iterator();
            while (iterator.hasNext()) {
                State state2 = (State)iterator.next();
                if (state2.getPrevState() != state) continue;
                arrayList.add(state2);
                break;
            }
            return arrayList;
        }
        State state3 = this.ivWonState;
        while (state3.getPrevState() != null) {
            arrayList.add(state3);
            state3 = state3.getPrevState();
        }
        return arrayList;
    }

    public boolean isBlocked() {
        return this.ivBlocked;
    }

    public boolean isWon() {
        return this.ivWon;
    }

    public List searchStates(Game game, long l) {
        this.ivGame = game;
        this.ivGame.setAIControlled(true);
        if (l == -1L) {
            l = 3000L;
        }
        this.ivMaxTime = l;
        this.ivStartTime = System.currentTimeMillis();
        this.ivWonState = null;
        this.ivBreak = false;
        this.ivStates = new HashMap(1000, 1.0f);
        this.ivDuplicates = 0;
        this.ivDepth = 0;
        this.ivBestDuplicates = 0;
        State state = new State(this.ivGame.getId(), null, -1, null);
        this.ivStates.put(state.getId(), state);
        this.analyse(state);
        if (this.ivWonState != null) {
            this.ivWon = true;
            this.ivBlocked = false;
        } else {
            this.ivWon = false;
            this.ivBlocked = this.ivBreak ^ true;
        }
        System.out.println("AI completed. Found " + this.ivStates.size() + " ... Duplicates = " + this.ivDuplicates + " Best = " + this.ivBestDuplicates);
        this.ivGame.setAIControlled(false);
        return this.findBestMoves(state);
    }

    private boolean updateStates(State state) {
        if (!this.ivStates.containsKey(state.getId())) {
            this.ivStates.put(state.getId(), state);
            return true;
        }
        ++this.ivDuplicates;
        State state2 = (State)this.ivStates.get(state.getId());
        if (state2.getDepth() > this.ivDepth) {
            state2.setPrevState(state.getPrevState());
            ++this.ivBestDuplicates;
        }
        return false;
    }
}

