/*
 * Decompiled with CFR 0.152.
 */
package silmar.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URL;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;

public class ResourceUtil {
    public static InputStream getInputStream(String resourcePath) {
        InputStream in;
        File file = new File(resourcePath);
        if (file.exists()) {
            try {
                return new FileInputStream(file);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if ((in = ClassLoader.getSystemClassLoader().getResourceAsStream(resourcePath)) == null) {
            System.out.println("Could not load: " + resourcePath);
        }
        return in;
    }

    public static AudioInputStream getAudioInputStream(String resourcePath) {
        URL url;
        File file = new File(resourcePath);
        if (file.exists()) {
            try {
                return AudioSystem.getAudioInputStream(file);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if ((url = ClassLoader.getSystemClassLoader().getResource(resourcePath)) == null) {
            System.out.println("Could not load: " + resourcePath);
        }
        try {
            return AudioSystem.getAudioInputStream(file);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

