/*
 * Decompiled with CFR 0.152.
 */
package silmar.tiles;

import java.awt.Rectangle;
import silmar.map.MapPixelLocation;
import silmar.map.MapTileLocation;
import silmar.tiles.TileSize;

public class TileSizeUtil
implements TileSize {
    public static MapTileLocation getTileLocation(MapPixelLocation pixelLocation) {
        MapTileLocation result = new MapTileLocation();
        TileSizeUtil.getTileLocation(pixelLocation, result);
        return result;
    }

    public static void getTileLocation(MapPixelLocation pixelLocation, MapTileLocation use) {
        use.move(pixelLocation.x / TileSize.tileSize.width, pixelLocation.y / TileSize.tileSize.height);
    }

    public static MapPixelLocation getPixelLocation(MapTileLocation tileLocation) {
        MapPixelLocation result = new MapPixelLocation();
        TileSizeUtil.getPixelLocation(tileLocation, result);
        return result;
    }

    public static void getPixelLocation(MapTileLocation tileLocation, MapPixelLocation use) {
        use.move(tileLocation.x * TileSize.tileSize.width + TileSize.tileSize.width / 2, tileLocation.y * TileSize.tileSize.height + TileSize.tileSize.height / 2);
    }

    public static MapPixelLocation getUpperLeftPixelLocation(MapTileLocation tileLocation) {
        MapPixelLocation result = new MapPixelLocation();
        TileSizeUtil.getUpperLeftPixelLocation(tileLocation, result);
        return result;
    }

    public static void getUpperLeftPixelLocation(MapTileLocation tileLocation, MapPixelLocation use) {
        TileSizeUtil.getPixelLocation(tileLocation, use);
        use.translate(-TileSize.tileSize.width / 2, -TileSize.tileSize.height / 2);
    }

    public static Rectangle getPixelRectangle(Rectangle tileRect) {
        MapPixelLocation location = TileSizeUtil.getUpperLeftPixelLocation(new MapTileLocation(tileRect.x, tileRect.y));
        return new Rectangle(location.x, location.y, tileRect.width * TileSize.tileSize.width, tileRect.height * TileSize.tileSize.height);
    }

    public static MapPixelLocation getNearestTileCorner(MapPixelLocation of, MapPixelLocation from, MapPixelLocation use) {
        use.x = of.x - Math.abs(of.x % TileSize.tileSize.width) + (of.x < from.x ? TileSize.tileSize.width - 1 : 0);
        use.y = of.y - Math.abs(of.y % TileSize.tileSize.height) + (of.y < from.y ? TileSize.tileSize.height - 1 : 0);
        return use;
    }
}

