/*
 * Decompiled with CFR 0.152.
 */
package silmar.tiles;

import java.io.Serializable;
import silmar.entities.beings.MovementType;

public final class Tile
implements Serializable {
    private boolean passible;
    private boolean blocksLOS;
    private byte index;
    private static byte lastIndex = 0;
    public static final Tile floor = new Tile(true, false);
    public static final Tile wall = new Tile(false, true);
    public static final Tile roomFloor = new Tile(true, false);
    public static final Tile roomWall = new Tile(false, true);
    public static final Tile door = new Tile(true, true);
    public static final Tile secretDoor = new Tile(true, true);
    public static final Tile roomSecretDoor = new Tile(true, true);
    public static final Tile openDoor = new Tile(true, false);
    public static final Tile openSecretDoor = new Tile(true, false);
    public static final Tile openRoomSecretDoor = new Tile(true, false);
    public static final Tile water = new Tile(false, false);
    public static final Tile waterNW = new Tile(true, false);
    public static final Tile waterNE = new Tile(true, false);
    public static final Tile waterSW = new Tile(true, false);
    public static final Tile waterSE = new Tile(true, false);
    public static final Tile road = new Tile(true, false);
    public static final Tile roadNW = new Tile(true, false);
    public static final Tile roadNE = new Tile(true, false);
    public static final Tile roadSW = new Tile(true, false);
    public static final Tile roadSE = new Tile(true, false);
    public static final Tile roomWindow = new Tile(false, false);
    public static final Tile slow = new Tile(true, false);

    public Tile(boolean passible, boolean blocksLOS) {
        this.passible = passible;
        this.blocksLOS = blocksLOS;
        byte by = lastIndex;
        lastIndex = (byte)(by + 1);
        this.index = by;
    }

    public boolean isPassible(MovementType movementType) {
        if ((movementType == MovementType.walkingNoHands || movementType == MovementType.flyingNoHands) && this.blocksLOS) {
            return false;
        }
        if (movementType == MovementType.flying || movementType == MovementType.flyingNoHands) {
            return this.passible || !this.blocksLOS;
        }
        if (movementType == MovementType.earthing || movementType == MovementType.ethereal) {
            return true;
        }
        return this.passible;
    }

    public boolean equals(Tile tile) {
        return this.index == tile.getIndex();
    }

    public int getMovementCost() {
        return !this.equals(slow) ? 1 : 3;
    }

    public boolean isDoor() {
        return this.equals(door) || this.equals(secretDoor) || this.equals(roomSecretDoor);
    }

    public boolean isOpenDoor() {
        return this.equals(openDoor) || this.equals(openSecretDoor) || this.equals(openRoomSecretDoor);
    }

    public Tile getAssociatedOpenDoor() {
        if (this.equals(door)) {
            return openDoor;
        }
        if (this.equals(secretDoor)) {
            return openSecretDoor;
        }
        if (this.equals(roomSecretDoor)) {
            return openRoomSecretDoor;
        }
        return null;
    }

    public Tile getAssociatedDoor() {
        if (this.equals(openDoor)) {
            return door;
        }
        if (this.equals(openSecretDoor)) {
            return secretDoor;
        }
        if (this.equals(openRoomSecretDoor)) {
            return roomSecretDoor;
        }
        return null;
    }

    public final byte getIndex() {
        return this.index;
    }

    public final boolean isPassible() {
        return this.passible;
    }

    public final boolean getBlocksLOS() {
        return this.blocksLOS;
    }
}

