/*
 * Decompiled with CFR 0.152.
 */
package silmar.server;

import java.awt.FileDialog;
import java.awt.Frame;
import java.io.File;
import silmar.Debug;
import silmar.client.Client;
import silmar.entities.MapEntity;
import silmar.entities.beings.player.Player;
import silmar.entities.beings.player.events.PlayerEvents;
import silmar.entities.terrains.Terrain;
import silmar.entities.terrains.TerrainType;
import silmar.game.Game;
import silmar.game.GameUtil;
import silmar.gui.dialogs.MessageDialog;
import silmar.map.Map;
import silmar.map.MapPixelLocation;

public final class Server {
    private Frame parent;
    private boolean quickStart = false;
    private Client client;
    private Game game;

    public Server(Frame parent, boolean quickStart) {
        this.parent = parent;
        this.quickStart = quickStart;
        this.client = new Client(this);
    }

    private boolean doLoadGame(String fileName) {
        MessageDialog dialog = new MessageDialog(this.parent, "Loading game...", false);
        dialog.setModal(false);
        dialog.setVisible(true);
        this.game = GameUtil.doLoad(fileName);
        dialog.setVisible(false);
        if (this.game == null) {
            return false;
        }
        Player player = this.game.getPlayer();
        this.client.setPlayer(player);
        player.doEmitEvent(new PlayerEvents.MapLoading(player));
        player.doEmitEvent(new PlayerEvents.AtMap(player));
        return true;
    }

    public void doCreateGame() {
        FileDialog fileDialog = new FileDialog(this.parent, "Enter game filename");
        fileDialog.setMode(1);
        fileDialog.setVisible(true);
        String fileName = fileDialog.getFile();
        if (fileName == null) {
            return;
        }
        this.parent.setVisible(false);
        this.game = new Game(fileName);
        this.game.onBeginning();
        Player player = new Player();
        this.client.onPlayerCreated(player);
        player.doEmitEvent(new PlayerEvents.MapLoading(player));
        this.game.onPlayerAdded(player);
        Map map = this.game.getMap(0);
        if (Debug.isOn()) {
            // empty if block
        }
        Terrain upExit = map.getTerrainOfType(TerrainType.upExit);
        MapPixelLocation upExitLocation = upExit.getLocation();
        map.doRemoveEntity(upExit);
        map.doAddEntity((MapEntity)player, upExitLocation);
        this.game.doSave();
        this.game.onStarting();
    }

    public void doResumeGame() {
        String gameName = "game";
        if (!this.quickStart) {
            FileDialog fileDialog = new FileDialog(this.parent, "Select game file");
            fileDialog.setMode(0);
            fileDialog.setVisible(true);
            gameName = fileDialog.getFile();
            if (gameName == null) {
                return;
            }
            File file = new File(gameName);
            if (!file.exists()) {
                MessageDialog.doShow(this.parent, "File not found.");
                return;
            }
        }
        this.parent.setVisible(false);
        if (!this.doLoadGame(gameName)) {
            MessageDialog.doShow(this.parent, "Error loading saved game.");
            this.parent.setVisible(true);
            return;
        }
        this.game.onStarting();
    }

    public void onClientQuit() {
        this.game.onStopping();
    }
}

