/*
 * Decompiled with CFR 0.152.
 */
package silmar.map.stocking;

import java.util.ArrayList;
import java.util.List;
import silmar.entities.MapEntity;
import silmar.entities.beings.monsters.MonsterType;
import silmar.entities.beings.talkerBeings.TalkerBeingType;
import silmar.entities.items.Item;
import silmar.entities.items.types.ItemType;
import silmar.entities.items.weapons.WeaponType;
import silmar.entities.terrains.TerrainType;
import silmar.entities.terrains.Terrains;
import silmar.entities.types.EntityType;
import silmar.map.Map;
import silmar.map.MapPixelLocation;
import silmar.map.MapSize;
import silmar.map.stocking.Stockable;
import silmar.util.Random;

public final class MapStocker
implements MapSize {
    private Map map;

    public void doStockMap(Map map) {
        this.map = map;
        float mapSizeFactor = (float)map.getSize().width / 55.0f;
        mapSizeFactor *= mapSizeFactor;
        int averageNumItems = 20;
        float numItems = 20.0f * mapSizeFactor;
        ArrayList<EntityType> types = new ArrayList<EntityType>();
        types.add(ItemType.gold);
        this.doStockTypes(types, Math.round(numItems * 0.2f));
        this.doStockTypes(WeaponType.types, Math.round(numItems * 0.15f));
        this.doStockTypes(ItemType.ammoTypes, Math.round(numItems * 0.05f));
        this.doStockTypes(ItemType.treasureTypes, Math.round(numItems * 0.25f));
        this.doStockTypes(ItemType.armorTypes, Math.round(numItems * 0.1f));
        this.doStockTypes(ItemType.shieldTypes, Math.round(numItems * 0.1f));
        this.doStockTypes(ItemType.nongroupableTypes, Math.round(numItems * 0.15f));
        int averageNumMonters = 30;
        this.doStockTypes(MonsterType.types, (int)(30.0f * mapSizeFactor));
        int averageNumTerrains = 2;
        ArrayList terrainsAndTalkerBeings = new ArrayList();
        terrainsAndTalkerBeings.addAll(TerrainType.nonTrapTypes);
        terrainsAndTalkerBeings.addAll(TalkerBeingType.types);
        this.doStockTypes(terrainsAndTalkerBeings, (int)(2.0f * mapSizeFactor));
        types.clear();
        types.add(TerrainType.chest);
        List chests = this.doStockTypes(types, Math.round(numItems / 2.0f / 2.0f));
        int numChests = chests.size();
        for (int i = 0; i < numChests; ++i) {
            Terrains.Chest chest = (Terrains.Chest)chests.get(i);
            chest.doCheckForBeingTrapped();
        }
        int averageNumTraps = 8;
        this.doStockTypes(TerrainType.trapTypes, (int)(8.0f * mapSizeFactor));
        int averageNumBoulders = 10;
        ArrayList<TerrainType> boulderList = new ArrayList<TerrainType>();
        boulderList.add(TerrainType.boulder);
        this.doStockTypes(boulderList, (int)(10.0f * mapSizeFactor));
        int averageNumRadiations = 14;
        ArrayList<TerrainType> radiationList = new ArrayList<TerrainType>();
        radiationList.add(TerrainType.radiation);
        this.doStockTypes(radiationList, (int)(14.0f * mapSizeFactor));
    }

    private List doCullValidStockables(List stockables) {
        ArrayList<Stockable> valids = new ArrayList<Stockable>();
        int numStockables = stockables.size();
        for (int i = 0; i < numStockables; ++i) {
            Stockable stockable = (Stockable)stockables.get(i);
            if (!stockable.isValidForMap(this.map)) continue;
            for (int j = 0; j < stockable.getFrequency(); ++j) {
                valids.add(stockable);
            }
        }
        return valids;
    }

    private List doStockTypes(List stockables, int numberToStock) {
        ArrayList<MapEntity> stocked = new ArrayList<MapEntity>();
        List valids = this.doCullValidStockables(stockables);
        if (valids.size() == 0) {
            return stocked;
        }
        for (int i = 0; i < numberToStock; ++i) {
            Stockable stockable = (Stockable)valids.get(Random.getInt(0, valids.size() - 1));
            MapEntity entity = stockable.doCreateStockInstance();
            MapPixelLocation location = null;
            while ((location = this.map.getRandomPassibleRectangleLocation(entity.getSize())) == null || !stockable.isPlacementLocationValid(this.map, location)) {
            }
            this.map.doAddEntity(entity, location);
            stocked.add(entity);
            this.onEntityStocked(entity);
        }
        return stocked;
    }

    public void doStockLocations(Map map, List locations, List stockables) {
        this.map = map;
        List valids = this.doCullValidStockables(stockables);
        if (valids.size() == 0) {
            return;
        }
        int numLocations = locations.size();
        for (int i = 0; i < numLocations; ++i) {
            MapPixelLocation location = (MapPixelLocation)locations.get(i);
            Stockable stockable = (Stockable)valids.get(Random.getInt(0, valids.size() - 1));
            MapEntity entity = stockable.doCreateStockInstance();
            map.doAddEntity(entity, location);
            this.onEntityStocked(entity);
        }
    }

    private void onEntityStocked(MapEntity stocked) {
        if (stocked.isItem()) {
            Item item = (Item)stocked;
            item.doCheckToPutSelfInChest();
        }
    }
}

