/*
 * Decompiled with CFR 0.152.
 */
package silmar.map.loading;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import silmar.map.Map;
import silmar.map.MapTileLocation;
import silmar.map.loading.MapTranslator;
import silmar.tiles.TileSize;
import silmar.util.ImageUtil;

public final class MapLoader
implements TileSize {
    public void doLoadMap(Map map, String filename, MapTranslator translator) {
        BufferedImage image = ImageUtil.doLoadImage(filename, false);
        int width = image.getWidth();
        int height = image.getHeight();
        map.setSize(new Dimension(width, height));
        translator.setMap(map);
        MapTileLocation location = new MapTileLocation();
        for (int i = 0; i < width; ++i) {
            for (int j = 0; j < height; ++j) {
                location.setLocation(i, j);
                translator.doTranslate(new Color(image.getRGB(i, j)), location);
            }
        }
        translator.onMapTranslated();
    }
}

