/*
 * Decompiled with CFR 0.152.
 */
package silmar.map.generation;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import silmar.entities.MapEntity;
import silmar.entities.terrains.Terrain;
import silmar.entities.terrains.TerrainFactory;
import silmar.entities.terrains.TerrainType;
import silmar.events.Event;
import silmar.events.EventType;
import silmar.events.Listener;
import silmar.events.Reporter;
import silmar.map.Map;
import silmar.map.MapPixelLocation;
import silmar.map.MapSize;
import silmar.map.MapTileLocation;
import silmar.tiles.Tile;
import silmar.tiles.TileSize;
import silmar.util.ListUtil;
import silmar.util.Random;

public final class MapGenerator
implements TileSize,
MapSize {
    private static final int minRoomWidth = 3;
    private static final int maxRoomWidth = 15;
    private Map map;
    private Dimension size;
    private final Reporter reporter = new Reporter();
    private static List roomSideLengthFunctionRange = new ArrayList();

    public void doGenerateMap(Map map_) {
        this.map = map_;
        this.size = new Dimension(Random.getInt(45, 65), Random.getInt(45, 65));
        this.map.setSize(this.size);
        this.doFillRectangle(new Rectangle(0, 0, this.size.width, this.size.height), Tile.wall);
        ArrayList<Path> paths = new ArrayList<Path>();
        Path mainPath = new Path();
        paths.add(mainPath);
        ArrayList directions = new ArrayList();
        while (!paths.isEmpty()) {
            Path path = (Path)paths.remove(0);
            block1: while (!path.terminated) {
                Point direction;
                Rectangle terminusRectangle;
                Rectangle addition;
                if (path.terminus == null) {
                    this.doCreateTerminus(path);
                }
                this.getLikelyDirectionsFromRectangle(directions, path.terminus.rectangle);
                boolean additionIsHallway = (double)Random.getFloat() < 0.75;
                MapTileLocation doorway = null;
                do {
                    if (directions.isEmpty()) {
                        path.terminated = true;
                        continue block1;
                    }
                    int index = Random.getInt(0, directions.size() - 1);
                    direction = (Point)directions.get(index);
                    directions.remove(index);
                } while (!this.map.getContainsTileRectangle(addition = this.doDetmAdditionRectangle(terminusRectangle = path.terminus.rectangle, direction, additionIsHallway, doorway = this.doDetmDoorwayLocation(terminusRectangle, direction, additionIsHallway))) || !this.map.isRectanglePlusBoundaryAllImpassible(addition));
                if (!path.terminus.checkedForNewPaths) {
                    while (!directions.isEmpty()) {
                        directions.remove(0);
                        Path newPath = new Path();
                        newPath.terminus = new Terminus(path.terminus);
                        newPath.terminus.checkedForNewPaths = true;
                        paths.add(newPath);
                    }
                }
                this.doFillRectangle(addition, additionIsHallway ? Tile.floor : Tile.roomFloor);
                if (!additionIsHallway) {
                    this.doChangeWallsToRoomWalls(addition);
                }
                boolean terminusIsHallway = terminusRectangle.width == 2 || terminusRectangle.height == 2;
                boolean doorwayVertical = direction.x != 0 && direction.y == 0;
                this.doPlaceDoor(doorway, additionIsHallway, terminusIsHallway, doorwayVertical);
                this.reporter.doReport(new SpaceCreated(addition, path.terminus.spaceRectangle, doorway, doorwayVertical));
                path.terminus.rectangle = addition;
                path.terminus.spaceRectangle = new Rectangle(addition);
                path.terminus.checkedForNewPaths = false;
                terminusRectangle = addition;
                if (!additionIsHallway) continue;
                if (direction.x == 1 && direction.y == 0) {
                    terminusRectangle.x += terminusRectangle.width - 2;
                } else if (direction.x == 0 && direction.y == 1) {
                    terminusRectangle.y += terminusRectangle.height - 2;
                }
                terminusRectangle.width = 2;
                terminusRectangle.height = 2;
            }
            if (path != mainPath) continue;
            Terrain downExit = TerrainFactory.doCreateTerrain(TerrainType.downExit);
            this.doAddTerrainToRectangle(downExit, path.terminus.rectangle);
        }
    }

    protected void doChangeWallsToRoomWalls(Rectangle room) {
        int i;
        MapTileLocation location = new MapTileLocation();
        for (i = room.x - 1; i <= room.x + room.width; ++i) {
            location.x = i;
            location.y = room.y - 1;
            if (this.map.getTile(location) == Tile.wall) {
                this.map.setTile(location, Tile.roomWall);
            }
            location.y = room.y + room.height;
            if (this.map.getTile(location) != Tile.wall) continue;
            this.map.setTile(location, Tile.roomWall);
        }
        for (i = room.y; i < room.y + room.height; ++i) {
            location.x = room.x - 1;
            location.y = i;
            if (this.map.getTile(location) == Tile.wall) {
                this.map.setTile(location, Tile.roomWall);
            }
            location.x = room.x + room.width;
            if (this.map.getTile(location) != Tile.wall) continue;
            this.map.setTile(location, Tile.roomWall);
        }
    }

    protected void doPlaceDoor(MapTileLocation doorway, boolean additionIsHallway, boolean terminusIsHallway, boolean down) {
        float chance = Random.getFloat();
        Tile tile = additionIsHallway && terminusIsHallway ? ((double)chance < 0.9 ? Tile.floor : ((double)chance < 0.95 ? Tile.secretDoor : Tile.door)) : ((double)chance < 0.75 ? Tile.door : ((double)chance < 0.85 ? Tile.roomSecretDoor : Tile.floor));
        this.map.setTile(doorway, tile);
        if (down) {
            this.map.setTile(new MapTileLocation(doorway.x, doorway.y + 1), tile);
        } else {
            this.map.setTile(new MapTileLocation(doorway.x + 1, doorway.y), tile);
        }
    }

    protected Rectangle doDetmAdditionRectangle(Rectangle terminus, Point direction, boolean additionIsHallway, Point doorway) {
        Rectangle addition = new Rectangle();
        addition.width = MapGenerator.getRandomRoomSideLength();
        addition.height = MapGenerator.getRandomRoomSideLength();
        if (additionIsHallway) {
            if (direction == null && Random.getBoolean() || direction != null && direction.x != 0 && direction.y == 0) {
                addition.height = 2;
            } else {
                addition.width = 2;
            }
        }
        if (terminus == null) {
            addition.x = Random.getInt(1, this.size.width - addition.width - 2);
            addition.y = Random.getInt(1, this.size.height - addition.height - 2);
        } else {
            if (additionIsHallway) {
                if (direction.x != 0 && direction.y == 0) {
                    addition.y = doorway.y;
                } else {
                    addition.x = doorway.x;
                }
            } else if (direction.x != 0 && direction.y == 0) {
                addition.y = doorway.y - Random.getInt(0, addition.height - 2 - 1);
            } else {
                addition.x = doorway.x - Random.getInt(0, addition.width - 2 - 1);
            }
            if (direction.x == -1 && direction.y == 0) {
                addition.x = terminus.x - 1 - addition.width;
            } else if (direction.x == 1 && direction.y == 0) {
                addition.x = terminus.x + terminus.width + 1;
            } else if (direction.x == 0 && direction.y == -1) {
                addition.y = terminus.y - 1 - addition.height;
            } else if (direction.x == 0 && direction.y == 1) {
                addition.y = terminus.y + terminus.height + 1;
            }
        }
        return addition;
    }

    protected MapTileLocation doDetmDoorwayLocation(Rectangle rectangle, Point direction, boolean isHallway) {
        MapTileLocation doorway = new MapTileLocation(rectangle.x - 1, rectangle.y - 1);
        Point offset = new Point(0, 0);
        if (isHallway) {
            if (direction.x != 0 && direction.y == 0) {
                offset.y = 1;
            } else {
                offset.x = 1;
            }
        } else if (direction.x != 0 && direction.y == 0) {
            offset.y = Random.getInt(1, rectangle.height - 1);
        } else {
            offset.x = Random.getInt(1, rectangle.width - 1);
        }
        if (direction.x == -1 && direction.y == 0) {
            doorway.y += offset.y;
        } else if (direction.x == 1 && direction.y == 0) {
            doorway.x += rectangle.width + 1;
            doorway.y += offset.y;
        } else if (direction.x == 0 && direction.y == -1) {
            doorway.x += offset.x;
        } else if (direction.x == 0 && direction.y == 1) {
            doorway.x += offset.x;
            doorway.y += rectangle.height + 1;
        }
        return doorway;
    }

    protected void doAddTerrainToRectangle(Terrain terrain, Rectangle rectangle) {
        Dimension size = terrain.getSize();
        int x = rectangle.x * TileSize.tileSize.width + size.width / 2 + Random.getInt(0, rectangle.width * TileSize.tileSize.width - size.width - 1);
        int y = rectangle.y * TileSize.tileSize.height + size.height / 2 + Random.getInt(0, rectangle.height * TileSize.tileSize.height - size.height - 1);
        this.map.doAddEntity((MapEntity)terrain, new MapPixelLocation(x, y));
    }

    protected void getLikelyDirectionsFromRectangle(List directions, Rectangle rectangle) {
        directions.clear();
        MapTileLocation location = new MapTileLocation(rectangle.x + rectangle.width / 2, rectangle.y - 2);
        if (rectangle.y >= 5 && !this.map.getTile(new MapTileLocation(location)).isPassible()) {
            directions.add(new Point(0, -1));
        }
        location.setLocation(rectangle.x + rectangle.width / 2, rectangle.y + rectangle.height + 1);
        if (rectangle.y + rectangle.height < this.size.height - 5 && !this.map.getTile(location).isPassible()) {
            directions.add(new Point(0, 1));
        }
        location.setLocation(rectangle.x - 2, rectangle.y + rectangle.height / 2);
        if (rectangle.x >= 5 && !this.map.getTile(location).isPassible()) {
            directions.add(new Point(-1, 0));
        }
        location.setLocation(rectangle.x + rectangle.width + 1, rectangle.y + rectangle.height / 2);
        if (rectangle.x + rectangle.width < this.size.width - 5 && !this.map.getTile(location).isPassible()) {
            directions.add(new Point(1, 0));
        }
    }

    protected void doFillRectangle(Rectangle r, Tile tile) {
        MapTileLocation location = new MapTileLocation();
        for (int i = r.x; i < r.x + r.width; ++i) {
            for (int j = r.y; j < r.y + r.height; ++j) {
                location.setLocation(i, j);
                this.map.setTile(location, tile);
            }
        }
    }

    protected void doCreateTerminus(Path path) {
        path.terminus = new Terminus();
        boolean isHallway = (double)Random.getFloat() < 0.5;
        Rectangle rect = path.terminus.rectangle = this.doDetmAdditionRectangle(null, null, isHallway, null);
        path.terminus.spaceRectangle = new Rectangle(rect);
        this.doFillRectangle(rect, isHallway ? Tile.floor : Tile.roomFloor);
        if (!isHallway) {
            this.doChangeWallsToRoomWalls(rect);
        }
        this.reporter.doReport(new SpaceCreated(rect, null, null, false));
        Terrain upExit = TerrainFactory.doCreateTerrain(TerrainType.upExit);
        this.doAddTerrainToRectangle(upExit, rect);
    }

    public void doAddListener(Listener listener) {
        this.reporter.doAddListener(listener);
    }

    private static void doComputeRoomSideLengthFunction() {
        int[] frequencies = new int[]{5, 5, 5, 5, 5, 4, 3, 3, 2, 2, 1, 1, 1};
        for (int i = 3; i <= 15; ++i) {
            Integer length = new Integer(i);
            for (int j = 0; j < frequencies[i - 3]; ++j) {
                roomSideLengthFunctionRange.add(length);
            }
        }
    }

    private static int getRandomRoomSideLength() {
        Integer length = (Integer)ListUtil.getRandomElement(roomSideLengthFunctionRange);
        return length;
    }

    static {
        MapGenerator.doComputeRoomSideLengthFunction();
    }

    public static class SpaceCreated
    extends Event {
        public Rectangle space;
        public Rectangle fromSpace;
        public MapTileLocation doorway;
        public boolean doorwayVertical;
        public static final EventType spaceCreated = new EventType();

        public SpaceCreated(Rectangle space, Rectangle fromSpace, MapTileLocation doorway, boolean doorwayVertical) {
            this.space = space;
            this.fromSpace = fromSpace;
            this.doorway = doorway;
            this.doorwayVertical = doorwayVertical;
        }

        public EventType getType() {
            return spaceCreated;
        }
    }

    protected static class Terminus {
        public Rectangle rectangle;
        public Rectangle spaceRectangle;
        public boolean checkedForNewPaths = false;

        public Terminus() {
        }

        public Terminus(Terminus terminus) {
            this.rectangle = new Rectangle(terminus.rectangle);
            this.spaceRectangle = new Rectangle(terminus.spaceRectangle != null ? terminus.spaceRectangle : this.rectangle);
        }
    }

    protected static class Path {
        public Terminus terminus;
        public boolean terminated = false;

        protected Path() {
        }
    }
}

