/*
 * Decompiled with CFR 0.152.
 */
package silmar.map.effects;

import java.awt.Dimension;
import java.util.HashMap;
import silmar.entities.MapEntity;
import silmar.util.ImageUtil;

public class VisualEffect
extends MapEntity {
    protected String imageName;
    private static final HashMap sizes = new HashMap();
    private Dimension size;
    private static final Dimension nominalSize = new Dimension(0, 0);

    public VisualEffect(String imageName) {
        this.imageName = imageName;
        if (imageName != null) {
            this.doDetmSize();
        }
    }

    protected String getImageName() {
        return this.imageName;
    }

    public void setImageName(String imageName) {
        this.imageName = imageName;
        this.doDetmSize();
        this.onImageToChange();
        this.map.onEntityChangedAppearance(this);
    }

    public Dimension getSize() {
        return this.size != null ? this.size : nominalSize;
    }

    public boolean isVisualEffect() {
        return true;
    }

    private void doDetmSize() {
        this.size = (Dimension)sizes.get(this.imageName);
        if (this.size == null) {
            this.size = ImageUtil.getSizeWithoutLoading(this.imageName);
            sizes.put(this.imageName, this.size);
        }
    }

    public boolean isVisible() {
        return this.imageName != null;
    }
}

