/*
 * Decompiled with CFR 0.152.
 */
package silmar.map.effects;

import java.util.ArrayList;
import java.util.List;
import silmar.Sound;
import silmar.entities.MapEntity;
import silmar.entities.beings.Being;
import silmar.map.Map;
import silmar.map.MapPixelDistance;
import silmar.map.MapPixelLocation;
import silmar.map.MapPixelLocationUtil;
import silmar.map.MapTileDistance;
import silmar.map.effects.LightSourceVisualEffect;
import silmar.map.effects.VisualEffect;
import silmar.tiles.TileSize;
import silmar.util.ThreadUtil;

public class StunFlash
implements TileSize {
    public static void doFlash(Map map, MapPixelLocation location, int strength, Being emitter) {
        VisualEffect effect;
        map.onGroupOfChangesToOccur();
        MapPixelLocation spot = new MapPixelLocation();
        MapTileDistance range = new MapTileDistance(strength);
        MapPixelDistance pixelDistance = new MapPixelDistance(range.distance * TileSize.tileSize.width);
        ArrayList<VisualEffect> effects = new ArrayList<VisualEffect>();
        String imageName = "flash";
        for (int i = -range.distance; i <= range.distance; ++i) {
            for (int j = -range.distance; j <= range.distance; ++j) {
                spot.move(location.x + i * TileSize.tileSize.width, location.y + j * TileSize.tileSize.height);
                if (!MapPixelLocationUtil.isDistanceAtMost(location, spot, pixelDistance) || !map.getCanSee(location, spot, TileSize.tileSize.width, false, false, null, null)) continue;
                effect = (i + j) % 8 == 0 ? new LightSourceVisualEffect("flash", new MapPixelDistance(new MapTileDistance(2))) : new VisualEffect("flash");
                map.doAddEntity((MapEntity)effect, spot);
                effects.add(effect);
            }
        }
        map.onGroupOfChangesOccurred();
        map.onSoundIssued(Sound.flash, location);
        ThreadUtil.doSleep(100L);
        map.onGroupOfChangesToOccur();
        int numEffects = effects.size();
        for (int i = 0; i < numEffects; ++i) {
            effect = (VisualEffect)effects.get(i);
            map.doRemoveEntity(effect);
        }
        map.onGroupOfChangesOccurred();
        List beings = map.getBeingsInLOSAndRange(location, new MapPixelDistance(strength * TileSize.tileSize.width), null);
        int numBeings = beings.size();
        for (int i = 0; i < numBeings; ++i) {
            Being being = (Being)beings.get(i);
            if (emitter != null && being.equals(emitter)) continue;
            being.onHitByStunFlash(strength);
        }
    }
}

