/*
 * Decompiled with CFR 0.152.
 */
package silmar.map.effects;

import java.util.ArrayList;
import java.util.List;
import silmar.Sound;
import silmar.entities.MapEntity;
import silmar.entities.beings.Being;
import silmar.map.Map;
import silmar.map.MapPixelDistance;
import silmar.map.MapPixelLocation;
import silmar.map.effects.VisualEffect;
import silmar.tiles.TileSize;
import silmar.util.ThreadUtil;

public class RadWave
implements TileSize {
    public static void doWave(Map map, MapPixelLocation location, int strength) {
        map.onSoundIssued(Sound.radWave, location);
        ArrayList<VisualEffect> effects = new ArrayList<VisualEffect>();
        String imageName = "radWave";
        for (int i = 1; i <= strength; ++i) {
            VisualEffect effect;
            int m;
            int k;
            effects.clear();
            map.onGroupOfChangesToOccur();
            for (k = -i; k <= i; ++k) {
                for (m = -1; m <= 1; m += 2) {
                    effect = new VisualEffect("radWave");
                    map.doAddEntity((MapEntity)effect, new MapPixelLocation(location.x + k * TileSize.tileSize.width, location.y + m * i * TileSize.tileSize.height));
                    effects.add(effect);
                }
            }
            for (k = -i + 1; k <= i - 1; ++k) {
                for (m = -1; m <= 1; m += 2) {
                    effect = new VisualEffect("radWave");
                    map.doAddEntity((MapEntity)effect, new MapPixelLocation(location.x + m * i * TileSize.tileSize.width, location.y + k * TileSize.tileSize.height));
                    effects.add(effect);
                }
            }
            map.onGroupOfChangesOccurred();
            ThreadUtil.doSleep(30L);
            map.onGroupOfChangesToOccur();
            int numEffects = effects.size();
            for (int j = 0; j < numEffects; ++j) {
                effect = (VisualEffect)effects.get(j);
                map.doRemoveEntity(effect);
            }
            map.onGroupOfChangesOccurred();
        }
        List beings = map.getBeingsInRange(location, new MapPixelDistance(strength * TileSize.tileSize.width), null);
        int numBeings = beings.size();
        for (int i = 0; i < numBeings; ++i) {
            Being being = (Being)beings.get(i);
            if (being.getContains(location)) continue;
            being.onHitByRadWave(strength);
        }
    }
}

