/*
 * Decompiled with CFR 0.152.
 */
package silmar.map.effects;

import silmar.Sound;
import silmar.entities.MapEntity;
import silmar.map.Map;
import silmar.map.MapPixelDistance;
import silmar.map.MapPixelLocation;
import silmar.map.MapTileDistance;
import silmar.map.effects.LightSourceVisualEffect;
import silmar.util.ThreadUtil;

public class PowerDischarge {
    public static void doDischarge(MapEntity entity) {
        PowerDischarge.doDischarge(entity.getMap(), entity.getLocation());
    }

    public static void doDischarge(Map map, MapPixelLocation location) {
        PowerDischarge.doDischarge(map, location, 0);
    }

    public static void doDischarge(Map map, MapPixelLocation location, int frameDelay) {
        PowerDischarge.doDischarge(map, location, frameDelay, Sound.powerCircle);
    }

    public static void doDischarge(Map map, MapPixelLocation location, int frameDelay, Sound sound) {
        map.onSoundIssued(sound, location);
        if (!map.getPlayersInLOS(location, null).isEmpty()) {
            if (frameDelay == 0) {
                frameDelay = 150;
            }
            LightSourceVisualEffect effect = new LightSourceVisualEffect(null, new MapPixelDistance(new MapTileDistance(8)));
            map.doAddEntity((MapEntity)effect, location);
            for (int i = 1; i <= 5; ++i) {
                effect.setImageName("powerUsed" + i);
                ThreadUtil.doSleep(frameDelay);
            }
            map.doRemoveEntity(effect);
        }
    }
}

