/*
 * Decompiled with CFR 0.152.
 */
package silmar.map.effects;

import java.awt.Dimension;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import silmar.Sound;
import silmar.entities.beings.MovementType;
import silmar.map.Map;
import silmar.map.MapPixelLocation;
import silmar.map.MapTileDistance;
import silmar.map.MapTileLocation;
import silmar.tiles.Tile;
import silmar.tiles.TileSize;
import silmar.tiles.TileSizeUtil;

public class Moat
implements TileSize {
    public static List doForm(Map map, MapTileLocation location, MapTileDistance tileDistance) {
        map.onSoundIssued(Sound.waterAppears, TileSizeUtil.getPixelLocation(location));
        ArrayList<MoatSquare> moat = new ArrayList<MoatSquare>();
        MapTileLocation spot = new MapTileLocation();
        MapPixelLocation pixelSpot = new MapPixelLocation();
        int distance = tileDistance.distance;
        for (int i = -distance; i <= distance; ++i) {
            for (int j = -distance; j <= distance; ++j) {
                if (i != -distance && i != distance && j != -distance && j != distance) continue;
                spot.move(location.x + i, location.y + j);
                Tile tile = map.getTile(spot);
                TileSizeUtil.getPixelLocation(spot, pixelSpot);
                if (tile.getBlocksLOS() || !map.isRectanglePassible((MapPixelLocation)pixelSpot, (Dimension)TileSize.tileSize, (MovementType)MovementType.walking, (boolean)true, null, null, (boolean)false).passible) continue;
                map.setTile(spot, Tile.water);
                MoatSquare square = new MoatSquare(new MapTileLocation(spot), tile);
                moat.add(square);
            }
        }
        return moat;
    }

    public static void remove(Map map, List moat) {
        map.onSoundIssued(Sound.waterDisappears, TileSizeUtil.getPixelLocation(((MoatSquare)moat.get((int)0)).location));
        int numSquares = moat.size();
        for (int i = 0; i < numSquares; ++i) {
            MoatSquare square = (MoatSquare)moat.get(i);
            map.setTile(square.location, square.oldTile);
        }
    }

    private static class MoatSquare
    implements Serializable {
        public MapTileLocation location;
        public Tile oldTile;

        public MoatSquare(MapTileLocation location, Tile oldTile) {
            this.location = location;
            this.oldTile = oldTile;
        }
    }
}

