/*
 * Decompiled with CFR 0.152.
 */
package silmar.map.effects;

import java.util.ArrayList;
import java.util.List;
import silmar.Sound;
import silmar.entities.MapEntity;
import silmar.entities.beings.Being;
import silmar.map.Map;
import silmar.map.MapPixelDistance;
import silmar.map.MapPixelLocation;
import silmar.map.MapPixelLocationUtil;
import silmar.map.MapTileDistance;
import silmar.map.MapUtil;
import silmar.map.effects.LightSourceVisualEffect;
import silmar.map.effects.VisualEffect;
import silmar.tiles.TileSize;
import silmar.util.ThreadUtil;

public class LightningBolt
implements TileSize {
    public static void doBolt(Map map, MapPixelLocation from, MapPixelLocation to, int strength, boolean affectFromLocation) {
        ArrayList<MapPixelLocation> locations = new ArrayList<MapPixelLocation>();
        ArrayList<Being> beings = new ArrayList<Being>();
        if (affectFromLocation) {
            locations.add(from);
            Being being = map.getFirstBeingAt(from);
            if (being != null) {
                beings.add(being);
            }
        }
        int lengthLeft = 12 + strength;
        MapPixelLocation segmentFrom = new MapPixelLocation(from);
        MapPixelLocation segmentTo = new MapPixelLocation(to);
        block0: while (lengthLeft > 0 && !segmentFrom.equals(segmentTo)) {
            List line = MapPixelLocationUtil.getLineLocations(segmentFrom, segmentTo, TileSize.tileSize.width, null, lengthLeft);
            MapPixelLocation previous = segmentFrom;
            int numLocations = line.size();
            for (int i = 0; i < numLocations; ++i) {
                MapPixelLocation location = (MapPixelLocation)line.get(i);
                --lengthLeft;
                if (map.getTile(location).getBlocksLOS()) {
                    segmentTo = MapUtil.getLineBearingAfterCollision(map, segmentFrom, location, previous);
                    segmentFrom = previous;
                    continue block0;
                }
                locations.add(location);
                List beingsAt = map.getBeingsAt(location);
                int numBeingsAt = beingsAt.size();
                for (int j = 0; j < numBeingsAt; ++j) {
                    Being being = (Being)beingsAt.get(j);
                    beings.add(being);
                }
                previous = location;
            }
        }
        map.onSoundIssued(Sound.lightning, from);
        ArrayList<LightSourceVisualEffect> effects = new ArrayList<LightSourceVisualEffect>();
        String imageName = "lightning";
        int numLocations = locations.size();
        for (int i = 0; i < numLocations; ++i) {
            VisualEffect effect = i % 4 == 0 ? new LightSourceVisualEffect("lightning", new MapPixelDistance(new MapTileDistance(4))) : new VisualEffect("lightning");
            effects.add((LightSourceVisualEffect)effect);
        }
        int visibleLength = 5;
        for (int i = 0; i < effects.size() + 5; ++i) {
            int j;
            map.onGroupOfChangesToOccur();
            int first = Math.max(0, i - 5 + 1);
            int last = Math.min(effects.size() - 1, i);
            for (j = first; j <= last; ++j) {
                map.doAddEntity((MapEntity)((VisualEffect)effects.get(j)), (MapPixelLocation)locations.get(j));
            }
            map.onGroupOfChangesOccurred();
            ThreadUtil.doSleep(50L);
            map.onGroupOfChangesToOccur();
            for (j = first; j <= last; ++j) {
                map.doRemoveEntity((VisualEffect)effects.get(j));
            }
        }
        map.onGroupOfChangesOccurred();
        int numBeings = beings.size();
        for (int i = 0; i < numBeings; ++i) {
            Being being = (Being)beings.get(i);
            being.onHitByLightningBolt(strength);
        }
    }
}

