/*
 * Decompiled with CFR 0.152.
 */
package silmar.map.effects;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import silmar.Sound;
import silmar.entities.MapEntity;
import silmar.entities.beings.Being;
import silmar.entities.damage.DamageForm;
import silmar.map.Map;
import silmar.map.MapPixelDistance;
import silmar.map.MapPixelLocation;
import silmar.map.MapPixelLocationUtil;
import silmar.map.MapTileDistance;
import silmar.map.effects.LightSourceVisualEffect;
import silmar.map.effects.VisualEffect;
import silmar.tiles.TileSize;
import silmar.util.ThreadUtil;

public class DragonBreath
implements TileSize {
    public static void doBreath(Map map, MapPixelLocation source, MapPixelLocation target, DamageForm breathType, MapTileDistance range, int strength, int damage, Being sourceBeing) {
        VisualEffect effect;
        List lineThroughTarget = MapPixelLocationUtil.getLineLocations(source, target, TileSize.tileSize.width, new MapPixelDistance(range.distance * TileSize.tileSize.width), 0);
        MapPixelLocation end = (MapPixelLocation)lineThroughTarget.get(lineThroughTarget.size() - 1);
        int radius = 1;
        if (range.distance >= 8) {
            radius = 3;
        } else if (range.distance >= 5) {
            radius = 2;
        }
        ArrayList<List> lines = new ArrayList<List>();
        MapPixelLocation spot = new MapPixelLocation();
        for (int i = -radius; i <= radius; ++i) {
            for (int j = -radius; j <= radius; ++j) {
                spot.move(end.x + i * TileSize.tileSize.width, end.y + j * TileSize.tileSize.height);
                MapPixelDistance distance = MapPixelLocationUtil.getDistance(source, spot);
                if (distance.distance < (range.distance - 1) * TileSize.tileSize.width || distance.distance > (range.distance + 1) * TileSize.tileSize.width) continue;
                lines.add(MapPixelLocationUtil.getLineLocations(source, spot, TileSize.tileSize.width, new MapPixelDistance(range.distance * TileSize.tileSize.width), 0));
            }
        }
        HashMap<MapPixelLocation, MapPixelLocation> visited = new HashMap<MapPixelLocation, MapPixelLocation>();
        ArrayList<MapPixelLocation> coneLocations = new ArrayList<MapPixelLocation>();
        for (int i = 0; i < range.distance; ++i) {
            int numLines = lines.size();
            for (int j = 0; j < numLines; ++j) {
                List line = (List)lines.get(j);
                if (i >= line.size()) continue;
                MapPixelLocation location = (MapPixelLocation)line.get(i);
                if (visited.get(location) == null) {
                    coneLocations.add(location);
                    visited.put(location, location);
                }
                if (!map.getTile(location).getBlocksLOS()) continue;
                line.clear();
            }
        }
        map.onSoundIssued(Sound.dragonBreathed, source);
        map.onGroupOfChangesToOccur();
        String imageName = breathType.equals(DamageForm.acid) ? "acidDragonBreath" : "redDragonBreath";
        ArrayList<LightSourceVisualEffect> effects = new ArrayList<LightSourceVisualEffect>();
        MapPixelLocation lastLocation = null;
        MapPixelDistance newArcIndicatorDistance = new MapPixelDistance(2 * TileSize.tileSize.width);
        int numConeLocations = coneLocations.size();
        for (int i = 0; i < numConeLocations; ++i) {
            MapPixelLocation location = (MapPixelLocation)coneLocations.get(i);
            if (lastLocation != null && !MapPixelLocationUtil.isDistanceAtMost(lastLocation, location, newArcIndicatorDistance)) {
                map.onGroupOfChangesOccurred();
                ThreadUtil.doSleep(30L);
                map.onGroupOfChangesToOccur();
            }
            effect = i % 8 == 0 ? new LightSourceVisualEffect(imageName, new MapPixelDistance(new MapTileDistance(5))) : new VisualEffect(imageName);
            map.doAddEntity((MapEntity)effect, location);
            effects.add((LightSourceVisualEffect)effect);
            lastLocation = location;
        }
        map.onGroupOfChangesOccurred();
        ThreadUtil.doSleep(400L);
        map.onGroupOfChangesToOccur();
        int numEffects = effects.size();
        for (int j = 0; j < numEffects; ++j) {
            effect = (VisualEffect)effects.get(j);
            map.doRemoveEntity(effect);
        }
        map.onGroupOfChangesOccurred();
        ArrayList<Being> hitBeings = new ArrayList<Being>();
        numConeLocations = coneLocations.size();
        for (int i = 0; i < numConeLocations; ++i) {
            MapPixelLocation location = (MapPixelLocation)coneLocations.get(i);
            List beings = map.getBeingsAt(location);
            int numBeings = beings.size();
            for (int j = 0; j < numBeings; ++j) {
                Being being = (Being)beings.get(j);
                if (being == sourceBeing || hitBeings.contains(being)) continue;
                being.onHitByDragonBreath(breathType, strength, damage);
                hitBeings.add(being);
            }
        }
    }
}

