/*
 * Decompiled with CFR 0.152.
 */
package silmar.map.effects;

import silmar.Sound;
import silmar.entities.MapEntity;
import silmar.entities.terrains.TerrainFactory;
import silmar.entities.terrains.TerrainType;
import silmar.entities.terrains.Terrains;
import silmar.map.Map;
import silmar.map.MapPixelLocation;
import silmar.tiles.TileSize;
import silmar.util.FloatPoint;

public class DeathFog
implements TileSize {
    public static void doFog(Map map, MapPixelLocation location, int strength) {
        map.onSoundIssued(Sound.deathFog, location);
        MapPixelLocation spot = new MapPixelLocation();
        int maxRange = 2;
        for (int k = 0; k <= maxRange; ++k) {
            for (int i = -k; i <= k; ++i) {
                for (int j = -k; j <= k; ++j) {
                    if (i != k && i != -k && j != k && j != -k || k == maxRange && (i == k || i == -k) && (j == k || j == -k)) continue;
                    spot.move(location.x + i * TileSize.tileSize.width, location.y + j * TileSize.tileSize.height);
                    if (!map.getContainsLocation(spot)) continue;
                    Terrains.DeathFog fog = (Terrains.DeathFog)TerrainFactory.doCreateTerrain(TerrainType.deathFog);
                    map.doAddEntity((MapEntity)fog, spot);
                    fog.setStrength(strength);
                    if (k == 0) continue;
                    int absI = Math.abs(i);
                    int absJ = Math.abs(j);
                    fog.setDriftDirection(new FloatPoint((float)i / (float)(absI + absJ) * (float)k, (float)j / (float)(absI + absJ) * (float)k));
                }
            }
        }
    }
}

