/*
 * Decompiled with CFR 0.152.
 */
package silmar.map.adjacency;

import java.awt.Rectangle;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import silmar.events.Event;
import silmar.events.Listener;
import silmar.map.Map;
import silmar.map.MapPixelDistance;
import silmar.map.MapPixelLocation;
import silmar.map.MapPixelLocationUtil;
import silmar.map.generation.MapGenerator;
import silmar.tiles.TileSize;
import silmar.tiles.TileSizeUtil;

public final class AdjacencyMap
implements TileSize,
Serializable {
    private Map map;
    private List spaces = new ArrayList();
    private HashMap spacesByRect = new HashMap();
    private MapPixelDistance getPathExists_lastDistance = new MapPixelDistance();

    public AdjacencyMap(Map map, MapGenerator generator) {
        this.map = map;
        generator.doAddListener(new MapGeneratorListener());
    }

    public GetPathExistsResult getPathExists(MapPixelLocation from, MapPixelLocation to, MapPixelDistance maxLength, boolean allowDoors) {
        GetPathExistsResult result = new GetPathExistsResult(false);
        if (!MapPixelLocationUtil.isDistanceAtMost(from, to, maxLength)) {
            return result;
        }
        Space fromSpace = this.getContainingSpace(from);
        Space toSpace = this.getContainingSpace(to);
        if (fromSpace == null || toSpace == null) {
            return result;
        }
        int numSpaces = this.spaces.size();
        for (int i = 0; i < numSpaces; ++i) {
            Space space = (Space)this.spaces.get(i);
            space.searched = false;
        }
        this.getPathExists(fromSpace, toSpace, from, to, maxLength, result, allowDoors);
        return result;
    }

    private void getPathExists(Space from, Space to, MapPixelLocation fromLocation, MapPixelLocation toLocation, MapPixelDistance maxLength, GetPathExistsResult result, boolean allowDoors) {
        MapPixelDistance lastDistance = this.getPathExists_lastDistance;
        int numLinks = from.links.size();
        block0: for (int i = 0; i < numLinks; ++i) {
            Space next;
            Link link = (Link)from.links.get(i);
            if (!allowDoors && link.usesDoors && this.map.getTile(link.intersection1).isDoor() && this.map.getTile(link.intersection2).isDoor()) continue;
            Space space = next = link.space1.equals(from) ? link.space2 : link.space1;
            if (next.searched) continue;
            next.searched = true;
            if (next.equals(to)) {
                MapPixelLocationUtil.getDistance(link.intersection1, toLocation, lastDistance);
                if (lastDistance.distance > maxLength.distance) {
                    return;
                }
                result.pathExists = true;
                result.pathLength.distance += lastDistance.distance;
                return;
            }
            for (int j = 0; j < next.vertices.length; ++j) {
                if (!MapPixelLocationUtil.areOrthogonalDistancesAtMost(fromLocation, next.vertices[j], maxLength)) continue;
                MapPixelDistance distanceToNext = MapPixelLocationUtil.getDistance(fromLocation, next.vertices[j]);
                if (distanceToNext.distance > maxLength.distance) continue;
                this.getPathExists(next, to, next.vertices[j], toLocation, new MapPixelDistance(maxLength.distance - distanceToNext.distance), result, allowDoors);
                if (!result.pathExists) continue block0;
                result.pathLength.distance += distanceToNext.distance;
                return;
            }
        }
    }

    private Space getContainingSpace(MapPixelLocation location) {
        Space space;
        int index;
        int mapPixelWidth = this.map.getSize().width * TileSize.tileSize.width;
        int back = index = (int)((float)location.x / (float)mapPixelWidth * (float)this.spaces.size());
        int forward = index + 1;
        do {
            if (back < 0 && forward >= this.spaces.size()) {
                return null;
            }
            if (back < 0 || !(space = (Space)this.spaces.get(back--)).rect.contains(location)) continue;
            return space;
        } while (forward >= this.spaces.size() || !(space = (Space)this.spaces.get(forward++)).rect.contains(location));
        return space;
    }

    private void doAddSpace(Space space) {
        boolean added = false;
        int numSpaces = this.spaces.size();
        for (int i = 0; i < numSpaces; ++i) {
            Space inList = (Space)this.spaces.get(i);
            if (((Space)space).rect.x >= ((Space)inList).rect.x) continue;
            this.spaces.add(i, space);
            added = true;
            break;
        }
        if (!added) {
            this.spaces.add(space);
        }
    }

    private void doAddOneTileBorder(Rectangle rect) {
        rect.x -= TileSize.tileSize.width;
        rect.y -= TileSize.tileSize.height;
        rect.width += 2 * TileSize.tileSize.width;
        rect.height += 2 * TileSize.tileSize.height;
    }

    private class MapGeneratorListener
    implements Listener {
        private MapGeneratorListener() {
        }

        public void onEvent(Event event) {
            if (event.isOfType(MapGenerator.SpaceCreated.spaceCreated)) {
                MapGenerator.SpaceCreated created = (MapGenerator.SpaceCreated)event;
                Space space = new Space();
                space.setRect(TileSizeUtil.getPixelRectangle(created.space));
                AdjacencyMap.this.doAddOneTileBorder(space.rect);
                AdjacencyMap.this.spacesByRect.put(space.rect, space);
                if (created.fromSpace != null) {
                    MapPixelLocation doorway;
                    Rectangle fromRect = TileSizeUtil.getPixelRectangle(created.fromSpace);
                    AdjacencyMap.this.doAddOneTileBorder(fromRect);
                    Space fromSpace = (Space)AdjacencyMap.this.spacesByRect.get(fromRect);
                    Link link = new Link();
                    link.space1 = space;
                    link.space2 = fromSpace;
                    link.intersection1 = doorway = TileSizeUtil.getPixelLocation(created.doorway);
                    link.intersection2 = new MapPixelLocation(doorway);
                    if (created.doorwayVertical) {
                        link.intersection2.y += TileSize.tileSize.height;
                    } else {
                        link.intersection2.x += TileSize.tileSize.width;
                    }
                    link.usesDoors = AdjacencyMap.this.map.getTile(link.intersection1).isDoor();
                    space.links.add(link);
                    fromSpace.links.add(link);
                }
                AdjacencyMap.this.doAddSpace(space);
            }
        }
    }

    public static class Link
    implements Serializable {
        public Space space1;
        public Space space2;
        public boolean usesDoors;
        public MapPixelLocation intersection1;
        public MapPixelLocation intersection2;
    }

    public static class Space
    implements Serializable {
        public List links = new ArrayList();
        private Rectangle rect = new Rectangle();
        public MapPixelLocation[] vertices = new MapPixelLocation[4];
        private boolean searched;

        public Space() {
            for (int i = 0; i < this.vertices.length; ++i) {
                this.vertices[i] = new MapPixelLocation();
            }
        }

        public void setRect(Rectangle to) {
            this.rect.setBounds(to);
            this.vertices[0].move(this.rect.x, this.rect.y);
            this.vertices[1].move(this.rect.x + this.rect.width, this.rect.y);
            this.vertices[2].move(this.rect.x, this.rect.y + this.rect.height);
            this.vertices[3].move(this.rect.x + this.rect.width, this.rect.y + this.rect.height);
        }
    }

    public static class GetPathExistsResult {
        public boolean pathExists = false;
        public MapPixelDistance pathLength = new MapPixelDistance();

        public GetPathExistsResult(boolean pathExists) {
            this.pathExists = pathExists;
        }
    }
}

