/*
 * Decompiled with CFR 0.152.
 */
package silmar.map;

import silmar.entities.MapEntity;
import silmar.entities.terrains.TerrainFactory;
import silmar.entities.terrains.TerrainType;
import silmar.entities.terrains.Terrains;
import silmar.map.Map;
import silmar.map.MapPixelDistance;
import silmar.map.MapPixelLocation;
import silmar.map.MapTileDistance;

public class MapUtil {
    public static MapPixelLocation getLineBearingAfterCollision(Map map, MapPixelLocation start, MapPixelLocation collision, MapPixelLocation lastReached) {
        if (start.equals(lastReached)) {
            start = new MapPixelLocation(2 * start.x - collision.x, 2 * start.y - collision.y);
        }
        MapPixelLocation bearing = new MapPixelLocation(start);
        MapPixelLocation spot = new MapPixelLocation();
        if (collision.y != lastReached.y) {
            spot.move(collision.x, lastReached.y);
            if (!map.getTile(spot).getBlocksLOS()) {
                bearing.x = lastReached.x - (start.x - lastReached.x);
            }
        }
        if (collision.x != lastReached.x) {
            spot.move(lastReached.x, collision.y);
            if (!map.getTile(spot).getBlocksLOS()) {
                bearing.y = lastReached.y - (start.y - lastReached.y);
            }
        }
        if (bearing.x != start.x && bearing.y != start.y) {
            bearing.setLocation(start);
        }
        return bearing;
    }

    public static Terrains.TempLightSource doAddTempLightSource(Map map, MapPixelLocation location, int tileRange) {
        Terrains.TempLightSource lightSource = (Terrains.TempLightSource)TerrainFactory.doCreateTerrain(TerrainType.tempLightSource);
        lightSource.setLightRadius(new MapPixelDistance(new MapTileDistance(tileRange)));
        map.doAddEntity((MapEntity)lightSource, location);
        return lightSource;
    }
}

