/*
 * Decompiled with CFR 0.152.
 */
package silmar.map;

import java.awt.Image;
import java.util.HashMap;
import silmar.tiles.Tile;
import silmar.util.ImageUtil;

public final class MapMotif {
    private String name;
    private Image[] tileImages;
    private String[] tileImageNames;
    private boolean tech;
    private static HashMap motifsMap = new HashMap();
    private static String[] topsideTileImageNames = new String[]{"ground0", "darkness", "roomFloor0", "roomWall0", "door0", null, null, "openDoor0", null, null, "water", "waterNW", "waterNE", "waterSW", "waterSE", "road", "roadNW", "roadNE", "roadSW", "roadSE", "roomWindow0"};
    private static String[] dungeonATileImageNames = new String[]{"floor11", "wall11", "roomFloor11", "roomWall11", "door11", null, null, "openDoor11", "openSecretDoor11", "openRoomSecretDoor11", "water"};
    private static String[] swampTileImageNames = new String[]{"floor21", "wall21", "roomFloor21", "roomWall21", "door21", null, null, "openDoor21", "openSecretDoor21", "openRoomSecretDoor21", "water", null, null, null, null, null, null, null, null, null, null, "slow21"};
    private static String[] cityTileImageNames = new String[]{"floor31", "wall31", "roomFloor31", "roomWall31", "door31", null, null, "openDoor31", "openSecretDoor31", "openRoomSecretDoor31", "water", null, null, null, null, "road31", null, null, null, null, "roomWindow31"};
    private static String[] dungeonBTileImageNames = new String[]{"floor12", "wall12", "roomFloor12", "roomWall12", "door12", null, null, "openDoor12", "openSecretDoor12", "openRoomSecretDoor12", "water"};
    private static String[] ruinsTileImageNames = new String[]{"floor22", "wall22", "roomFloor22", "roomWall22", "door22", null, null, "openDoor22", "openSecretDoor22", "openRoomSecretDoor22", "water"};
    private static String[] baseTileImageNames = new String[]{"floor32", "wall32", "roomFloor32", "roomWall32", "door32", null, null, "openDoor32", "openSecretDoor32", "openRoomSecretDoor32", "water"};
    private static String[] dungeonCTileImageNames = new String[]{"floor13", "wall13", "roomFloor13", "roomWall13", "door13", null, null, "openDoor13", "openSecretDoor13", "openRoomSecretDoor13", "water"};
    private static String[] daveDungeonTileImageNames = new String[]{"floor23", "wall23", "roomFloor23", "roomWall23", "door23", null, null, "openDoor23", "openSecretDoor23", "openRoomSecretDoor23", "water"};
    private static String[] moonTileImageNames = new String[]{"floor33", "wall33", "roomFloor33", "roomWall33", "door33", null, null, "openDoor33", "openSecretDoor33", "openRoomSecretDoor33", "water"};
    public static MapMotif topside = new MapMotif("topside", topsideTileImageNames, false);
    public static MapMotif dungeonA = new MapMotif("dungeonA", dungeonATileImageNames, false);
    public static MapMotif swamp = new MapMotif("swamp", swampTileImageNames, false);
    public static MapMotif city = new MapMotif("city", cityTileImageNames, true);
    public static MapMotif dungeonB = new MapMotif("dungeonB", dungeonBTileImageNames, false);
    public static MapMotif ruins = new MapMotif("ruins", ruinsTileImageNames, false);
    public static MapMotif base = new MapMotif("base", baseTileImageNames, true);
    public static MapMotif dungeonC = new MapMotif("dungeonC", dungeonCTileImageNames, false);
    public static MapMotif daveDungeon = new MapMotif("daveDungeon", daveDungeonTileImageNames, false);
    public static MapMotif moon = new MapMotif("moon", moonTileImageNames, true);

    public static MapMotif getMotif(String name) {
        return (MapMotif)motifsMap.get(name);
    }

    public MapMotif(String name_, String[] tileImageNames_, boolean tech_) {
        this.name = name_;
        this.tileImageNames = tileImageNames_;
        this.tech = tech_;
        motifsMap.put(this.name, this);
        this.doLoadTileImages();
    }

    protected void doLoadTileImages() {
        this.tileImages = new Image[this.tileImageNames.length];
        for (int i = 0; i < this.tileImageNames.length; ++i) {
            if (this.tileImageNames[i] == null) continue;
            this.tileImages[i] = ImageUtil.doLoadImage("tiles/" + this.tileImageNames[i]);
        }
        this.tileImages[Tile.secretDoor.getIndex()] = this.tileImages[Tile.wall.getIndex()];
        this.tileImages[Tile.roomSecretDoor.getIndex()] = this.tileImages[Tile.roomWall.getIndex()];
    }

    public boolean equals(MapMotif motif) {
        return motif == this || motif.name.equals(this.name);
    }

    public boolean isTech() {
        return this.tech;
    }

    public String getName() {
        return this.name;
    }

    public Image[] getTileImages() {
        return this.tileImages;
    }
}

