/*
 * Decompiled with CFR 0.152.
 */
package silmar.map;

import java.util.ArrayList;
import java.util.List;
import silmar.map.MapMotif;
import silmar.map.loading.MapTranslator;
import silmar.util.Random;

public final class MapLevel {
    private int index;
    private MapMotif motif;
    private String mapFileName;
    private String intro;
    private static List levels = new ArrayList();
    public static MapLevel topside = new MapLevel(MapMotif.topside, "0");
    public static MapLevel dungeonA1 = new MapLevel(MapMotif.dungeonA);
    public static MapLevel dungeonA2 = new MapLevel(MapMotif.dungeonA);
    public static MapLevel dungeonAEnd = new MapLevel(MapMotif.dungeonA, "11e");
    public static MapLevel swamp1 = new MapLevel(MapMotif.swamp);
    public static MapLevel swamp2 = new MapLevel(MapMotif.swamp);
    public static MapLevel swampEnd = new MapLevel(MapMotif.swamp, "21e");
    public static MapLevel city = new MapLevel(MapMotif.city);
    public static MapLevel cityEnd = new MapLevel(MapMotif.city, "31e");
    public static MapLevel dungeonB1 = new MapLevel(MapMotif.dungeonB);
    public static MapLevel dungeonB2 = new MapLevel(MapMotif.dungeonB);
    public static MapLevel dungeonBEnd = new MapLevel(MapMotif.dungeonB, "12e");
    public static MapLevel ruins = new MapLevel(MapMotif.ruins);
    public static MapLevel ruinsEnd = new MapLevel(MapMotif.ruins, "22e");
    public static MapLevel base = new MapLevel(MapMotif.base);
    public static MapLevel baseEnd = new MapLevel(MapMotif.base, "32e");
    public static MapLevel dungeonC = new MapLevel(MapMotif.dungeonC);
    public static MapLevel dungeonCEnd = new MapLevel(MapMotif.dungeonC, "13e");
    public static MapLevel daveDungeon = new MapLevel(MapMotif.daveDungeon);
    public static MapLevel daveDungeonEnd = new MapLevel(MapMotif.daveDungeon, "23e");
    public static MapLevel moon = new MapLevel(MapMotif.moon);
    public static MapLevel moonEnd = new MapLevel(MapMotif.moon, "33e");

    public static MapLevel getLevel(int index) {
        return (MapLevel)levels.get(index);
    }

    public MapLevel(MapMotif motif, String mapFileName) {
        this.motif = motif;
        this.mapFileName = mapFileName;
        levels.add(this);
        this.index = levels.size() - 1;
    }

    public MapLevel(MapMotif motif) {
        this(motif, null);
    }

    public boolean equals(MapLevel level) {
        return level.index == this.index;
    }

    public MapMotif getMotif() {
        return this.motif;
    }

    public String getMapFileName() {
        return this.mapFileName;
    }

    public int getIndex() {
        return this.index;
    }

    public boolean isSelfLit() {
        return this.equals(topside) || this.motif.isTech();
    }

    public int getAverageGoldItemQuantity() {
        return (this.index + 1) * 50;
    }

    public int getMaxItemPlacementValue() {
        return Math.max(this.index, 1) * 1000;
    }

    public int getDamageTrapDamage() {
        return Random.getInt(1, 6 + this.index / 3);
    }

    public int getFireballTrapStrength() {
        return 4 + this.index / 6;
    }

    public int getGasserTrapStrength() {
        return 4 + this.index / 3;
    }

    public int getLightningBoltTrapStrength() {
        return 4 + this.index / 6;
    }

    public String getIntro() {
        return this.intro;
    }

    public boolean isHandsItemsLevel() {
        return this.equals(dungeonBEnd);
    }

    public MapTranslator getMapTranslator() {
        if (this.equals(topside)) {
            return new MapTranslator.TopsideTranslator();
        }
        if (this.equals(dungeonAEnd)) {
            return new MapTranslator.DungeonAEndTranslator();
        }
        if (this.equals(swampEnd)) {
            return new MapTranslator.SwampEndTranslator();
        }
        if (this.equals(cityEnd)) {
            return new MapTranslator.CityEndTranslator();
        }
        if (this.equals(dungeonBEnd)) {
            return new MapTranslator.DungeonBEndTranslator();
        }
        if (this.equals(ruinsEnd)) {
            return new MapTranslator.RuinsEndTranslator();
        }
        if (this.equals(baseEnd)) {
            return new MapTranslator.BaseEndTranslator();
        }
        if (this.equals(dungeonCEnd)) {
            return new MapTranslator.DungeonCEndTranslator();
        }
        if (this.equals(daveDungeonEnd)) {
            return new MapTranslator.DaveDungeonEndTranslator();
        }
        if (this.equals(moonEnd)) {
            return new MapTranslator.MoonEndTranslator();
        }
        return null;
    }

    public boolean isRandomlyGenerated() {
        return this.mapFileName == null;
    }

    static {
        MapLevel.topside.intro = "You arrive at the ruins of the tower.  Makeshift structures house a few brave souls willing to sell their wares to adventurers like yourself...";
        MapLevel.dungeonA1.intro = "The musty, dust-filled air of the dungeons enters your lungs...  If you cannot see, use a torch!";
        MapLevel.swamp1.intro = "You feel an odd sort of queasiness that passes abruptly.  The air becomes far more humid, and it reeks of putrescent gases.  Perhaps you are entering some sort of swamp...";
        MapLevel.city.intro = "Another odd sensation sweeps over you.  Your surroundings come to resemble a strange-looking town that has experienced some sort of catastrophic event, one which affected living things but left structures intact...";
        MapLevel.dungeonB1.intro = "You feel something like a hard tug on your very essence.  The dungeons resume a more normal appearance...";
        MapLevel.ruins.intro = "After another bizarre sense of shifting fades, you arrive in what appears to be the forgotten ruins of an ancient temple...";
        MapLevel.base.intro = "A violent shift sends you to some sort of fortified military complex...";
        MapLevel.dungeonC.intro = "Another tug at your being brings you back to more-familiar dungeon surroundings.  However, you begin to sense the proximity of a very dark presence...";
        MapLevel.daveDungeon.intro = "At this point the dungeon's appearance gains an almost regal elegance that seems very much out of place down here...";
        MapLevel.moon.intro = "A massive, almost paralyzing wave of disorientation passes through you.  The scenery becomes stark and barren, almost otherworldly in its coldness...";
    }
}

