/*
 * Decompiled with CFR 0.152.
 */
package silmar.map;

import java.awt.Dimension;
import java.awt.Rectangle;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import silmar.Sound;
import silmar.entities.LightSource;
import silmar.entities.MapEntity;
import silmar.entities.beings.Being;
import silmar.entities.beings.MovementType;
import silmar.entities.beings.monsters.Monster;
import silmar.entities.beings.monsters.MonsterType;
import silmar.entities.beings.player.Player;
import silmar.entities.items.Item;
import silmar.entities.items.ItemValueContext;
import silmar.entities.talkers.Talker;
import silmar.entities.terrains.Terrain;
import silmar.entities.terrains.TerrainType;
import silmar.entities.terrains.Terrains;
import silmar.entities.terrains.traps.Trap;
import silmar.events.Listener;
import silmar.events.Reporter;
import silmar.map.MapLevel;
import silmar.map.MapMotif;
import silmar.map.MapPixelDistance;
import silmar.map.MapPixelLocation;
import silmar.map.MapPixelLocationUtil;
import silmar.map.MapTileDistance;
import silmar.map.MapTileLocation;
import silmar.map.adjacency.AdjacencyMap;
import silmar.map.events.MapEvent;
import silmar.map.events.MapEvents;
import silmar.map.generation.MapGenerator;
import silmar.map.loading.MapLoader;
import silmar.map.stocking.MapStocker;
import silmar.tiles.Tile;
import silmar.tiles.TileSize;
import silmar.tiles.TileSizeUtil;
import silmar.util.FloatPoint;
import silmar.util.PointUtil;
import silmar.util.Random;

public final class Map
implements TileSize,
Serializable {
    static final long serialVersionUID = -1557247035109217955L;
    private boolean canSeeFailedOnLastStep;
    private final List beings = new ArrayList();
    private final List monsters = new ArrayList();
    private final List items = new ArrayList();
    private final List terrains = new ArrayList();
    private final List traps = new ArrayList();
    private final List players = new ArrayList();
    private final List visualEffects = new ArrayList();
    private final List lightSources = new ArrayList();
    private final Reporter reporter = new Reporter();
    protected transient MapMotif motif;
    protected String motifName;
    protected transient MapLevel level;
    protected int levelIndex;
    protected Dimension size;
    protected final Tiles tiles = new Tiles();
    private boolean inCreation = true;
    private AdjacencyMap adjacencyMap;
    private MapTileLocation getTile_location = new MapTileLocation();
    private MapEvents.EntityPresenceChange doAddEntity_event = new MapEvents.EntityPresenceChange();
    private MapEvents.EntityPresenceChange doMoveEntity_event = new MapEvents.EntityPresenceChange();
    private MapEvents.EntityPresenceChange doRemoveEntity_event = new MapEvents.EntityPresenceChange();
    private List getEntitiesInLOSAndRange_use = new ArrayList();
    private MapPixelLocation isRectanglePassible_location = new MapPixelLocation();
    private IsRectanglePassibleResult isRectanglePassible_result = new IsRectanglePassibleResult();
    private Rectangle getFirstEntityInRectangle_rectangle = new Rectangle();
    private static final GetFirstImpassibleTerrainInRectangleCriterion getFirstImpassibleTerrainInRectangle_criterion = new GetFirstImpassibleTerrainInRectangleCriterion();
    private final GetFirstHarmfulTerrainInRectangleCriterion getFirstHarmfulTerrainInRectangle_criterion = new GetFirstHarmfulTerrainInRectangleCriterion();
    private static final EntityCriterion getFirstMonsterInRectangleCriterion = new EntityCriterion(){

        public boolean isAMatch(MapEntity entity) {
            return entity.isMonster();
        }
    };
    public static final Dimension onePixelRectangle = new Dimension(1, 1);
    private MapPixelLocation getRandomPassibleRectangleLocation_test = new MapPixelLocation();
    private MapPixelLocation getRandomPassibleRectangleLocationInRange_center = new MapPixelLocation();
    private MapPixelLocation getRandomPassibleRectangleLocationInRange_upLeft = new MapPixelLocation();
    private Rectangle getRandomPassibleRectangleLocationInRange_testRect = new Rectangle();
    private FloatPoint isLinePassible_current = new FloatPoint();
    private MapPixelLocation isLinePassible_testRectLocation = new MapPixelLocation();
    private Rectangle isLinePassible_rectangle = new Rectangle();
    private IsLinePassibleResult isLinePassible_result = new IsLinePassibleResult();
    private List onSoundIssued_fromBeings = new ArrayList();
    private MapPixelLocation getNearbyPassibleQuarterTileLocation_location = new MapPixelLocation();
    private MapPixelLocation getCanSeeAnyPartOfRectangle_location = new MapPixelLocation();
    private MapPixelLocation getCanSee_tileCenterFrom = new MapPixelLocation();
    private MapTileLocation getCanSee_tileFrom = new MapTileLocation();
    private MapPixelLocation getCanSee_current = new MapPixelLocation();
    private FloatPoint getCanSee_exact = new FloatPoint();
    private MapPixelLocation isLit_nearestCorner = new MapPixelLocation();
    private MapPixelLocation isLit_pixelLocation = new MapPixelLocation();
    private MapTileLocation isLit_tileLocation = new MapTileLocation();
    private MapPixelDistance isLit_halfLightRadius = new MapPixelDistance();

    public Map(int levelNum) {
        this.level = MapLevel.getLevel(levelNum);
        this.motif = this.level.getMotif();
        String fileName = this.level.getMapFileName();
        if (fileName != null) {
            new MapLoader().doLoadMap(this, "maps/" + fileName, this.level.getMapTranslator());
        } else {
            MapGenerator generator = new MapGenerator();
            this.adjacencyMap = new AdjacencyMap(this, generator);
            generator.doGenerateMap(this);
            MapStocker stocker = new MapStocker();
            stocker.doStockMap(this);
        }
        this.inCreation = false;
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        this.motifName = this.motif.getName();
        this.levelIndex = this.level.getIndex();
        stream.defaultWriteObject();
    }

    private void readObject(ObjectInputStream stream) throws IOException {
        try {
            stream.defaultReadObject();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        this.motif = MapMotif.getMotif(this.motifName);
        this.level = MapLevel.getLevel(this.levelIndex);
    }

    public boolean getContainsLocation(MapTileLocation location) {
        return location.x >= 0 && location.y >= 0 && location.x < this.size.width && location.y < this.size.height;
    }

    public boolean getContainsLocation(MapPixelLocation location) {
        return location.x >= 0 && location.y >= 0 && location.x < this.size.width * TileSize.tileSize.width && location.y < this.size.height * TileSize.tileSize.height;
    }

    public boolean getContainsTileRectangle(Rectangle r) {
        return r.x > 0 && r.y > 0 && r.x + r.width - 1 < this.size.width - 1 && r.y + r.height - 1 < this.size.height - 1;
    }

    public boolean getContainsPixelRectangle(Rectangle r) {
        return r.x > 0 && r.y > 0 && r.x + r.width - 1 < this.size.width * TileSize.tileSize.width - 1 && r.y + r.height - 1 < this.size.height * TileSize.tileSize.height - 1;
    }

    public Tile getTile(MapPixelLocation location) {
        TileSizeUtil.getTileLocation(location, this.getTile_location);
        return this.getTile(this.getTile_location);
    }

    public final Tile getTile(MapTileLocation location) {
        return this.tiles.getTile(location);
    }

    public void setTile(MapPixelLocation location, Tile tile) {
        this.setTile(TileSizeUtil.getTileLocation(location), tile);
    }

    public void setTile(MapTileLocation location, Tile tile) {
        this.tiles.setTile(location, tile);
    }

    public MapTileLocation getTileLocation(Tile tile) {
        return this.tiles.getTileLocation(tile);
    }

    public MapPixelLocation getRandomPixelLocation() {
        int x = Random.getInt(0, this.size.width * TileSize.tileSize.width - 1);
        int y = Random.getInt(0, this.size.height * TileSize.tileSize.height - 1);
        return new MapPixelLocation(x, y);
    }

    public void doAddEntity(MapEntity entity, MapPixelLocation location) {
        List entities = this.beings;
        if (entity.isItem()) {
            entities = this.items;
        } else if (entity.isTerrain()) {
            entities = this.terrains;
            if (entity.isTrap()) {
                this.traps.add(entity);
            }
        } else if (entity.isVisualEffect()) {
            entities = null;
        }
        if (entities != null) {
            entities.add(entity);
        }
        if (entity.isPlayer()) {
            this.players.add(entity);
        }
        if (entity.isMonster()) {
            this.monsters.add(entity);
        }
        if (entity.isLightSource()) {
            this.lightSources.add(entity);
        }
        if (entity.isVisualEffect()) {
            this.visualEffects.add(entity);
        }
        entity.setLocation(location);
        entity.setMap(this);
        if (!this.inCreation) {
            Sound sound = null;
            if (entity.isTerrain()) {
                Terrain terrain = (Terrain)entity;
                TerrainType type = terrain.getType();
                if (type.equals(TerrainType.vengefulSymbol)) {
                    sound = Sound.vengefulSymbol;
                } else if (type.equals(TerrainType.web)) {
                    sound = Sound.web;
                } else if (type.equals(TerrainType.landMine)) {
                    sound = Sound.landMinePlaced;
                } else if (type.equals(TerrainType.brokenVendingMachine)) {
                    sound = Sound.machineBreaks;
                } else if (type.equals(TerrainType.fire)) {
                    sound = Sound.fire;
                } else if (type.equals(TerrainType.downExit)) {
                    sound = Sound.exitAppears;
                }
            } else if (entity.isMonster()) {
                Monster monster = (Monster)entity;
                MonsterType type = monster.getType();
                sound = type.equals(MonsterType.troll) ? Sound.trollBackToLife : Sound.monsterGenerated;
            } else if (entity.isItem()) {
                sound = Sound.itemAdded;
            }
            if (sound != null) {
                this.onSoundIssued(sound, location);
            }
            this.doAddEntity_event.setAll(this, entity);
            this.reporter.doReport(this.doAddEntity_event);
        }
    }

    public void doAddEntity(MapEntity entity, MapTileLocation location) {
        this.doAddEntity(entity, TileSizeUtil.getPixelLocation(location));
    }

    public void doMoveEntity(MapEntity entity, MapPixelLocation location) {
        Tile tile;
        MapPixelLocation oldLocation = entity.getLocation();
        boolean tileChanged = location.x / TileSize.tileSize.width != oldLocation.x / TileSize.tileSize.width || location.y / TileSize.tileSize.height != oldLocation.y / TileSize.tileSize.height;
        entity.setLocation(location);
        this.doMoveEntity_event.setAll(this, entity);
        this.reporter.doReport(this.doMoveEntity_event);
        if (entity.isBeing() && tileChanged && (tile = this.getTile(location)).isDoor() && entity.getMovementType().getAllowsWorkingDoors()) {
            this.setTile(location, tile.getAssociatedOpenDoor());
            this.onSoundIssued(Sound.doorOpens, location, entity.isMonster());
        }
    }

    public void doRemoveEntity(MapEntity entity) {
        MapPixelLocation location = entity.getLocation();
        if (entity.isBeing()) {
            this.beings.remove(entity);
            if (entity.isPlayer()) {
                this.players.remove(entity);
            }
            if (entity.isMonster()) {
                this.monsters.remove(entity);
            }
        } else if (entity.isItem()) {
            this.items.remove(entity);
        } else if (entity.isTerrain()) {
            this.terrains.remove(entity);
            if (entity.isTrap()) {
                this.traps.remove(entity);
            }
        }
        if (entity.isLightSource()) {
            this.lightSources.remove(entity);
        }
        if (entity.isVisualEffect()) {
            this.visualEffects.remove(entity);
        }
        entity.setMap(null);
        Sound sound = null;
        if (entity.isItem()) {
            sound = Sound.itemRemoved;
        }
        if (sound != null) {
            this.onSoundIssued(sound, location);
        }
        this.doRemoveEntity_event.setAll(this, entity);
        this.reporter.doReport(this.doRemoveEntity_event);
    }

    public List getEntitiesInLOS(MapPixelLocation location, List entities, List use) {
        if (use != null) {
            use.clear();
        }
        List inLos = use != null ? use : new ArrayList();
        int numEntities = entities.size();
        for (int i = 0; i < numEntities; ++i) {
            MapEntity entity = (MapEntity)entities.get(i);
            if (!this.getCanSee(location, entity.getLocation(), TileSize.tileSize.width, false, false, null, null)) continue;
            inLos.add(entity);
        }
        return inLos;
    }

    public List getEntitiesInRange(MapPixelLocation location, MapPixelDistance range, List entities, List use) {
        if (use != null) {
            use.clear();
        }
        List inRange = use != null ? use : new ArrayList();
        int numEntities = entities.size();
        for (int i = 0; i < numEntities; ++i) {
            MapEntity entity = (MapEntity)entities.get(i);
            if (!MapPixelLocationUtil.isDistanceAtMost(location, entity.getLocation(), range)) continue;
            inRange.add(entity);
        }
        return inRange;
    }

    public List getEntitiesInLOSAndRange(MapPixelLocation location, MapPixelDistance range, List entities, List use) {
        return this.getEntitiesInLOS(location, this.getEntitiesInRange(location, range, entities, this.getEntitiesInLOSAndRange_use), use);
    }

    public final List getBeings() {
        return this.beings;
    }

    public List getBeingsInLOS(MapPixelLocation location, List use) {
        return this.getEntitiesInLOS(location, this.beings, use);
    }

    public List getBeingsInRange(MapPixelLocation location, MapPixelDistance range, List use) {
        return this.getEntitiesInRange(location, range, this.beings, use);
    }

    public List getBeingsInLOSAndRange(MapPixelLocation location, MapPixelDistance range, List use) {
        return this.getEntitiesInLOSAndRange(location, range, this.beings, use);
    }

    public final List getMonsters() {
        return this.monsters;
    }

    public List getMonstersInLOS(MapPixelLocation location, List use) {
        return this.getEntitiesInLOS(location, this.monsters, use);
    }

    public List getMonstersInRange(MapPixelLocation location, MapPixelDistance range, List use) {
        return this.getEntitiesInRange(location, range, this.monsters, use);
    }

    public List getMonstersInLOSAndRange(MapPixelLocation location, MapPixelDistance range, List use) {
        return this.getEntitiesInLOSAndRange(location, range, this.monsters, use);
    }

    public List getMonstersInPassibleRange(MapPixelLocation location, MapPixelDistance range, List use) {
        List monsters = this.getMonstersInRange(location, range, use);
        if (this.adjacencyMap == null) {
            return monsters;
        }
        for (int i = 0; i < monsters.size(); ++i) {
            Monster monster = (Monster)monsters.get(i);
            if (this.adjacencyMap.getPathExists((MapPixelLocation)location, (MapPixelLocation)monster.getLocation(), (MapPixelDistance)range, (boolean)true).pathExists) continue;
            monsters.remove(i--);
        }
        return monsters;
    }

    public final List getPlayers() {
        return this.players;
    }

    public List getPlayersInLOS(MapPixelLocation location, List use) {
        return this.getEntitiesInLOS(location, this.players, use);
    }

    public List getPlayersInRange(MapPixelLocation location, MapPixelDistance range, List use) {
        return this.getEntitiesInRange(location, range, this.players, use);
    }

    public List getPlayersInLOSAndRange(MapPixelLocation location, MapPixelDistance range, List use) {
        return this.getEntitiesInLOSAndRange(location, range, this.players, use);
    }

    public final List getItems() {
        return this.items;
    }

    public List getItemsInRange(MapPixelLocation location, MapPixelDistance range, List use) {
        return this.getEntitiesInRange(location, range, this.items, use);
    }

    public final List getTerrains() {
        return this.terrains;
    }

    public List getTerrainsInLOS(MapPixelLocation location, List use) {
        return this.getEntitiesInLOS(location, this.terrains, use);
    }

    public List getTerrainsInRange(MapPixelLocation location, MapPixelDistance range, List use) {
        return this.getEntitiesInRange(location, range, this.terrains, use);
    }

    public int getMovementCost(MapPixelLocation location) {
        return this.getTile(location).getMovementCost();
    }

    public IsRectanglePassibleResult isRectanglePassible(MapPixelLocation location, Dimension size, MovementType movementType, boolean checkForBeing, MapEntity forEntity, MapEntity forEntity2, boolean checkForHarmfulTerrains) {
        IsRectanglePassibleResult result = this.isRectanglePassible_result;
        result.doInit();
        MapPixelLocation test = this.isRectanglePassible_location;
        int upperLeftX = location.x - size.width / 2;
        int upperLeftY = location.y - size.height / 2;
        for (int i = 0; i < size.width; i += Math.max(1, Math.min(size.width - i - 1, TileSize.tileSize.width))) {
            for (int j = 0; j < size.height; j += Math.max(1, Math.min(size.height - j - 1, TileSize.tileSize.height))) {
                test.x = upperLeftX + i;
                test.y = upperLeftY + j;
                if (this.getTile(test).isPassible(movementType)) continue;
                return result;
            }
        }
        if (checkForBeing && this.getFirstEntityInRectangle(location, size, this.beings, null, forEntity, forEntity2) != null) {
            return result;
        }
        if (checkForHarmfulTerrains && this.getFirstHarmfulTerrainInRectangle(location, size, (Monster)forEntity) != null) {
            result.harmful = true;
            return result;
        }
        if (this.getFirstImpassibleTerrainInRectangle(location, size, movementType) != null) {
            return result;
        }
        result.passible = true;
        return result;
    }

    public boolean isRectanglePlusBoundaryAllImpassible(Rectangle rectangle) {
        MapTileLocation location = new MapTileLocation();
        for (int i = rectangle.x - 1; i <= rectangle.x + rectangle.width; ++i) {
            for (int j = rectangle.y - 1; j <= rectangle.y + rectangle.height; ++j) {
                location.setLocation(i, j);
                if (!this.getTile(location).isPassible()) continue;
                return false;
            }
        }
        return true;
    }

    public void doCloseDoor(MapPixelLocation location, boolean issueSoundToMonsters) {
        Tile tile = this.getTile(location);
        if (tile.isOpenDoor()) {
            this.setTile(location, tile.getAssociatedDoor());
            this.onSoundIssued(Sound.doorCloses, location, !issueSoundToMonsters);
        }
    }

    public final MapLevel getLevel() {
        return this.level;
    }

    public void setSize(Dimension size) {
        this.size = size;
        this.tiles.setSize(size);
    }

    protected MapEntity getFirstEntityAt(MapPixelLocation location, List entities) {
        return this.getFirstEntityAt(location, entities, null);
    }

    protected MapEntity getFirstEntityAt(MapPixelLocation location, List entities, EntityCriterion criterion) {
        return this.getFirstEntityAt(location, entities, criterion, null);
    }

    protected MapEntity getFirstEntityAt(MapPixelLocation location, List entities, EntityCriterion criterion, MapEntity ignore) {
        int numEntities = entities.size();
        for (int i = 0; i < numEntities; ++i) {
            MapEntity entity = (MapEntity)entities.get(i);
            if (entity.equals(ignore) || criterion != null && !criterion.isAMatch(entity) || !entity.getContains(location)) continue;
            return entity;
        }
        return null;
    }

    public Being getFirstBeingAt(MapPixelLocation location) {
        return (Being)this.getFirstEntityAt(location, this.beings);
    }

    public Player getFirstPlayerAt(MapPixelLocation location) {
        return (Player)this.getFirstEntityAt(location, this.players);
    }

    public Monster getFirstMonsterAt(MapPixelLocation location) {
        return (Monster)this.getFirstEntityAt(location, this.monsters);
    }

    public Item getFirstItemAt(MapPixelLocation location) {
        return (Item)this.getFirstEntityAt(location, this.items);
    }

    public Terrain getFirstTerrainAt(MapPixelLocation location) {
        return (Terrain)this.getFirstEntityAt(location, this.terrains);
    }

    public Trap getFirstTrapAt(MapPixelLocation location) {
        return (Trap)this.getFirstEntityAt(location, this.getTraps());
    }

    public Talker getFirstTalkerAt(MapPixelLocation location) {
        EntityCriterion criterion = new EntityCriterion(){

            public boolean isAMatch(MapEntity entity) {
                return entity instanceof Talker;
            }
        };
        MapEntity entity = this.getFirstEntityAt(location, this.beings, criterion);
        if (entity != null) {
            return (Talker)((Object)entity);
        }
        return (Talker)((Object)this.getFirstEntityAt(location, this.terrains, criterion));
    }

    protected MapEntity getFirstEntityInRectangle(MapPixelLocation location, Dimension size, List entities, EntityCriterion criterion) {
        return this.getFirstEntityInRectangle(location, size, entities, criterion, null, null);
    }

    protected MapEntity getFirstEntityInRectangle(MapPixelLocation location, Dimension size, List entities, EntityCriterion criterion, MapEntity ignore, MapEntity ignore2) {
        Rectangle rectangle = this.getFirstEntityInRectangle_rectangle;
        rectangle.setLocation(location.x - size.width / 2, location.y - size.height / 2);
        rectangle.setSize(size);
        int numEntities = entities.size();
        for (int i = 0; i < numEntities; ++i) {
            MapEntity entity = (MapEntity)entities.get(i);
            if (entity == ignore || entity == ignore2 || criterion != null && !criterion.isAMatch(entity) || !rectangle.intersects(entity.getImpassibleBounds())) continue;
            return entity;
        }
        return null;
    }

    public Terrain getFirstImpassibleTerrainInRectangle(MapPixelLocation location, Dimension size, MovementType movementType) {
        Map.getFirstImpassibleTerrainInRectangle_criterion.movementType = movementType;
        return (Terrain)this.getFirstEntityInRectangle(location, size, this.terrains, getFirstImpassibleTerrainInRectangle_criterion);
    }

    public Terrain getFirstHarmfulTerrainInRectangle(MapPixelLocation location, Dimension size, Monster toMonster) {
        this.getFirstHarmfulTerrainInRectangle_criterion.toMonster = toMonster;
        return (Terrain)this.getFirstEntityInRectangle(location, size, this.terrains, this.getFirstHarmfulTerrainInRectangle_criterion);
    }

    public Monster getFirstMonsterInRectangle(MapPixelLocation location, Dimension size) {
        return (Monster)this.getFirstEntityInRectangle(location, size, this.beings, getFirstMonsterInRectangleCriterion);
    }

    public void doAddListener(Listener listener) {
        this.reporter.doAddListener(listener);
    }

    public MapPixelLocation getNearbyPassibleRectangleLocation(MapPixelLocation location, Dimension size, MovementType movementType) {
        return this.getNearbyPassibleRectangleLocation(location, size, movementType, MapPixelDistance.maxValue);
    }

    public MapPixelLocation getNearbyPassibleRectangleLocation(MapPixelLocation location, Dimension size, MovementType movementType, MapPixelDistance searchRange) {
        MapPixelLocation test = new MapPixelLocation();
        Rectangle testRect = new Rectangle(size);
        for (int range = 0; range <= searchRange.distance; range += TileSize.tileSize.width) {
            for (int i = 0; i < (range == 0 ? 1 : range / 2); ++i) {
                test.move(location.x + Random.getInt(-range, range), location.y + Random.getInt(-range, range));
                testRect.setLocation(test);
                if (!this.getContainsPixelRectangle(testRect) || !this.isRectanglePassible((MapPixelLocation)test, (Dimension)size, (MovementType)movementType, (boolean)true, null, null, (boolean)false).passible) continue;
                return test;
            }
        }
        return null;
    }

    public Player getNearestPlayer(MapPixelLocation location) {
        return this.getNearestPlayer(location, false);
    }

    public Player getNearestPlayerInLOS(MapPixelLocation location) {
        return this.getNearestPlayer(location, true);
    }

    protected Player getNearestPlayer(MapPixelLocation location, boolean inLOS) {
        if (this.players.size() == 1) {
            Player player = (Player)this.players.get(0);
            return !inLOS || this.getCanSee(location, player.getLocation(), TileSize.tileSize.width, false, false, null, null) ? player : null;
        }
        Player nearest = null;
        MapPixelDistance minDistance = new MapPixelDistance(Integer.MAX_VALUE);
        int numPlayers = this.players.size();
        for (int i = 0; i < numPlayers; ++i) {
            Player player = (Player)this.players.get(i);
            MapPixelLocation playerLocation = player.getLocation();
            MapPixelDistance distance = MapPixelLocationUtil.getDistance(location, playerLocation);
            if (distance.distance >= minDistance.distance || inLOS && !this.getCanSee(location, playerLocation, TileSize.tileSize.width, false, false, null, null)) continue;
            nearest = player;
            minDistance.distance = distance.distance;
        }
        return nearest;
    }

    public MapPixelLocation getRandomPassibleRectangleLocation(Dimension rectSize) {
        MapPixelLocation test = this.getRandomPassibleRectangleLocation_test;
        for (int i = 0; i < 1000; ++i) {
            test.setLocation(Random.getInt(0, this.size.width * TileSize.tileSize.width - 1 - rectSize.width), Random.getInt(0, this.size.height * TileSize.tileSize.height - 1 - rectSize.height));
            if (!this.isRectanglePassible((MapPixelLocation)test, (Dimension)rectSize, (MovementType)MovementType.walking, (boolean)true, null, null, (boolean)false).passible) continue;
            return test;
        }
        return null;
    }

    public MapPixelLocation getRandomPassibleRectangleLocationInRange(MapPixelLocation location, Dimension rectSize, MapPixelDistance range, int numTries, MovementType movementType, boolean checkForBeing) {
        MapPixelLocation center = this.getRandomPassibleRectangleLocationInRange_center;
        MapPixelLocation upLeft = this.getRandomPassibleRectangleLocationInRange_upLeft;
        Rectangle testRect = this.getRandomPassibleRectangleLocationInRange_testRect;
        testRect.setSize(rectSize);
        for (int i = 0; i < numTries; ++i) {
            int distance = range.distance;
            center.setLocation(location.x + Random.getInt(-distance, distance), location.y + Random.getInt(-distance, distance));
            upLeft.setLocation(center.x - rectSize.width / 2, center.y - rectSize.height / 2);
            testRect.setLocation(upLeft);
            if (!this.getContainsPixelRectangle(testRect) || !this.isRectanglePassible((MapPixelLocation)center, (Dimension)Map.onePixelRectangle, (MovementType)movementType, (boolean)checkForBeing, null, null, (boolean)false).passible) continue;
            if (!this.isRectanglePassible((MapPixelLocation)center, (Dimension)rectSize, (MovementType)movementType, (boolean)checkForBeing, null, null, (boolean)false).passible) {
                MapPixelLocation nearby = this.getNearbyPassibleQuarterTileLocation(center, rectSize, movementType, null, null);
                if (nearby == null) continue;
                return nearby;
            }
            return center;
        }
        return null;
    }

    public MapPixelLocation getRandomPassibleRectangleLocationNotInLOS(MapPixelLocation rangeFrom, MapPixelLocation losFrom, Dimension rectSize, MapPixelDistance range, int numTries, MovementType movementType, boolean checkForBeing) {
        return this.getRandomPassibleRectangleLocationUsingLOSAndRange(rangeFrom, losFrom, rectSize, false, range, numTries, movementType, checkForBeing);
    }

    public MapPixelLocation getRandomPassibleRectangleLocationInLOSAndRange(MapPixelLocation location, Dimension rectSize, MapPixelDistance range, int numTries, MovementType movementType, boolean checkForBeing) {
        return this.getRandomPassibleRectangleLocationUsingLOSAndRange(location, location, rectSize, true, range, numTries, movementType, checkForBeing);
    }

    protected MapPixelLocation getRandomPassibleRectangleLocationUsingLOSAndRange(MapPixelLocation rangeFrom, MapPixelLocation losFrom, Dimension rectSize, boolean inLOS, MapPixelDistance range, int numTries, MovementType movementType, boolean checkForBeing) {
        MapPixelLocation test;
        for (int i = 0; i < numTries && (test = this.getRandomPassibleRectangleLocationInRange(rangeFrom, rectSize, range, numTries, movementType, checkForBeing)) != null; ++i) {
            if (this.getCanSee(losFrom, test, TileSize.tileSize.width, false, false, null, null) != inLOS) continue;
            return test;
        }
        return null;
    }

    public List getLocationsOfTilesInLOSAndRange(List tiles, MapPixelLocation location, MapTileDistance range) {
        return this.getLocationsOfTilesInRange(tiles, location, range, true);
    }

    public List getLocationsOfTilesInRange(List tiles, MapPixelLocation location, MapTileDistance range, boolean inLOS) {
        MapPixelLocation test = new MapPixelLocation();
        ArrayList<MapPixelLocation> found = new ArrayList<MapPixelLocation>();
        int distance = range.distance;
        for (int i = -distance; i <= distance; ++i) {
            block1: for (int j = -distance; j <= distance; ++j) {
                test.move(location.x + i * TileSize.tileSize.width, location.y + j * TileSize.tileSize.height);
                if (!this.getContainsLocation(test)) continue;
                if (inLOS) {
                    TileSizeUtil.getNearestTileCorner(test, location, test);
                    if (!this.getCanSee(location, test, TileSize.tileSize.width, false, false, null, null) && !this.getCanSeeFailedOnLastStep()) continue;
                }
                Tile tile = this.getTile(test);
                int numTiles = tiles.size();
                for (int k = 0; k < numTiles; ++k) {
                    if (!tile.equals((Tile)tiles.get(k))) continue;
                    found.add(TileSizeUtil.getPixelLocation(TileSizeUtil.getTileLocation(test)));
                    continue block1;
                }
            }
        }
        return found;
    }

    public Item getNearestItem(MapPixelLocation location, int minValue) {
        ArrayList<Item> items = new ArrayList<Item>(this.getItems());
        int numTerrains = this.terrains.size();
        for (int i = 0; i < numTerrains; ++i) {
            Terrains.Chest chest;
            Item item;
            Terrain terrain = (Terrain)this.terrains.get(i);
            if (!terrain.isOfType(TerrainType.chest) || (item = (chest = (Terrains.Chest)terrain).getItem()) == null) continue;
            items.add(item);
        }
        MapPixelDistance minDistance = new MapPixelDistance(Integer.MAX_VALUE);
        Item nearest = null;
        int numItems = items.size();
        for (int i = 0; i < numItems; ++i) {
            Item item = (Item)items.get(i);
            if (item.getValue(ItemValueContext.placement) < minValue) continue;
            MapPixelDistance distance = MapPixelLocationUtil.getDistance(location, item.getLocation());
            if (distance.distance >= minDistance.distance) continue;
            nearest = item;
            minDistance.distance = distance.distance;
        }
        return nearest;
    }

    public List getTrapsInLOS(MapPixelLocation location, List use) {
        return this.getEntitiesInLOS(location, this.traps, use);
    }

    public List getTrapsInRange(MapPixelLocation location, MapPixelDistance range, List use) {
        return this.getEntitiesInRange(location, range, this.traps, use);
    }

    public final List getTraps() {
        return this.traps;
    }

    public Terrain getTerrainOfType(TerrainType type) {
        int numTerrains = this.terrains.size();
        for (int i = 0; i < numTerrains; ++i) {
            Terrain terrain = (Terrain)this.terrains.get(i);
            if (!terrain.isOfType(type)) continue;
            return terrain;
        }
        return null;
    }

    public final Dimension getSize() {
        return this.size;
    }

    public final MapMotif getMotif() {
        return this.motif;
    }

    public List getEntitiesAt(MapPixelLocation location, List entities, List use) {
        if (use != null) {
            use.clear();
        }
        List at = use != null ? use : new ArrayList();
        int numEntities = entities.size();
        for (int i = 0; i < numEntities; ++i) {
            MapEntity entity = (MapEntity)entities.get(i);
            if (!entity.getContains(location)) continue;
            at.add(entity);
        }
        return at;
    }

    public List getBeingsAt(MapPixelLocation location) {
        return this.getEntitiesAt(location, this.beings, null);
    }

    public IsLinePassibleResult isLinePassible(MapPixelLocation from, MapPixelLocation to, MovementType movementType, Dimension moverSize, MapEntity fromEntity, MapEntity toEntity, boolean checkForHarmfulTerrains) {
        IsLinePassibleResult result = this.isLinePassible_result;
        result.doInit();
        FloatPoint direction = PointUtil.getUnitVector(from, to);
        int pixelsPerStep = 4;
        direction.x *= 4.0f;
        direction.y *= 4.0f;
        int numSteps = (int)Math.floor(MapPixelLocationUtil.getDistance((MapPixelLocation)from, (MapPixelLocation)to).distance / 4);
        FloatPoint current = this.isLinePassible_current;
        current.setLocation(from.x, from.y);
        MapPixelLocation testRectLocation = this.isLinePassible_testRectLocation;
        for (int i = 0; i < numSteps; ++i) {
            current.x += direction.x;
            current.y += direction.y;
            testRectLocation.setLocation(Math.round(current.x), Math.round(current.y));
            IsRectanglePassibleResult rectangleResult = this.isRectanglePassible(testRectLocation, moverSize, movementType, true, fromEntity, toEntity, checkForHarmfulTerrains);
            if (checkForHarmfulTerrains && rectangleResult.harmful) {
                result.harmful = true;
                return result;
            }
            if (rectangleResult.passible) continue;
            Rectangle rectangle = this.isLinePassible_rectangle;
            rectangle.setLocation(testRectLocation);
            rectangle.x -= moverSize.width / 2;
            rectangle.y -= moverSize.height / 2;
            rectangle.setSize(moverSize);
            result.passible = toEntity != null && toEntity.getBounds().intersects(rectangle);
            return result;
        }
        result.passible = true;
        return result;
    }

    public void doEmitEvent(MapEvent event) {
        this.reporter.doReport(event);
    }

    public void onSoundIssued(Sound sound, MapPixelLocation location) {
        this.onSoundIssued(sound, location, false);
    }

    public void onSoundIssued(Sound sound, MapPixelLocation location, boolean forPlayersOnly) {
        List beings = forPlayersOnly ? this.getPlayers() : this.getBeings();
        MapPixelDistance range = sound.getRange();
        boolean listReused = this.onSoundIssued_fromBeings.isEmpty();
        beings = this.getEntitiesInRange(location, range, beings, listReused ? this.onSoundIssued_fromBeings : null);
        int numBeings = beings.size();
        for (int i = 0; i < numBeings; ++i) {
            Being being = (Being)beings.get(i);
            MapPixelLocation beingLocation = being.getLocation();
            MapPixelDistance distance = null;
            if (!this.level.isRandomlyGenerated() || this.getCanSee(location, beingLocation, TileSize.tileSize.width, false, false, null, null)) {
                distance = MapPixelLocationUtil.getDistance(location, beingLocation);
            } else {
                if (this.adjacencyMap == null) continue;
                AdjacencyMap.GetPathExistsResult result = this.adjacencyMap.getPathExists(location, beingLocation, range, false);
                if (!result.pathExists) continue;
                distance = result.pathLength;
            }
            being.onSoundHeard(sound, location, distance);
        }
        if (listReused) {
            this.onSoundIssued_fromBeings.clear();
        }
    }

    public void onEntityChangedAppearance(MapEntity entity) {
        this.reporter.doReport(new MapEvents.EntityChangedAppearance(this));
    }

    public MapPixelLocation getNearbyPassibleQuarterTileLocation(MapPixelLocation location, Dimension size, MovementType movementType, MapEntity forEntity, MapEntity toEntity) {
        boolean leftXCloser;
        int quarterTileWidth = TileSize.tileSize.width / 2;
        int quarterTileHeight = TileSize.tileSize.height / 2;
        int coveringQuarterTileX = location.x - location.x % quarterTileWidth;
        int coveringQuarterTileY = location.y - location.y % quarterTileHeight;
        MapPixelLocation test = this.getNearbyPassibleQuarterTileLocation_location;
        boolean bl = toEntity != null ? toEntity.getLocation().x < location.x : (leftXCloser = location.x % quarterTileWidth < quarterTileWidth / 2);
        boolean topYCloser = toEntity != null ? toEntity.getLocation().y < location.y : location.y % quarterTileHeight < quarterTileHeight / 2;
        int closerX = coveringQuarterTileX + (leftXCloser ? 0 : quarterTileWidth);
        int closerY = coveringQuarterTileY + (topYCloser ? 0 : quarterTileHeight);
        int furtherX = coveringQuarterTileX + (!leftXCloser ? 0 : quarterTileWidth);
        int furtherY = coveringQuarterTileY + (!topYCloser ? 0 : quarterTileHeight);
        for (int i = 0; i <= 4; ++i) {
            switch (i) {
                case 0: {
                    test.setLocation(closerX, closerY);
                    break;
                }
                case 1: {
                    test.setLocation(closerX, furtherY);
                    break;
                }
                case 2: {
                    test.setLocation(furtherX, closerY);
                    break;
                }
                case 3: {
                    test.setLocation(furtherX, furtherY);
                }
            }
            if (!this.isRectanglePassible((MapPixelLocation)test, (Dimension)size, (MovementType)movementType, (boolean)true, (MapEntity)forEntity, (MapEntity)toEntity, (boolean)false).passible || !this.isLinePassible((MapPixelLocation)location, (MapPixelLocation)test, (MovementType)movementType, (Dimension)size, (MapEntity)forEntity, (MapEntity)toEntity, (boolean)false).passible) continue;
            return new MapPixelLocation(test);
        }
        return null;
    }

    public boolean getCanSeeAnyPartOfRectangle(MapPixelLocation from, MapPixelLocation to, Dimension rectangleSize) {
        this.getCanSeeAnyPartOfRectangle_location.setLocation(to);
        to = this.getCanSeeAnyPartOfRectangle_location;
        if (this.getCanSee(from, to, TileSize.tileSize.width, false, false, null, null)) {
            return true;
        }
        int x = to.x;
        int y = to.y;
        int halfWidth = rectangleSize.width / 2;
        int halfHeight = rectangleSize.height / 2;
        to.x = x - halfWidth;
        to.y = y - halfHeight;
        if (this.getCanSee(from, to, TileSize.tileSize.width, false, false, null, null)) {
            return true;
        }
        to.x = x + halfWidth;
        to.y = y + halfHeight;
        if (this.getCanSee(from, to, TileSize.tileSize.width, false, false, null, null)) {
            return true;
        }
        to.x = x - halfWidth;
        to.y = y + halfHeight;
        if (this.getCanSee(from, to, TileSize.tileSize.width, false, false, null, null)) {
            return true;
        }
        to.x = x + halfWidth;
        to.y = y - halfHeight;
        return this.getCanSee(from, to, TileSize.tileSize.width, false, false, null, null);
    }

    public boolean getCanSee(MapPixelLocation from, MapPixelLocation to, int pixelsPerStep, boolean adjustFromToTileCenter, boolean beingsBlockLOS, MapEntity fromEntity, MapEntity toEntity) {
        if (adjustFromToTileCenter) {
            TileSizeUtil.getTileLocation(from, this.getCanSee_tileFrom);
            TileSizeUtil.getPixelLocation(this.getCanSee_tileFrom, this.getCanSee_tileCenterFrom);
            from = this.getCanSee_tileCenterFrom;
        }
        FloatPoint direction = PointUtil.getUnitVector(from, to);
        direction.x *= (float)pixelsPerStep;
        direction.y *= (float)pixelsPerStep;
        int numSteps = MapPixelLocationUtil.getDistance((MapPixelLocation)from, (MapPixelLocation)to).distance / pixelsPerStep;
        FloatPoint exact = this.getCanSee_exact;
        exact.setLocation(from.x, from.y);
        MapPixelLocation current = this.getCanSee_current;
        for (int i = 0; i < numSteps; ++i) {
            exact.x += direction.x;
            exact.y += direction.y;
            current.x = Math.round(exact.x);
            current.y = Math.round(exact.y);
            if (i == numSteps - 1 && current.equals(to)) {
                return true;
            }
            if (!this.getBlocksLOS(current, beingsBlockLOS, fromEntity, toEntity)) continue;
            this.canSeeFailedOnLastStep = i >= numSteps - 1;
            return false;
        }
        return true;
    }

    public boolean getCanSeeFailedOnLastStep() {
        return this.canSeeFailedOnLastStep;
    }

    public boolean getBlocksLOS(MapPixelLocation location, boolean beingsBlockLOS, MapEntity ignore1, MapEntity ignore2) {
        Being being;
        if (this.getTile(location).getBlocksLOS()) {
            return true;
        }
        return beingsBlockLOS && (being = this.getFirstBeingAt(location)) != null && being != ignore1 && being != ignore2;
    }

    public AdjacencyMap getAdjacencyMap() {
        return this.adjacencyMap;
    }

    public List getEntitiesInRectangle(MapPixelLocation location, Dimension size, List entities, EntityCriterion criterion, MapEntity ignore, MapEntity ignore2, List use) {
        if (use != null) {
            use.clear();
        }
        List inRect = use != null ? use : new ArrayList();
        Rectangle rectangle = new Rectangle(location.x - size.width / 2, location.y - size.height / 2, size.width, size.height);
        int numEntities = entities.size();
        for (int i = 0; i < numEntities; ++i) {
            MapEntity entity = (MapEntity)entities.get(i);
            if (entity == ignore || entity == ignore2 || criterion != null && !criterion.isAMatch(entity) || !rectangle.intersects(entity.getImpassibleBounds())) continue;
            inRect.add(entity);
        }
        return inRect;
    }

    public boolean isTerrainOfTypeInRectangle(TerrainType type, MapPixelLocation location, Dimension size) {
        List terrains = this.getEntitiesInRectangle(location, size, this.getTerrains(), null, null, null, null);
        int numTerrains = terrains.size();
        for (int i = 0; i < numTerrains; ++i) {
            Terrain terrain = (Terrain)terrains.get(i);
            if (!terrain.isOfType(type)) continue;
            return true;
        }
        return false;
    }

    public void onGroupOfChangesToOccur() {
        this.reporter.doReport(new MapEvents.GroupOfChangesToOccur(this));
    }

    public void onGroupOfChangesOccurred() {
        this.reporter.doReport(new MapEvents.GroupOfChangesOccurred(this));
    }

    public IsLitResult isLit(MapPixelLocation location, MapPixelLocation viewpoint, LightSource inLosLightSource, MapEntity toEntity, IsLitResult result) {
        result.doInit();
        if (this.level.isSelfLit()) {
            result.fullyLit = true;
            result.halfLit = true;
            return result;
        }
        if (inLosLightSource != null && !this.lightSources.isEmpty() && this.lightSources.get(0) != inLosLightSource) {
            this.lightSources.remove(inLosLightSource);
            this.lightSources.add(0, inLosLightSource);
        }
        result.fullyLit = false;
        result.halfLit = false;
        int numLightSources = this.lightSources.size();
        for (int i = 0; i < numLightSources; ++i) {
            LightSource source = (LightSource)this.lightSources.get(i);
            if (!source.isEmittingLight()) continue;
            TileSizeUtil.getTileLocation(source.getLocation(), this.isLit_tileLocation);
            TileSizeUtil.getPixelLocation(this.isLit_tileLocation, this.isLit_pixelLocation);
            MapPixelLocation sourceLocation = this.isLit_pixelLocation;
            MapPixelDistance lightRadius = source.getLightRadius();
            if (!MapPixelLocationUtil.isDistanceAtMost(sourceLocation, location, lightRadius) || source != inLosLightSource && !this.getCanSee(sourceLocation, TileSizeUtil.getNearestTileCorner(location, sourceLocation, this.isLit_nearestCorner), TileSize.tileSize.width, true, false, null, null) || source != inLosLightSource && this.getTile(location).getBlocksLOS() && !this.getCanSee(viewpoint, sourceLocation, TileSize.tileSize.width, true, false, null, null)) continue;
            this.isLit_halfLightRadius.distance = source.getLightRadius().distance * 2 / 3;
            boolean fullyLit = MapPixelLocationUtil.isDistanceAtMost(sourceLocation, location, this.isLit_halfLightRadius);
            if (fullyLit || result.halfLit) {
                result.fullyLit = true;
            }
            result.halfLit = true;
            if (!result.fullyLit) continue;
            return result;
        }
        if (toEntity.isPlayer() && ((Player)toEntity).isUsingNightVision()) {
            result.halfLit = true;
        }
        return result;
    }

    public final List getVisualEffects() {
        return this.visualEffects;
    }

    public final List getLightSources() {
        return this.lightSources;
    }

    public static final class IsLitResult
    implements Serializable {
        public boolean fullyLit;
        public boolean halfLit;

        public void doInit() {
            this.fullyLit = false;
            this.halfLit = false;
        }
    }

    public static class IsLinePassibleResult
    implements Serializable {
        public boolean passible;
        public boolean harmful;

        public void doInit() {
            this.passible = false;
            this.harmful = false;
        }
    }

    private static final class GetFirstHarmfulTerrainInRectangleCriterion
    implements EntityCriterion,
    Serializable {
        private Monster toMonster;

        private GetFirstHarmfulTerrainInRectangleCriterion() {
        }

        public boolean isAMatch(MapEntity entity) {
            return ((Terrain)entity).isHarmfulTo(this.toMonster);
        }
    }

    private static final class GetFirstImpassibleTerrainInRectangleCriterion
    implements EntityCriterion {
        public MovementType movementType;

        private GetFirstImpassibleTerrainInRectangleCriterion() {
        }

        public boolean isAMatch(MapEntity entity) {
            return !((Terrain)entity).isPassible(this.movementType);
        }
    }

    protected static interface EntityCriterion {
        public boolean isAMatch(MapEntity var1);
    }

    public static class IsRectanglePassibleResult
    implements Serializable {
        public boolean passible;
        public boolean harmful;

        public void doInit() {
            this.passible = false;
            this.harmful = false;
        }
    }

    protected final class Tiles
    implements Serializable {
        private Tile[][] tiles;
        private MapEvents.TileChanged setTile_event = new MapEvents.TileChanged();

        protected Tiles() {
        }

        public Tile getTile(MapTileLocation location) {
            if (!Map.this.getContainsLocation(location)) {
                return Tile.wall;
            }
            return this.tiles[location.x][location.y];
        }

        public void setTile(MapTileLocation location, Tile tile) {
            if (!Map.this.getContainsLocation(location)) {
                return;
            }
            this.tiles[location.x][location.y] = tile;
            this.setTile_event.setAll(Map.this, location, tile);
            Map.this.reporter.doReport(this.setTile_event);
        }

        public void setSize(Dimension size) {
            this.tiles = new Tile[size.width][size.height];
        }

        public MapTileLocation getTileLocation(Tile tile) {
            for (int i = 0; i < Map.this.size.width; ++i) {
                for (int j = 0; j < Map.this.size.height; ++j) {
                    if (!this.tiles[i][j].equals(tile)) continue;
                    return new MapTileLocation(i, j);
                }
            }
            return null;
        }
    }
}

