/*
 * Decompiled with CFR 0.152.
 */
package silmar.gui.tooltips;

import java.awt.Dimension;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.event.MouseInputAdapter;
import silmar.gui.tooltips.HasTooltip;
import silmar.gui.tooltips.Tooltip;
import silmar.util.ThreadUtil;

public final class TooltipManager {
    private static TooltipManager sharedInstance = new TooltipManager();
    private MouseListener mouseListener = new MouseListener();
    private Tooltip tooltip = new Tooltip();
    private ShowTooltipThread showTooltipThread = new ShowTooltipThread();

    private TooltipManager() {
        this.showTooltipThread.start();
    }

    public void doRegisterComponent(JComponent comp) {
        comp.addMouseListener(this.mouseListener);
        comp.addMouseMotionListener(this.mouseListener);
    }

    public static TooltipManager getSharedInstance() {
        return sharedInstance;
    }

    public void doRefreshTooltip() {
        if (this.tooltip.isShowing()) {
            this.tooltip.setVisible(false);
            this.showTooltipThread.doRefreshTooltip();
        }
    }

    private class ShowTooltipThread
    extends Thread {
        private HasTooltip hasTooltip;
        private boolean countingDownToShow = false;
        private long countdownStart;

        private ShowTooltipThread() {
        }

        public void run() {
            while (true) {
                if (this.countingDownToShow && System.currentTimeMillis() - this.countdownStart >= 500L) {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            TooltipManager.this.tooltip.setText(hasTooltip.getHasTooltipImpl().getTooltipText());
                            TooltipManager.this.tooltip.pack();
                            JComponent comp = (JComponent)((Object)hasTooltip);
                            if (!comp.isShowing()) {
                                return;
                            }
                            Point location = comp.getLocationOnScreen();
                            Dimension compSize = comp.getSize();
                            GraphicsEnvironment env = GraphicsEnvironment.getLocalGraphicsEnvironment();
                            Rectangle screenBounds = env.getMaximumWindowBounds();
                            int x = location.x + (location.x + compSize.width + TooltipManager.this.tooltip.getWidth() < screenBounds.width ? compSize.width : -TooltipManager.this.tooltip.getWidth());
                            int y = location.y + (location.y + compSize.height + TooltipManager.this.tooltip.getHeight() < screenBounds.height ? compSize.height : -TooltipManager.this.tooltip.getHeight());
                            TooltipManager.this.tooltip.setLocation(x, y);
                            TooltipManager.this.tooltip.setVisible(true);
                            TooltipManager.this.tooltip.toFront();
                            countingDownToShow = false;
                        }
                    });
                }
                ThreadUtil.doSleep(100L);
            }
        }

        public void doCountdownToShow(HasTooltip hasTooltip) {
            this.hasTooltip = hasTooltip;
            this.countingDownToShow = true;
            this.countdownStart = System.currentTimeMillis();
        }

        public void doAbortShow() {
            this.countingDownToShow = false;
        }

        public void doRefreshTooltip() {
            if (this.hasTooltip != null) {
                this.hasTooltip.doUpdateTooltip();
                this.doCountdownToShow(this.hasTooltip);
            }
        }
    }

    private class MouseListener
    extends MouseInputAdapter {
        private MouseListener() {
        }

        public void mouseEntered(MouseEvent e) {
            HasTooltip hasTooltip = (HasTooltip)e.getSource();
            if (hasTooltip.getHasTooltipImpl().getTooltipText() != null) {
                TooltipManager.this.showTooltipThread.doCountdownToShow(hasTooltip);
            }
        }

        public void mouseExited(MouseEvent e) {
            String text = ((HasTooltip)e.getSource()).getHasTooltipImpl().getTooltipText();
            if (text != null) {
                if (TooltipManager.this.tooltip.isVisible()) {
                    TooltipManager.this.tooltip.setVisible(false);
                }
                TooltipManager.this.showTooltipThread.doAbortShow();
            }
        }
    }
}

