/*
 * Decompiled with CFR 0.152.
 */
package silmar.gui.dialogs;

import java.awt.Color;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import silmar.gui.Fonts;
import silmar.gui.widgets.Button;
import silmar.gui.widgets.Label;
import silmar.util.WindowUtil;

public class OkCancelDialog
extends JDialog {
    private boolean cancelled = false;

    public OkCancelDialog(Dialog parent, String message) {
        super(parent);
        this.doBuild(message);
    }

    public OkCancelDialog(Frame parent, String message) {
        super(parent);
        this.doBuild(message);
    }

    public OkCancelDialog(String message) {
        this.doBuild(message);
    }

    private void doBuild(String message) {
        this.setModal(true);
        Container pane = this.getContentPane();
        JPanel panel = new JPanel();
        pane.add(panel);
        panel.setLayout(new BoxLayout(panel, 1));
        panel.setBorder(new EmptyBorder(10, 10, 10, 10));
        panel.setBackground(Color.black);
        this.setDefaultCloseOperation(2);
        Label label = new Label(message, Fonts.mediumPlus);
        panel.add(label);
        panel.add(Box.createRigidArea(new Dimension(0, 10)));
        panel.add(Box.createVerticalGlue());
        JPanel buttonsPanel = new JPanel();
        buttonsPanel.setOpaque(false);
        buttonsPanel.setLayout(new BoxLayout(buttonsPanel, 0));
        panel.add(buttonsPanel);
        Button button = new Button(" Ok ");
        buttonsPanel.add(button);
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                OkCancelDialog.this.setVisible(false);
            }
        });
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                OkCancelDialog.this.cancelled = true;
            }
        });
        buttonsPanel.add(Box.createRigidArea(new Dimension(5, 0)));
        button = new Button(" Cancel ");
        buttonsPanel.add(button);
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                OkCancelDialog.this.cancelled = true;
                OkCancelDialog.this.setVisible(false);
            }
        });
        this.pack();
        WindowUtil.doCenterWindow(this);
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    public static boolean doShow(String message) {
        return OkCancelDialog.doShow(null, null, message);
    }

    public static boolean doShow(Dialog parent, String message) {
        return OkCancelDialog.doShow(null, parent, message);
    }

    public static boolean doShow(Frame parent, String message) {
        return OkCancelDialog.doShow(parent, null, message);
    }

    public static boolean doShow(Frame frameParent, Dialog dialogParent, String message) {
        message = "<html><p style='color:white;text-align:center'>" + message;
        OkCancelDialog dialog = frameParent != null ? new OkCancelDialog(frameParent, message) : (dialogParent != null ? new OkCancelDialog(dialogParent, message) : new OkCancelDialog(message));
        dialog.setVisible(true);
        return dialog.isCancelled();
    }
}

