/*
 * Decompiled with CFR 0.152.
 */
package silmar.gui.dialogs;

import java.awt.Color;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import silmar.gui.Fonts;
import silmar.gui.widgets.Button;
import silmar.gui.widgets.Label;
import silmar.util.HtmlUtil;
import silmar.util.WindowUtil;

public class MessageDialog
extends JDialog {
    protected Label label;

    public MessageDialog(Dialog parent, String message) {
        super(parent);
        this.doBuild(message, true);
    }

    public MessageDialog(Frame parent, String message) {
        super(parent);
        this.doBuild(message, true);
    }

    public MessageDialog(Frame parent, String message, boolean mayClose) {
        super(parent);
        this.doBuild(message, mayClose);
    }

    public MessageDialog(String message) {
        this.doBuild(message, true);
    }

    private void doBuild(String message, boolean mayClose) {
        this.setModal(true);
        Container pane = this.getContentPane();
        JPanel panel = new JPanel();
        pane.add(panel);
        panel.setLayout(new BoxLayout(panel, 1));
        panel.setBorder(new EmptyBorder(10, 10, 10, 10));
        panel.setBackground(Color.black);
        this.setDefaultCloseOperation(mayClose ? 2 : 0);
        message = HtmlUtil.doBreakText(message, 50);
        this.label = new Label("<html><p style='color:white;text-align:center'>" + message, Fonts.mediumPlus);
        panel.add(this.label);
        panel.add(Box.createRigidArea(new Dimension(0, 5)));
        if (mayClose) {
            panel.add(Box.createRigidArea(new Dimension(0, 15)));
            Button button = new Button(" Ok ");
            panel.add(button);
            button.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent event) {
                    MessageDialog.this.setVisible(false);
                }
            });
        }
        this.pack();
        WindowUtil.doCenterWindow(this);
    }

    public static void doShow(String message) {
        MessageDialog.doShow(null, null, message);
    }

    public static void doShow(Frame parent, String message) {
        MessageDialog.doShow(parent, null, message);
    }

    public static void doShow(Dialog parent, String message) {
        MessageDialog.doShow(null, parent, message);
    }

    public static void doShow(Frame frameParent, Dialog dialogParent, String message) {
        MessageDialog dialog = frameParent != null ? new MessageDialog(frameParent, message) : (dialogParent != null ? new MessageDialog(dialogParent, message) : new MessageDialog(message));
        dialog.setVisible(true);
    }
}

