/*
 * Decompiled with CFR 0.152.
 */
package silmar.gui.dialogs;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import silmar.client.Images;
import silmar.gui.Fonts;
import silmar.gui.widgets.Button;
import silmar.gui.widgets.HeadingLabel;
import silmar.util.ComponentUtil;
import silmar.util.ThreadUtil;
import silmar.util.WindowUtil;

public class InputStringPanel
extends JPanel {
    private JTextField textField;
    private String inputString;

    public InputStringPanel(String message) {
        this.setLayout(new BorderLayout());
        this.setBackground(Color.black);
        JPanel panel = new JPanel();
        panel.setBorder(new EmptyBorder(5, 5, 5, 5));
        panel.setOpaque(false);
        panel.setLayout(new BoxLayout(panel, 1));
        this.add((Component)panel, "Center");
        HeadingLabel label = new HeadingLabel(message);
        panel.add((Component)label);
        panel.add(Box.createRigidArea(new Dimension(0, 10)));
        JPanel panel1 = new JPanel();
        panel1.setOpaque(false);
        panel.add(panel1);
        final JTextField field = this.textField = new JTextField(10);
        field.setHorizontalAlignment(0);
        field.setFont(Fonts.heading);
        panel1.add(field);
        field.addKeyListener(new KeyAdapter(){

            public void keyTyped(KeyEvent e) {
                if (e.getKeyChar() == '\n') {
                    InputStringPanel.this.onTextEntered();
                }
            }
        });
        panel.add(Box.createRigidArea(new Dimension(0, 10)));
        panel.add(Box.createVerticalGlue());
        Button button = new Button(" Ok ");
        panel.add(button);
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                InputStringPanel.this.onTextEntered();
            }
        });
        panel.add(Box.createRigidArea(new Dimension(0, 10)));
        this.addComponentListener(new ComponentAdapter(){

            public void componentShown(ComponentEvent e) {
                field.requestFocus();
            }
        });
    }

    private void onTextEntered() {
        this.inputString = this.textField.getText();
        ComponentUtil.getParentFrame(this).setVisible(false);
    }

    public String getInputString() {
        return this.inputString;
    }

    public static class Frame
    extends JFrame {
        private InputStringPanel inputStringPanel;

        public Frame(String message) {
            super("Silmar");
            this.setIconImage(Images.iconImage);
            this.setSize(300, 170);
            this.setResizable(false);
            WindowUtil.doCenterWindow(this);
            this.inputStringPanel = new InputStringPanel(message);
            this.getContentPane().add(this.inputStringPanel);
            this.setDefaultCloseOperation(0);
        }

        public InputStringPanel getInputStringPanel() {
            return this.inputStringPanel;
        }

        public static String doShow(String message) {
            Frame frame = new Frame(message);
            frame.setVisible(true);
            while (frame.isVisible()) {
                ThreadUtil.doSleep(100L);
            }
            return frame.getInputStringPanel().getInputString();
        }
    }

    public static class Dialog
    extends JDialog {
        private InputStringPanel inputStringPanel;

        public Dialog(JFrame parent, String message) {
            super((java.awt.Frame)parent, "Silmar");
            this.setModal(true);
            this.setSize(300, 170);
            this.setResizable(false);
            WindowUtil.doCenterWindow(this);
            this.inputStringPanel = new InputStringPanel(message);
            this.getContentPane().add(this.inputStringPanel);
            this.setDefaultCloseOperation(0);
        }

        public InputStringPanel getInputStringPanel() {
            return this.inputStringPanel;
        }

        public static String doShow(JFrame parent, String message) {
            Dialog dialog = new Dialog(parent, message);
            dialog.setVisible(true);
            return dialog.getInputStringPanel().getInputString();
        }
    }
}

