/*
 * Decompiled with CFR 0.152.
 */
package silmar.game;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import silmar.entities.MapEntity;
import silmar.entities.beings.Being;
import silmar.entities.beings.player.Player;
import silmar.entities.items.Item;
import silmar.entities.items.types.ItemType;
import silmar.entities.terrains.Terrain;
import silmar.entities.terrains.TerrainType;
import silmar.events.Listener;
import silmar.events.Reporter;
import silmar.map.Map;
import silmar.map.MapPixelLocation;
import silmar.tiles.TileSize;
import silmar.util.FileUtil;
import silmar.util.ThreadUtil;

public final class Game
implements Serializable,
TileSize {
    private static Game currentGame;
    private List maps = new ArrayList();
    private List players = new ArrayList();
    private int turn;
    private String name;
    private boolean gameDone;
    private HashMap itemTypesIdentified = new HashMap();
    private int numPlayersFinishedTurn;
    private boolean readyForNextTurn;
    private Reporter reporter = new Reporter();
    private HashMap playerToDungeonLevelReached = new HashMap();

    public Game(String name) {
        this.name = name;
        currentGame = this;
    }

    public boolean doSave() {
        try {
            FileOutputStream fileStream = new FileOutputStream(this.name);
            ObjectOutputStream objectStream = new ObjectOutputStream(fileStream);
            objectStream.writeObject(this);
            objectStream.flush();
            objectStream.close();
            fileStream.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public int getTurn() {
        return this.turn;
    }

    public void onPlayerAtDownExit(Player player) {
        Map map = player.getMap();
        if (map.getLevel().getIndex() == this.maps.size() - 1) {
            String temp = this.name;
            this.name = this.name + "_end";
            this.doSave();
            this.name = temp;
            this.doCreateLevel();
        }
        map.doRemoveEntity(player);
        map = (Map)this.maps.get(this.maps.indexOf(map) + 1);
        Terrain upExit = map.getTerrainOfType(TerrainType.upExit);
        MapPixelLocation location = map.getNearbyPassibleRectangleLocation(upExit.getLocation(), player.getSize(), player.getMovementType());
        map.doAddEntity((MapEntity)player, location);
        this.onPlayerAtMap(player, map);
        player.onMessage("Saving your progress...");
        boolean saved = this.doSave();
        if (saved) {
            FileUtil.doCopyFile(this.name, this.name + "_copy");
            player.onMessage("Your progress has been saved.");
        } else {
            player.onMessage("Your progress could not be saved!  Please contact the author.", Player.MessageType.important);
        }
    }

    public void onPlayerAtUpExit(Player player) {
        Map map = player.getMap();
        map.doRemoveEntity(player);
        map = (Map)this.maps.get(this.maps.indexOf(map) - 1);
        Terrain downExit = map.getTerrainOfType(TerrainType.downExit);
        MapPixelLocation location = map.getNearbyPassibleRectangleLocation(downExit.getLocation(), player.getSize(), player.getMovementType());
        map.doAddEntity((MapEntity)player, location);
    }

    public void onPlayerAtMap(Player player, Map map) {
        Integer levelReached = (Integer)this.playerToDungeonLevelReached.get(player);
        int levelNum = map.getLevel().getIndex();
        if (levelReached != null && levelReached >= levelNum) {
            return;
        }
        this.playerToDungeonLevelReached.put(player, new Integer(levelNum));
        String intro = map.getLevel().getIntro();
        if (intro != null) {
            player.onMessage(intro, Player.MessageType.important);
        }
    }

    protected void doCreateLevel() {
        int levelNum = this.maps.size();
        Map map = new Map(levelNum);
        this.maps.add(map);
    }

    protected void onStartOfTurn() {
        int i;
        ++this.turn;
        this.numPlayersFinishedTurn = 0;
        int numPlayers = this.players.size();
        for (int i2 = 0; i2 < numPlayers; ++i2) {
            Player player = (Player)this.players.get(i2);
            if (!player.isDead()) continue;
            ++this.numPlayersFinishedTurn;
        }
        List maps = this.getPlayerOccupiedMaps();
        int numMaps = maps.size();
        for (i = 0; i < numMaps; ++i) {
            Map map = (Map)maps.get(i);
            List terrains = map.getTerrains();
            for (int j = 0; j < terrains.size(); ++j) {
                Terrain terrain = (Terrain)terrains.get(j);
                terrain.doAct();
            }
            List beings = map.getBeings();
            for (int j = 0; j < beings.size(); ++j) {
                Being being = (Being)beings.get(j);
                if (being.isPlayer()) continue;
                being.doAct();
                being.onTurnOver();
            }
            List items = map.getItems();
            for (int j = 0; j < items.size(); ++j) {
                Item item = (Item)items.get(j);
                item.doAct();
            }
        }
        for (i = 0; i < this.players.size(); ++i) {
            Player player = (Player)this.players.get(i);
            if (player.isDead()) continue;
            player.doAct();
            player.onTurnOver();
        }
    }

    public Player getPlayer() {
        return (Player)this.players.get(0);
    }

    private void doProcessGameTurns() {
        try {
            int sleepTime = 100;
            while (!this.gameDone) {
                try {
                    this.readyForNextTurn = false;
                    this.onStartOfTurn();
                    while (!this.readyForNextTurn && !this.gameDone) {
                        if (this.readyForNextTurn) continue;
                        ThreadUtil.doSleep(100L);
                    }
                }
                catch (Exception e) {
                    if (e instanceof Stop) {
                        throw (Stop)e;
                    }
                    e.printStackTrace();
                }
            }
        }
        catch (Stop stop) {
            // empty catch block
        }
    }

    public List getMaps() {
        return this.maps;
    }

    public List getPlayerOccupiedMaps() {
        ArrayList<Map> maps = new ArrayList<Map>();
        int numPlayers = this.players.size();
        for (int i = 0; i < numPlayers; ++i) {
            Player player = (Player)this.players.get(i);
            Map map = player.getMap();
            if (maps.contains(map)) continue;
            maps.add(map);
        }
        return maps;
    }

    public List getPlayers() {
        return this.players;
    }

    public boolean isItemTypeIdentified(ItemType type) {
        return type.getUnidentifiedName() == null || this.itemTypesIdentified.get(type.getName()) != null;
    }

    public void onItemTypeIdentified(ItemType type) {
        this.itemTypesIdentified.put(type.getName(), type.getName());
    }

    public void onStopping() {
        this.gameDone = true;
        if (Thread.currentThread().getName().equals("Silmar game thread")) {
            throw new Stop();
        }
    }

    public void onFinished() {
        this.gameDone = true;
    }

    public Map getMap(int levelIndex) {
        return (Map)this.maps.get(levelIndex);
    }

    public void onPlayerHasFinishedTurn() {
        ++this.numPlayersFinishedTurn;
        if (this.numPlayersFinishedTurn >= this.players.size()) {
            this.readyForNextTurn = true;
            this.numPlayersFinishedTurn = 0;
        }
    }

    public void onBeginning() {
        this.doCreateLevel();
    }

    public void onPlayerAdded(Player player) {
        this.players.add(player);
    }

    public void onStarting() {
        this.doProcessGameTurns();
    }

    public void onBeginningLevelSpecified(int levelNum) {
        for (int i = 0; i < levelNum; ++i) {
            this.maps.add(null);
        }
    }

    public int getFurthestLevelReachedByPlayer(Player player) {
        HashMap reached = this.playerToDungeonLevelReached;
        Integer reachedInt = (Integer)reached.get(player);
        return reachedInt != null ? reachedInt : 0;
    }

    public int getFurthestLevelReached() {
        return this.maps.size() - 1;
    }

    public void doAddListener(Listener listener) {
        this.reporter.doAddListener(listener);
    }

    public static Game getCurrentGame() {
        return currentGame;
    }

    public static void setCurrentGame(Game currentGame) {
        Game.currentGame = currentGame;
    }

    public void setName(String name) {
        this.name = name;
    }

    private class Stop
    extends RuntimeException {
        private Stop() {
        }
    }
}

