/*
 * Decompiled with CFR 0.152.
 */
package silmar.entities.terrains.traps;

import silmar.entities.beings.BeingUtil;
import silmar.entities.beings.player.Player;
import silmar.entities.damage.Damage;
import silmar.entities.damage.DamageForm;
import silmar.entities.terrains.traps.Trap;
import silmar.map.MapPixelLocation;
import silmar.map.effects.DeathFog;
import silmar.map.effects.Fireball;
import silmar.map.effects.LightningBolt;
import silmar.tiles.TileSize;
import silmar.util.Random;

public class Traps {

    public static class LightningBoltTrap
    extends Trap {
        protected void doSpring(Player player) {
            MapPixelLocation from = this.location;
            MapPixelLocation to = new MapPixelLocation(from.x + (Random.getBoolean() ? TileSize.tileSize.width : -TileSize.tileSize.width), from.y + (Random.getBoolean() ? TileSize.tileSize.height : -TileSize.tileSize.height));
            LightningBolt.doBolt(this.map, from, to, this.map.getLevel().getLightningBoltTrapStrength(), true);
        }
    }

    public static class GustOfWindTrap
    extends Trap {
        protected void doSpring(Player player) {
            player.onGustOfWindTrap();
        }
    }

    public static class GasserTrap
    extends Trap {
        protected void doSpring(Player player) {
            DeathFog.doFog(this.map, this.location, this.map.getLevel().getGasserTrapStrength());
        }
    }

    public static class TeleportTrap
    extends Trap {
        protected void doSpring(Player player) {
            BeingUtil.doTeleportRandomlyWithinMap(player, this.getMap());
        }
    }

    public static class FireballTrap
    extends Trap {
        protected void doSpring(Player player) {
            Fireball.doFireball(this.map, null, this.location, this.map.getLevel().getFireballTrapStrength());
        }
    }

    public static class DamageTrap
    extends Trap {
        protected void doSpring(Player player) {
            player.doTakeDamage(new Damage(this.getMap().getLevel().getDamageTrapDamage(), DamageForm.bluntImpact));
        }
    }
}

