/*
 * Decompiled with CFR 0.152.
 */
package silmar.entities.terrains.traps;

import silmar.Sound;
import silmar.entities.beings.Being;
import silmar.entities.beings.player.Player;
import silmar.entities.terrains.Terrain;
import silmar.entities.terrains.Terrains;

public class Trap
extends Terrain {
    private boolean detected = false;
    private Terrains.Chest chest;

    public void doAttemptToSpring(Player player) {
        if (!this.detected || !player.getDisarmsTrap(this)) {
            this.map.onSoundIssued(Sound.trapSprung, this.location);
            player.onMessage("You sprung a trap!");
            this.doSpring(player);
        }
        this.map.doRemoveEntity(this);
    }

    protected void doSpring(Player player) {
    }

    public String getImageName() {
        return this.isDetected() ? "detectedTrap" : super.getImageName();
    }

    public boolean isVisible() {
        return this.isDetected();
    }

    public boolean isDetected() {
        return this.detected;
    }

    public void onDetected() {
        this.detected = true;
        this.map.onSoundIssued(Sound.trapDetected, this.location);
        this.onImageToChange();
        this.map.onEntityChangedAppearance(this);
    }

    public boolean onBeingArrival(Being being) {
        if (!being.isPlayer() || this.chest != null) {
            return false;
        }
        this.doAttemptToSpring((Player)being);
        return true;
    }

    public Terrains.Chest getChest() {
        return this.chest;
    }

    public void setChest(Terrains.Chest chest) {
        this.chest = chest;
    }

    public boolean isTrap() {
        return true;
    }

    public boolean onInteractionWithPlayer(Player player) {
        this.doAttemptToSpring(player);
        return false;
    }
}

