/*
 * Decompiled with CFR 0.152.
 */
package silmar.entities.terrains;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import silmar.entities.MapEntity;
import silmar.entities.terrains.TerrainFactory;
import silmar.entities.types.EntityType;
import silmar.map.Map;
import silmar.map.MapLevel;
import silmar.map.MapPixelLocation;
import silmar.tiles.Tile;

public final class TerrainType
extends EntityType {
    private int avoidance;
    private static final int indestructible = -100;
    private boolean passible;
    private boolean firesPlayerAtEvents;
    private boolean trap;
    private boolean talks;
    private boolean sells;
    private boolean fixes;
    public static List types = new ArrayList();
    public static HashMap typesMap = new HashMap();
    public static List trapTypes = new ArrayList();
    public static List nonTrapTypes = new ArrayList();
    public static TerrainType mapEdgeBarrier = new TerrainType("map edge", null, false, 0, false, false, -100);
    public static TerrainType monsterActivator = new TerrainType("monster activator", null, true, 0, false, false, -100);
    public static TerrainType eventMarker = new TerrainType("event marker", null, true, 0, false, false, -100);
    public static TerrainType tempLightSource = new TerrainType("", null, true, 0, false, false, -100);
    public static TerrainType summoner = new TerrainType("summoner", null, true, 0, false, false, -100);
    public static TerrainType radiation = new TerrainType("radiation", "radiation", true, 1, false, false, -100);
    public static TerrainType upExit = new TerrainType("up exit", "upExit", true, 0, false, false, -100);
    public static TerrainType downExit = new TerrainType("down exit", "downExit", true, 0, false, false, -100);
    public static TerrainType boulder = new TerrainType("boulder", "boulder", true, 1, false, false, -100);
    public static TerrainType web = new TerrainType("web", "web", true, 0, false, false, 10);
    public static TerrainType vengefulSymbol = new TerrainType("vengeful symbol", "vengefulSymbol", true, 0, false, false, 15);
    public static TerrainType deathFog = new TerrainType("death fog", "deathFog", true, 0, false, false, 18);
    public static TerrainType fire = new TerrainType("fire", "fire", true, 0, false, false, 18);
    public static TerrainType trollCarcass = new TerrainType("troll carcass", null, true, 0, false, false, 15);
    public static TerrainType landMine = new TerrainType("land mine", null, true, 0, false, false, -100);
    public static TerrainType bones = new TerrainType("bones", "bones", true, 0, false, false, 4);
    public static TerrainType crusher = new TerrainType("crusher", null, true, 0, false, false, -100);
    public static TerrainType fogPlacer = new TerrainType("fog placer", null, true, 0, false, false, -100);
    public static TerrainType chest = new TerrainType("chest", "chest", true, 1, false, false, 6);
    public static TerrainType fountain = new TerrainType("fountain", "fountain", true, 1, true, false, 6);
    public static TerrainType statue = new TerrainType("statue", "statue", true, 1, true, false, 2);
    public static TerrainType garden = new TerrainType("garden", "garden", true, 1, false, false, 12);
    public static TerrainType library = new TerrainType("library", "library", true, 1, false, false, 12);
    public static TerrainType sphinx = new TerrainType("sphinx", "sphinx", true, 1, false, false, -6);
    public static TerrainType mirroredBall = new TerrainType("mirrored ball", "mirroredBall", true, 1, false, false, 14);
    public static TerrainType mine = new TerrainType("mine", "mine", true, 1, true, false, -10);
    public static TerrainType moatLever = new TerrainType("moat lever", "moatLever", true, 1, false, false, 8);
    public static TerrainType repairMachine = new TerrainType("repair machine", "repairMachine", true, 1, false, false, 8);
    public static TerrainType vendingMachine = new TerrainType("vending machine", "vendingMachine", true, 4, false, false, 8);
    public static TerrainType brokenVendingMachine = new TerrainType("broken vending machine", "vendingMachine", true, 0, false, false, 8);
    public static TerrainType robotCommandInterface = new TerrainType("robot command interface", "robotCommandInterface", true, 4, false, false, 12);
    public static TerrainType holographicTrainer = new TerrainType("holographic trainer", "holographicTrainer", true, 2, false, false, 14);
    public static TerrainType rocks = new TerrainType("rocks", "rocks", false, 0, false, false, -100);
    public static TerrainType bush = new TerrainType("bush", "bush", true, 0, false, false, 14);
    public static TerrainType table = new TerrainType("table", "table", false, 0, false, false, 14);
    public static TerrainType altar = new TerrainType("altar", "altar", false, 0, false, false, 8);
    public static TerrainType crate = new TerrainType("crate", "crate", false, 0, false, false, 10);
    public static TerrainType tallTree = new TerrainType("tall tree", "tallTree", false, 0, false, false, 6);
    public static TerrainType vacuumHole = new TerrainType("vacuum hole", "vacuumHole", true, 0, false, false, -100);
    public static TerrainType throne = new TerrainType("throne", "throne", true, 0, false, false, -100);
    public static TerrainType pillar = new TerrainType("pillar", "pillar", false, 0, false, false, -10);
    public static TerrainType kiln = new TerrainType("kiln", "kiln", false, 0, false, false, 5);
    public static TerrainType machinery1 = new TerrainType("machinery 1", "machinery1", false, 0, false, false, 5);
    public static TerrainType machinery2 = new TerrainType("machinery 2", "machinery2", false, 0, false, false, 5);
    public static TerrainType damageTrap = new TerrainType("damage trap", null, true, 6, false, true, -100);
    public static TerrainType fireballTrap = new TerrainType("fireball trap", null, true, 2, false, true, -100);
    public static TerrainType teleportTrap = new TerrainType("teleport trap", null, true, 1, false, true, -100);
    public static TerrainType gasserTrap = new TerrainType("gasser trap", null, true, 1, false, true, -100);
    public static TerrainType gustOfWindTrap = new TerrainType("gust of wind trap", null, true, 3, false, true, -100);
    public static TerrainType lightningBoltTrap = new TerrainType("lightning bolt trap", null, true, 2, false, true, -100);

    public TerrainType(String name, String imageName, boolean passible, int frequency, boolean firesPlayerAtEvents, boolean trap, int avoidance) {
        super(name, imageName);
        this.passible = passible;
        this.frequency = frequency;
        this.firesPlayerAtEvents = firesPlayerAtEvents;
        this.trap = trap;
        this.avoidance = avoidance;
        this.talks = this == repairMachine || this == brokenVendingMachine || this == vendingMachine;
        this.sells = this == vendingMachine;
        this.fixes = this == repairMachine;
        this.doDetmSize();
        if (trap) {
            trapTypes.add(this);
        } else {
            nonTrapTypes.add(this);
        }
        types.add(this);
        typesMap.put(name, this);
    }

    public boolean equals(TerrainType type) {
        return type == this || type.name.equals(this.name);
    }

    public MapEntity doCreateStockInstance() {
        return TerrainFactory.doCreateTerrain(this);
    }

    public boolean isValidForMap(Map map) {
        if (this.equals(boulder) && map.getLevel().getIndex() < MapLevel.ruins.getIndex()) {
            return false;
        }
        if ((this.equals(robotCommandInterface) || this.equals(holographicTrainer)) && map.getLevel().getIndex() < MapLevel.moon.getIndex()) {
            return false;
        }
        if (this.equals(vendingMachine) && map.getLevel().getIndex() < MapLevel.base.getIndex()) {
            return false;
        }
        if (this.equals(vendingMachine) || this.equals(radiation) || this.equals(repairMachine) ? !map.getMotif().isTech() : !this.trap && map.getMotif().isTech()) {
            return false;
        }
        if (this.equals(fireballTrap) && map.getLevel().getIndex() < MapLevel.swamp1.getIndex()) {
            return false;
        }
        if (this.equals(lightningBoltTrap) && map.getLevel().getIndex() < MapLevel.city.getIndex()) {
            return false;
        }
        if (this.equals(gasserTrap) && map.getLevel().getIndex() < MapLevel.dungeonB1.getIndex()) {
            return false;
        }
        return !this.equals(gustOfWindTrap) || !map.getLevel().isSelfLit();
    }

    protected boolean isPresenceLocationValid(Map map, MapPixelLocation location) {
        if (map.getFirstTerrainAt(location) != null) {
            return false;
        }
        Tile tile = map.getTile(location);
        if (this.equals(chest) && !tile.equals(Tile.roomFloor)) {
            return false;
        }
        return !(this.trap ? !tile.equals(Tile.floor) : !tile.isPassible() || tile.getBlocksLOS());
    }

    public boolean getFiresPlayerAtEvents() {
        return this.firesPlayerAtEvents;
    }

    public boolean getFixes() {
        return this.fixes;
    }

    public boolean isPassible() {
        return this.passible;
    }

    public boolean getSells() {
        return this.sells;
    }

    public boolean getTalks() {
        return this.talks;
    }

    public boolean isTrap() {
        return this.trap;
    }

    protected String getImagePath() {
        return "terrain/";
    }

    public int getAvoidance() {
        return this.avoidance;
    }
}

