/*
 * Decompiled with CFR 0.152.
 */
package silmar.entities.items.weapons;

import java.util.ArrayList;
import java.util.List;
import silmar.entities.beings.attacks.AttackType;
import silmar.entities.beings.attacks.PenetrationType;
import silmar.entities.damage.DamageForm;
import silmar.entities.items.EquipLocation;
import silmar.entities.items.types.ItemType;
import silmar.map.Map;
import silmar.map.MapLevel;
import silmar.map.MapTileDistance;

public final class WeaponType
extends ItemType {
    private int minDamage;
    private int maxDamage;
    private int toHitModifier;
    private int damageModifier;
    private boolean ranged;
    private MapTileDistance maxRange;
    private ItemType ammoType;
    private boolean edged;
    private PenetrationType penetrationType;
    private int numAttacks;
    private AttackType attackType;
    private DamageForm damageForm;
    public static final List types = new ArrayList();
    protected static final String bluntInfo = "Is a blunt weapon.";
    public static WeaponType hand = new WeaponType("hand", null, "hand", 0.0f, false, 0, false, 0, 0, false, null, 1, 2, 0, 0, false, 0, null, false, PenetrationType.normal, 1, DamageForm.bluntImpact);
    public static WeaponType dagger = new WeaponType("dagger", null, "dagger", 1.0f, false, 7, true, 1, 2, false, null, 1, 4, 0, 0, false, 0, null, true, PenetrationType.normal, 1, DamageForm.slash);
    public static WeaponType daggerM5 = WeaponType.doCreateMagicalWeaponType(dagger, -5);
    public static WeaponType daggerM4 = WeaponType.doCreateMagicalWeaponType(dagger, -4);
    public static WeaponType daggerM3 = WeaponType.doCreateMagicalWeaponType(dagger, -3);
    public static WeaponType daggerM2 = WeaponType.doCreateMagicalWeaponType(dagger, -2);
    public static WeaponType daggerM1 = WeaponType.doCreateMagicalWeaponType(dagger, -1);
    public static WeaponType daggerP1 = WeaponType.doCreateMagicalWeaponType(dagger, 1);
    public static WeaponType daggerP2 = WeaponType.doCreateMagicalWeaponType(dagger, 2);
    public static WeaponType daggerP3 = WeaponType.doCreateMagicalWeaponType(dagger, 3);
    public static WeaponType daggerP4 = WeaponType.doCreateMagicalWeaponType(dagger, 4);
    public static WeaponType daggerP5 = WeaponType.doCreateMagicalWeaponType(dagger, 5);
    public static WeaponType club = new WeaponType("club", null, "club", 3.0f, false, 16, false, 7, 1, false, null, 1, 5, 0, 0, false, 0, null, false, PenetrationType.normal, 1, DamageForm.bluntImpact);
    public static WeaponType clubOfImpact = WeaponType.doCreateMagicalWeaponType(club, 4, "club of impact +4");
    public static WeaponType mace = new WeaponType("mace", null, "mace", 10.0f, false, 7, true, 9, 10, false, null, 2, 7, 0, 0, false, 0, null, false, PenetrationType.normal, 1, DamageForm.bluntImpact);
    public static WeaponType maceM5 = WeaponType.doCreateMagicalWeaponType(mace, -5);
    public static WeaponType maceM4 = WeaponType.doCreateMagicalWeaponType(mace, -4);
    public static WeaponType maceM3 = WeaponType.doCreateMagicalWeaponType(mace, -3);
    public static WeaponType maceM2 = WeaponType.doCreateMagicalWeaponType(mace, -2);
    public static WeaponType maceM1 = WeaponType.doCreateMagicalWeaponType(mace, -1);
    public static WeaponType maceP1 = WeaponType.doCreateMagicalWeaponType(mace, 1);
    public static WeaponType maceP2 = WeaponType.doCreateMagicalWeaponType(mace, 2);
    public static WeaponType maceP3 = WeaponType.doCreateMagicalWeaponType(mace, 3);
    public static WeaponType maceP4 = WeaponType.doCreateMagicalWeaponType(mace, 4);
    public static WeaponType maceP5 = WeaponType.doCreateMagicalWeaponType(mace, 5);
    public static WeaponType maceOfPurity = WeaponType.doCreateMagicalWeaponType(mace, 3, "mace of purity +3");
    public static WeaponType greatMace = new WeaponType("great mace", null, "greatMace", 20.0f, true, 6, true, 11, 20, false, null, 2, 10, 0, 0, false, 0, null, false, PenetrationType.normal, 1, DamageForm.bluntImpact);
    public static WeaponType greatMaceM5 = WeaponType.doCreateMagicalWeaponType(greatMace, -5);
    public static WeaponType greatMaceM4 = WeaponType.doCreateMagicalWeaponType(greatMace, -4);
    public static WeaponType greatMaceM3 = WeaponType.doCreateMagicalWeaponType(greatMace, -3);
    public static WeaponType greatMaceM2 = WeaponType.doCreateMagicalWeaponType(greatMace, -2);
    public static WeaponType greatMaceM1 = WeaponType.doCreateMagicalWeaponType(greatMace, -1);
    public static WeaponType greatMaceP1 = WeaponType.doCreateMagicalWeaponType(greatMace, 1);
    public static WeaponType greatMaceP2 = WeaponType.doCreateMagicalWeaponType(greatMace, 2);
    public static WeaponType greatMaceP3 = WeaponType.doCreateMagicalWeaponType(greatMace, 3);
    public static WeaponType greatMaceP4 = WeaponType.doCreateMagicalWeaponType(greatMace, 4);
    public static WeaponType greatMaceP5 = WeaponType.doCreateMagicalWeaponType(greatMace, 5);
    public static WeaponType staff = new WeaponType("staff", null, "staff", 5.0f, true, 18, false, 3, 2, false, null, 1, 6, 0, 0, false, 0, null, false, PenetrationType.normal, 1, DamageForm.bluntImpact);
    public static WeaponType staffM3 = WeaponType.doCreateMagicalWeaponType(staff, -3);
    public static WeaponType staffM2 = WeaponType.doCreateMagicalWeaponType(staff, -2);
    public static WeaponType staffM1 = WeaponType.doCreateMagicalWeaponType(staff, -1);
    public static WeaponType staffP1 = WeaponType.doCreateMagicalWeaponType(staff, 1);
    public static WeaponType staffP2 = WeaponType.doCreateMagicalWeaponType(staff, 2);
    public static WeaponType staffP3 = WeaponType.doCreateMagicalWeaponType(staff, 3);
    public static WeaponType staffOfHarming = WeaponType.doCreateMagicalWeaponType(staff, 3, "staff of harming +3");
    public static WeaponType shortSword = new WeaponType("short sword", null, "shortSword", 4.0f, false, 7, true, 7, 10, false, null, 1, 7, 0, 0, false, 0, null, true, PenetrationType.normal, 1, DamageForm.slash);
    public static WeaponType shortSwordM5 = WeaponType.doCreateMagicalWeaponType(shortSword, -5);
    public static WeaponType shortSwordM4 = WeaponType.doCreateMagicalWeaponType(shortSword, -4);
    public static WeaponType shortSwordM3 = WeaponType.doCreateMagicalWeaponType(shortSword, -3);
    public static WeaponType shortSwordM2 = WeaponType.doCreateMagicalWeaponType(shortSword, -2);
    public static WeaponType shortSwordM1 = WeaponType.doCreateMagicalWeaponType(shortSword, -1);
    public static WeaponType shortSwordP1 = WeaponType.doCreateMagicalWeaponType(shortSword, 1);
    public static WeaponType shortSwordP2 = WeaponType.doCreateMagicalWeaponType(shortSword, 2);
    public static WeaponType shortSwordP3 = WeaponType.doCreateMagicalWeaponType(shortSword, 3);
    public static WeaponType shortSwordP4 = WeaponType.doCreateMagicalWeaponType(shortSword, 4);
    public static WeaponType shortSwordP5 = WeaponType.doCreateMagicalWeaponType(shortSword, 5);
    public static WeaponType longSword = new WeaponType("long sword", null, "longSword", 6.0f, false, 7, true, 9, 17, false, null, 1, 10, 0, 0, false, 0, null, true, PenetrationType.normal, 1, DamageForm.slash);
    public static WeaponType longSwordM5 = WeaponType.doCreateMagicalWeaponType(longSword, -5);
    public static WeaponType longSwordM4 = WeaponType.doCreateMagicalWeaponType(longSword, -4);
    public static WeaponType longSwordM3 = WeaponType.doCreateMagicalWeaponType(longSword, -3);
    public static WeaponType longSwordM2 = WeaponType.doCreateMagicalWeaponType(longSword, -2);
    public static WeaponType longSwordM1 = WeaponType.doCreateMagicalWeaponType(longSword, -1);
    public static WeaponType longSwordP1 = WeaponType.doCreateMagicalWeaponType(longSword, 1);
    public static WeaponType longSwordP2 = WeaponType.doCreateMagicalWeaponType(longSword, 2);
    public static WeaponType longSwordP3 = WeaponType.doCreateMagicalWeaponType(longSword, 3);
    public static WeaponType longSwordP4 = WeaponType.doCreateMagicalWeaponType(longSword, 4);
    public static WeaponType longSwordP5 = WeaponType.doCreateMagicalWeaponType(longSword, 5);
    public static WeaponType twoHandedSword = new WeaponType("two-handed sword", null, "twoHandedSword", 23.0f, true, 7, true, 13, 35, false, null, 2, 14, 0, 0, false, 0, null, true, PenetrationType.normal, 1, DamageForm.slash);
    public static WeaponType twoHandedSwordM5 = WeaponType.doCreateMagicalWeaponType(twoHandedSword, -5);
    public static WeaponType twoHandedSwordM4 = WeaponType.doCreateMagicalWeaponType(twoHandedSword, -4);
    public static WeaponType twoHandedSwordM3 = WeaponType.doCreateMagicalWeaponType(twoHandedSword, -3);
    public static WeaponType twoHandedSwordM2 = WeaponType.doCreateMagicalWeaponType(twoHandedSword, -2);
    public static WeaponType twoHandedSwordM1 = WeaponType.doCreateMagicalWeaponType(twoHandedSword, -1);
    public static WeaponType twoHandedSwordP1 = WeaponType.doCreateMagicalWeaponType(twoHandedSword, 1);
    public static WeaponType twoHandedSwordP2 = WeaponType.doCreateMagicalWeaponType(twoHandedSword, 2);
    public static WeaponType twoHandedSwordP3 = WeaponType.doCreateMagicalWeaponType(twoHandedSword, 3);
    public static WeaponType twoHandedSwordP4 = WeaponType.doCreateMagicalWeaponType(twoHandedSword, 4);
    public static WeaponType twoHandedSwordP5 = WeaponType.doCreateMagicalWeaponType(twoHandedSword, 5);
    public static WeaponType sling = new WeaponType("sling", null, "sling", 1.0f, false, 16, false, 3, 1, false, null, 1, 4, 0, 0, true, 12, ItemType.slingStone, false, PenetrationType.normal, 1, DamageForm.bluntImpact);
    public static WeaponType slingOfHoming = WeaponType.doCreateMagicalWeaponType(sling, 0, "sling of homing");
    public static WeaponType bow = new WeaponType("bow", null, "bow", 4.0f, true, 12, false, 8, 75, false, null, 1, 6, 0, 0, true, 20, ItemType.arrow, true, PenetrationType.normal, 2, DamageForm.pierce);
    public static WeaponType bowM5 = WeaponType.doCreateMagicalWeaponType(bow, -5);
    public static WeaponType bowM4 = WeaponType.doCreateMagicalWeaponType(bow, -4);
    public static WeaponType bowM3 = WeaponType.doCreateMagicalWeaponType(bow, -3);
    public static WeaponType bowM2 = WeaponType.doCreateMagicalWeaponType(bow, -2);
    public static WeaponType bowM1 = WeaponType.doCreateMagicalWeaponType(bow, -1);
    public static WeaponType bowP1 = WeaponType.doCreateMagicalWeaponType(bow, 1);
    public static WeaponType bowP2 = WeaponType.doCreateMagicalWeaponType(bow, 2);
    public static WeaponType bowP3 = WeaponType.doCreateMagicalWeaponType(bow, 3);
    public static WeaponType bowP4 = WeaponType.doCreateMagicalWeaponType(bow, 4);
    public static WeaponType bowP5 = WeaponType.doCreateMagicalWeaponType(bow, 5);
    public static WeaponType strengthBow = WeaponType.doCreateMagicalWeaponType(bow, 3, "strength bow +3");
    public static WeaponType crossbow = new WeaponType("crossbow", null, "crossbow", 10.0f, true, 10, true, 9, 24, false, "Achieves a high penetration level.", 2, 7, 0, 0, true, 30, ItemType.quarrel, true, PenetrationType.normal, 1, DamageForm.pierce);
    public static WeaponType crossbowM5 = WeaponType.doCreateMagicalWeaponType(crossbow, -5);
    public static WeaponType crossbowM4 = WeaponType.doCreateMagicalWeaponType(crossbow, -4);
    public static WeaponType crossbowM3 = WeaponType.doCreateMagicalWeaponType(crossbow, -3);
    public static WeaponType crossbowM2 = WeaponType.doCreateMagicalWeaponType(crossbow, -2);
    public static WeaponType crossbowM1 = WeaponType.doCreateMagicalWeaponType(crossbow, -1);
    public static WeaponType crossbowP1 = WeaponType.doCreateMagicalWeaponType(crossbow, 1);
    public static WeaponType crossbowP2 = WeaponType.doCreateMagicalWeaponType(crossbow, 2);
    public static WeaponType crossbowP3 = WeaponType.doCreateMagicalWeaponType(crossbow, 3);
    public static WeaponType crossbowP4 = WeaponType.doCreateMagicalWeaponType(crossbow, 4);
    public static WeaponType crossbowP5 = WeaponType.doCreateMagicalWeaponType(crossbow, 5);
    public static WeaponType crossbowOfQuickness = WeaponType.doCreateMagicalWeaponType(crossbow, 3, "crossbow of quickness +3");
    public static WeaponType pistol = new WeaponType("pistol", "strange ranged weapon", "pistol", 3.0f, false, 10, true, 1, 2000, true, null, 1, 5, 0, 0, true, 20, ItemType.pistolBullet, true, PenetrationType.firearm, 3, DamageForm.pierce);
    public static WeaponType shotgun = new WeaponType("shotgun", "strange ranged weapon", "shotgun", 10.0f, true, 10, true, 2, 3000, true, null, 3, 20, 0, 0, true, 6, ItemType.shotgunShell, true, PenetrationType.firearm, 2, DamageForm.pierce);
    public static WeaponType assaultRifle = new WeaponType("assault rifle", "strange ranged weapon", "assaultRifle", 15.0f, true, 9, true, 2, 4000, true, null, 1, 7, 0, 0, true, 30, ItemType.assaultRifleBullet, true, PenetrationType.firearm, 4, DamageForm.pierce);
    public static WeaponType stunWhip = new WeaponType("stun whip", "strange whip", "stunWhip", 2.0f, false, 9, true, 3, 4000, true, "May degrade with each use.", 1, 1, 0, 0, false, 0, null, true, PenetrationType.normal, 1, DamageForm.electricity);
    public static WeaponType energySaber = new WeaponType("energy saber", "strange sword", "energySaber", 3.0f, false, 6, true, 5, 8000, true, "May degrade with each use.", 5, 22, 0, 0, false, 0, null, true, PenetrationType.laser, 1, DamageForm.laser);
    public static WeaponType laserPistol = new WeaponType("laser pistol", "strange ranged weapon", "laserPistol", 3.0f, false, 7, true, 1, 4000, true, null, 2, 7, 0, 0, true, 30, ItemType.laserPistolCell, true, PenetrationType.laser, 3, DamageForm.laser);
    public static WeaponType laserAssaultRifle = new WeaponType("laser assault rifle", "strange ranged weapon", "laserAssaultRifle", 15.0f, true, 7, true, 2, 5000, true, null, 2, 10, 0, 0, true, 40, ItemType.laserAssaultRifleCell, true, PenetrationType.laser, 4, DamageForm.laser);

    public WeaponType(String name, String unidentifiedName, String imageName, float encumbrance, boolean takesTwoHands, int avoidance, boolean metal, int strengthRequired, int placementValue, boolean tech, String info, int minDamage, int maxDamage, int toHitBonus, int damageBonus, boolean ranged, int maxRange, ItemType ammoType, boolean edged, PenetrationType penetrationType, int numAttacks, DamageForm damageForm) {
        super(name, imageName);
        this.unidentifiedName = unidentifiedName;
        this.equipLocation = EquipLocation.rightHand;
        this.encumbrance = encumbrance;
        this.takesTwoHands = takesTwoHands;
        this.avoidance = avoidance;
        this.metal = metal;
        this.strengthRequired = strengthRequired;
        this.placementValue = placementValue;
        this.tech = tech;
        this.info = info;
        this.frequency = WeaponType.getFrequencyForValue(placementValue);
        this.chanceOfInChest = WeaponType.getChanceOfInChest(placementValue);
        this.minDamage = minDamage;
        this.maxDamage = maxDamage;
        this.toHitModifier = toHitBonus;
        this.damageModifier = damageBonus;
        this.ranged = ranged;
        this.maxRange = new MapTileDistance(maxRange);
        this.ammoType = ammoType;
        this.edged = edged;
        this.penetrationType = penetrationType;
        this.numAttacks = numAttacks;
        this.damageForm = damageForm;
        types.add(this);
        this.detmAttackType();
    }

    protected static WeaponType doCreateMagicalWeaponType(WeaponType normalType, int plus) {
        return WeaponType.doCreateMagicalWeaponType(normalType, plus, null);
    }

    protected static WeaponType doCreateMagicalWeaponType(WeaponType normalType, int plus, String name) {
        WeaponType type = (WeaponType)normalType.doMakeClone(name != null ? name : WeaponType.doAlterNameForPlus(normalType.name, plus));
        type.individuallyIdentified = true;
        WeaponType.doModifyTypeForPlus(type, normalType, plus);
        type.toHitModifier = plus;
        type.damageModifier = plus;
        types.add(type);
        return type;
    }

    protected void detmAttackType() {
        this.attackType = !this.ranged ? AttackType.meleeAttack : (this.penetrationType.equals(PenetrationType.laser) ? AttackType.laserCell : (this.penetrationType.equals(PenetrationType.firearm) && !this.isDescendedFromType(crossbow) ? AttackType.bullet : AttackType.oldProjectile));
    }

    public boolean isValidForMap(Map map) {
        if ((this.equals(shotgun) || this.equals(assaultRifle)) && map.getLevel().getIndex() < MapLevel.base.getIndex()) {
            return false;
        }
        if ((this.equals(stunWhip) || this.equals(energySaber) || this.equals(laserPistol) || this.equals(laserAssaultRifle)) && map.getLevel().getIndex() < MapLevel.moon.getIndex()) {
            return false;
        }
        return super.isValidForMap(map);
    }

    public ItemType getAmmoType() {
        return this.ammoType;
    }

    public AttackType getAttackType() {
        return this.attackType;
    }

    public DamageForm getDamageForm() {
        return this.damageForm;
    }

    public int getDamageModifier() {
        return this.damageModifier;
    }

    public boolean isEdged() {
        return this.edged;
    }

    public int getMaxDamage() {
        return this.maxDamage;
    }

    public MapTileDistance getMaxRange() {
        return this.maxRange;
    }

    public int getMinDamage() {
        return this.minDamage;
    }

    public int getNumAttacks() {
        return this.numAttacks;
    }

    public PenetrationType getPenetrationType() {
        return this.penetrationType;
    }

    public boolean isRanged() {
        return this.ranged;
    }

    public int getToHitModifier() {
        return this.toHitModifier;
    }

    public String getInfo() {
        String itemInfo = super.getInfo();
        StringBuffer info = new StringBuffer(itemInfo != null ? itemInfo : "");
        if (!this.edged) {
            if (info.length() > 0) {
                info.append("<br>");
            }
            info.append(bluntInfo);
        }
        if (this.numAttacks > 1) {
            if (info.length() > 0) {
                info.append("<br>");
            }
            info.append("Allows ");
            info.append(this.numAttacks);
            info.append(" attacks per turn.");
        }
        return info.length() > 0 ? info.toString() : null;
    }

    static {
        WeaponType.hand.frequency = 0;
        WeaponType.clubOfImpact.encumbrance = 7.0f;
        WeaponType.clubOfImpact.takesTwoHands = true;
        WeaponType.clubOfImpact.avoidance = 10;
        WeaponType.clubOfImpact.metal = true;
        WeaponType.clubOfImpact.strengthRequired = 16;
        WeaponType.clubOfImpact.placementValue += 5000;
        WeaponType.clubOfImpact.info = "Knocks opponents back according to the wielder's strength.  Those knocked into something take further damage.";
        WeaponType.maceOfPurity.placementValue += 3000;
        WeaponType.maceOfPurity.info = "Does massive extra damage against living dead creatures.";
        WeaponType.staffOfHarming.placementValue += 1000;
        WeaponType.staffOfHarming.info = "May degrade with each use.";
        WeaponType.slingOfHoming.unidentifiedName = "magnificent sling";
        WeaponType.slingOfHoming.placementValue += 4000;
        WeaponType.slingOfHoming.toHitModifier = 40;
        WeaponType.slingOfHoming.info = "Always hits.";
        WeaponType.slingOfHoming.frequency /= 5;
        WeaponType.strengthBow.placementValue += 5000;
        WeaponType.strengthBow.info = "Lets the wielder add his strength-related bonuses to-hit and to damage.  " + WeaponType.strengthBow.info;
        WeaponType.crossbowOfQuickness.placementValue += 3000;
        WeaponType.crossbowOfQuickness.numAttacks = 2;
    }
}

