/*
 * Decompiled with CFR 0.152.
 */
package silmar.entities.items.weapons;

import silmar.entities.beings.Being;
import silmar.entities.beings.attacks.PenetrationType;
import silmar.entities.beings.player.Inventory;
import silmar.entities.items.Item;
import silmar.entities.items.types.ItemType;
import silmar.entities.items.weapons.WeaponType;

public class Weapon
extends Item {
    public void onHitVictim(Being victim, Being wielder, int damage) {
    }

    public void onStruckSlime() {
        this.doAvoidOrDegrade(0);
    }

    public boolean getCanHit(int plusNeededToHit) {
        WeaponType type = this.getWeaponType();
        if (type.getToHitModifier() >= plusNeededToHit) {
            return true;
        }
        if (type.getPenetrationType().equals(PenetrationType.firearm) && plusNeededToHit <= 2) {
            return true;
        }
        return type.getPenetrationType().equals(PenetrationType.laser) && plusNeededToHit <= 4;
    }

    public Item doCreateAmmoItem() {
        WeaponType type = this.getWeaponType();
        ItemType ammoType = type.getAmmoType();
        if (ammoType != null) {
            return ammoType.doCreateInstance();
        }
        return null;
    }

    public WeaponType getWeaponType() {
        return (WeaponType)this.type;
    }

    public boolean isOfType(WeaponType type) {
        return type.equals(this.type);
    }

    public boolean getRequiresAmmo() {
        WeaponType type = this.getWeaponType();
        return type.getAmmoType() != null;
    }

    public Item getAmmo(Inventory inventory) {
        WeaponType type = this.getWeaponType();
        return inventory.getItemOfGroupableType(type.getAmmoType());
    }

    public boolean isWeapon() {
        return true;
    }
}

