/*
 * Decompiled with CFR 0.152.
 */
package silmar.entities.items;

import java.awt.Color;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import silmar.util.Random;

public final class ItemCondition
implements Serializable {
    private int index;
    private String name;
    private Color color;
    private float valueFraction;
    public static List conditions = new ArrayList();
    public static ItemCondition destroyed = new ItemCondition("destroyed", Color.white, 0.0f);
    public static ItemCondition poor = new ItemCondition("poor", new Color(140, 0, 0), 0.25f);
    public static ItemCondition fair = new ItemCondition("fair", new Color(150, 100, 0), 0.5f);
    public static ItemCondition good = new ItemCondition("good", new Color(0, 140, 0), 0.75f);
    public static ItemCondition excellent = new ItemCondition("excellent", Color.black, 1.0f);

    public static ItemCondition getCondition(int index) {
        return (ItemCondition)conditions.get(index);
    }

    public static ItemCondition getRandomCondition() {
        return (ItemCondition)conditions.get(Random.getInt(1, conditions.size() - 1));
    }

    public ItemCondition(String name, Color color, float valueFraction) {
        this.name = name;
        this.color = color;
        this.valueFraction = valueFraction;
        conditions.add(this);
        this.index = conditions.size() - 1;
    }

    public boolean isWorseThan(ItemCondition condition) {
        return this.index < condition.index;
    }

    public int getIndex() {
        return this.index;
    }

    public String getName() {
        return this.name;
    }

    public Color getColor() {
        return this.color;
    }

    public float getValueFraction() {
        return this.valueFraction;
    }

    public float getQuantityFractionalDifference(ItemCondition oldCondition) {
        float difference = ((float)oldCondition.getIndex() - (float)this.index) / (float)(conditions.size() - 1);
        float excellentToOldRatio = (float)excellent.getIndex() / (float)oldCondition.getIndex();
        return difference * excellentToOldRatio;
    }

    public boolean equals(ItemCondition condition) {
        return condition.index == this.index;
    }
}

