/*
 * Decompiled with CFR 0.152.
 */
package silmar.entities.items;

import java.awt.Dimension;
import java.awt.Image;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import silmar.Sound;
import silmar.entities.MapEntity;
import silmar.entities.beings.player.Player;
import silmar.entities.damage.Damage;
import silmar.entities.damage.DamageForm;
import silmar.entities.items.ItemCondition;
import silmar.entities.items.ItemValueContext;
import silmar.entities.items.types.ItemType;
import silmar.entities.terrains.TerrainFactory;
import silmar.entities.terrains.TerrainType;
import silmar.entities.terrains.Terrains;
import silmar.game.Game;
import silmar.map.Map;
import silmar.map.MapLevel;
import silmar.map.MapPixelLocation;
import silmar.map.effects.Poof;
import silmar.util.Random;

public class Item
extends MapEntity
implements Cloneable {
    protected transient ItemType type;
    protected String typeName;
    protected final Condition condition = new Condition();
    protected final Quantity quantity = new Quantity();
    protected final Identified identified = new Identified();
    protected Player holder;

    private void writeObject(ObjectOutputStream s) throws IOException {
        this.typeName = this.type.getName();
        s.defaultWriteObject();
    }

    private void readObject(ObjectInputStream stream) throws IOException {
        try {
            stream.defaultReadObject();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        this.type = ItemType.getType(this.typeName);
    }

    public final boolean isIdentified() {
        return this.identified.get();
    }

    public final int getQuantity() {
        return this.quantity.get();
    }

    public void setQuantity(int quantity) {
        if (quantity < 0) {
            quantity = 0;
        }
        this.quantity.set(quantity);
    }

    protected void doRemove() {
        if (this.holder != null) {
            this.holder.onItemRemoved(this);
            this.holder = null;
        } else if (this.map != null) {
            this.map.doRemoveEntity(this);
        }
    }

    public void doRemoveQuantity(int amount) {
        this.setQuantity(this.getQuantity() - amount);
    }

    public void doRemoveFraction(float fraction) {
        this.setQuantity((int)((float)this.getQuantity() * (1.0f - fraction)));
    }

    public final float getEncumbrance() {
        return this.type.getEncumbrance() * (float)this.quantity.get();
    }

    public void setCondition(ItemCondition condition) {
        this.condition.set(condition);
    }

    public void doDegrade() {
        this.doDegrade(true);
    }

    public void doDegrade(boolean alertHolder) {
        this.condition.set(ItemCondition.getCondition(this.condition.get().getIndex() - 1), alertHolder);
    }

    public final String getName() {
        boolean identified = this.isIdentified();
        if (this.quantity.get() > 1 && identified) {
            return this.type.getPluralName();
        }
        if (identified) {
            return this.type.getName();
        }
        return this.type.getUnidentifiedName();
    }

    public boolean getHasUseEffect() {
        return false;
    }

    public void doDestroy() {
        this.doDestroy(true);
    }

    public void doDestroy(boolean alertHolder) {
        this.condition.set(ItemCondition.destroyed, alertHolder);
    }

    protected void doAvoidOrDegrade(int penalty) {
        int roll = Random.getInt(1, 20);
        int failedBy = this.type.getAvoidance() - (roll + this.type.getAvoidanceModifier() - penalty);
        if (failedBy > 0 && failedBy < 8) {
            this.doDegrade();
        } else if (failedBy >= 8) {
            this.doDestroy();
        }
    }

    public String getImageName() {
        return "items/" + this.type.getImageName();
    }

    public final int getValue(ItemValueContext valueContext) {
        if (valueContext.isZeroValueIfCursed() && this.type.isCursed()) {
            return 0;
        }
        if (!valueContext.equals(ItemValueContext.experience) && this.type.equals(ItemType.gold)) {
            return this.getQuantity();
        }
        if (valueContext.equals(ItemValueContext.repair)) {
            return (int)((float)this.type.getPlacementValue() * (1.0f - this.condition.get().getValueFraction()) * valueContext.getValueFraction());
        }
        return (int)((float)(this.type.getPlacementValue() * this.getQuantity()) * this.condition.get().getValueFraction() * valueContext.getValueFraction());
    }

    public boolean getCanBeRepaired() {
        return this.condition.get().isWorseThan(ItemCondition.excellent);
    }

    public final boolean isDestroyed() {
        return this.condition.get().equals(ItemCondition.destroyed);
    }

    public final ItemCondition getCondition() {
        return this.condition.get();
    }

    public void onCreated(ItemType type) {
        this.type = type;
        if (type.isGroupable()) {
            int quantity;
            if (type.equals(ItemType.gold)) {
                Game game = Game.getCurrentGame();
                quantity = MapLevel.getLevel(game.getFurthestLevelReached()).getAverageGoldItemQuantity();
            } else {
                quantity = type.getQuantityToCreate();
            }
            quantity = Random.getInt(2 * quantity / 3, 4 * quantity / 3);
            this.quantity.set(quantity);
        } else {
            this.condition.set(ItemCondition.getRandomCondition());
            this.identified.set(false);
        }
    }

    public final ItemType getType() {
        return this.type;
    }

    public final boolean isOfType(ItemType type) {
        return type.equals(this.type);
    }

    public void onGrabbedByBlob() {
        if (this.holder != null) {
            this.holder.onMessage("Your weapon is absorbed by the blob!");
        }
        this.doDestroy();
    }

    public void onWorked() {
        if (this.type.equals(ItemType.necklaceOfEssence)) {
            this.doDegrade();
        }
    }

    public void onHitByFireball(int strength) {
        this.doAvoidOrDegrade((this.type.isGroupable() ? 12 : 0) + strength / 2);
    }

    public void setIdentified(boolean newValue) {
        this.identified.set(newValue);
    }

    public void onRepaired() {
        this.condition.set(ItemCondition.excellent);
    }

    public boolean onHitByRusterAntenna(int strength) {
        if (!this.type.isMetal()) {
            return false;
        }
        this.doAvoidOrDegrade(strength / 2);
        return true;
    }

    public void onHitByDragonBreath(DamageForm breathType, int strength) {
        this.doAvoidOrDegrade(strength / 2 + (breathType.equals(DamageForm.acid) ? 6 : 0));
    }

    public void onHolderDamaged(Damage damage) {
        this.doAvoidOrDegrade((int)((float)damage.amount / 25.0f * (float)this.type.getAvoidance()) - this.type.getAvoidance());
    }

    public void onHitBySlime(int strength) {
        this.doAvoidOrDegrade(strength / 2);
    }

    public void onHitByDeathbotGrasp(int strength) {
        this.doAvoidOrDegrade(strength / 2);
    }

    public void onHitByVortexBeam(int strength) {
        this.doAvoidOrDegrade(strength / 2);
    }

    public Dimension getSize() {
        return this.type.getSize();
    }

    public void doRemoveOne() {
        this.setQuantity(this.getQuantity() - 1);
    }

    public void doAddQuantity(int quantity) {
        this.setQuantity(this.getQuantity() + quantity);
    }

    public final Player getHolder() {
        return this.holder;
    }

    public void setHolder(Player holder) {
        this.holder = holder;
    }

    public Image getImage() {
        return this.type.getImage();
    }

    public final String getInfo() {
        return this.identified.get() ? this.type.getInfo() : "Not yet identified.";
    }

    public void doCheckToPutSelfInChest() {
        float chance = this.type.getChanceOfInChest();
        if (chance > 0.0f && Random.getFloat() <= chance) {
            Map map = this.getMap();
            map.doRemoveEntity(this);
            Terrains.Chest chest = (Terrains.Chest)TerrainFactory.doCreateTerrain(TerrainType.chest);
            map.doAddEntity((MapEntity)chest, this.location);
            chest.setItem(this);
            chest.doCheckForBeingTrapped();
        }
    }

    public void onContainngChestDestroyed(int avoidanceFailedBy) {
        this.doAvoidOrDegrade(avoidanceFailedBy);
    }

    public boolean isWeapon() {
        return false;
    }

    public boolean isItem() {
        return true;
    }

    public static interface Usable {
        public void onUsed(Player var1);
    }

    protected class Identified
    implements Serializable {
        private boolean identified = true;

        protected Identified() {
        }

        public boolean get() {
            return this.identified || Item.this.type.getUnidentifiedName() == null || !Item.this.type.isIndividuallyIdentified() && Game.getCurrentGame().isItemTypeIdentified(Item.this.type);
        }

        public void set(boolean identified) {
            ItemType type;
            this.identified = identified;
            if (identified && !(type = Item.this.getType()).isIndividuallyIdentified()) {
                Game game = Game.getCurrentGame();
                game.onItemTypeIdentified(Item.this.getType());
            }
            if (Item.this.holder != null) {
                Item.this.holder.onHeldItemChanged();
            }
        }
    }

    protected class Quantity
    implements Serializable {
        private int quantity = 1;

        protected Quantity() {
        }

        public int get() {
            return this.quantity;
        }

        public void set(int quantity) {
            this.quantity = quantity;
            if (quantity <= 0) {
                Item.this.doRemove();
            } else if (Item.this.holder != null) {
                Item.this.holder.onHeldItemChanged();
            }
        }
    }

    protected class Condition
    implements Serializable {
        protected ItemCondition condition = ItemCondition.excellent;

        protected Condition() {
        }

        public ItemCondition get() {
            return this.condition;
        }

        public void set(ItemCondition condition) {
            this.set(condition, true);
        }

        public void set(ItemCondition condition, boolean alertHolder) {
            if (condition.equals(this.condition)) {
                return;
            }
            boolean worse = condition.isWorseThan(this.condition);
            boolean destroyed = condition.equals(ItemCondition.destroyed);
            if (alertHolder) {
                MapPixelLocation location;
                Map map = Item.this.holder != null ? Item.this.holder.getMap() : Item.this.getMap();
                MapPixelLocation mapPixelLocation = location = Item.this.holder != null ? Item.this.holder.getLocation() : Item.this.getLocation();
                if (map != null) {
                    map.onSoundIssued(worse ? Sound.itemDamaged : Sound.itemRepaired, location);
                }
                if (Item.this.holder != null) {
                    Item.this.holder.onMessage("Your " + Item.this.getName() + (Item.this.quantity.get() > 1 ? " are " : " is ") + (destroyed ? "destroyed" : (worse ? "damaged" : "repaired")) + "!");
                }
            }
            if (worse && !destroyed && Item.this.type.isGroupable()) {
                Item.this.doRemoveFraction(condition.getQuantityFractionalDifference(this.condition));
            }
            this.condition = condition;
            if (destroyed) {
                if (Item.this.holder == null) {
                    Poof.doPoof(Item.this.map, Item.this.location, Item.this.getSize());
                }
                Item.this.doRemove();
            } else if (Item.this.holder != null) {
                Item.this.holder.onHeldItemChanged();
            }
        }
    }
}

